/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.List;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.ceditor.JDevXmlCodeEditorGui;
import oracle.bali.xml.gui.jdev.palette.CodeEditorItemHandler;
import oracle.bali.xml.gui.swing.dnd.DropHandlerHelper;
import oracle.bali.xml.model.XmlView;
import oracle.ide.ceditor.DropHandlerPlugin;
import oracle.javatools.dnd.DndUtils;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.DragDropPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class CodeEditorDropHandler
extends DropHandlerPlugin {
    private final DropHandlerHelper _helper;

    public CodeEditorDropHandler(JDevXmlCodeEditorGui gui) {
        this._helper = new Helper((XmlGui)gui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performDrop(DropTargetDropEvent dropEvent) {
        XmlGui codeGui = this._helper.getGui();
        JDevXmlContext context = (JDevXmlContext)codeGui.getGuiContext();
        XmlGui wasActiveGui = context.getActiveGui();
        if (wasActiveGui == codeGui) {
            context.releaseActiveGui(codeGui);
        }
        try {
            boolean ok = this._helper.performDrop(dropEvent);
            this.raiseEditorToFront();
            boolean bl = ok;
            return bl;
        }
        finally {
            if (wasActiveGui == codeGui) {
                context.acquireActiveGui(codeGui);
            }
        }
    }

    protected void cancelDragEvent(DropTargetEvent event) {
        this._helper.cleanupDrop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Point getDropLocationToPaint(DropTargetDragEvent event) {
        XmlView view = this._helper.getView();
        view.acquireReadLock();
        try {
            Rectangle rect;
            int dropOffset;
            DomPosition dropPos = view.getSelection().getDropLocation();
            if (dropPos != null && (dropOffset = view.getDomModel().getTextOffset(dropPos)) >= 0 && (rect = this.getEditorPane().modelToView(dropOffset)) != null) {
                Point point = rect.getLocation();
                return point;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            view.releaseReadLock();
        }
        return super.getDropLocationToPaint(event);
    }

    protected int shouldAllowDrag(DropTargetDragEvent event) {
        if (this._shouldIgnore(event)) {
            return 0;
        }
        return this._helper.considerPossibilitiesAndSetLocation(event);
    }

    protected int shouldAllowDrop(DropTargetDropEvent event) {
        if (this._shouldIgnore(event)) {
            return 0;
        }
        return this._helper.considerPossibilities(event);
    }

    private boolean _shouldIgnore(DropTargetEvent event) {
        return DndUtils.isDataFlavorSupported((DropTargetEvent)event, (DataFlavor)DragDropPlugin.OUR_FLAVOR) && (DndUtils.isDataFlavorSupported((DropTargetEvent)event, (DataFlavor)DataFlavor.stringFlavor) || DndUtils.isDataFlavorSupported((DropTargetEvent)event, (DataFlavor)DataFlavor.getTextPlainUnicodeFlavor()));
    }

    private class Helper
    extends DropHandlerHelper {
        public Helper(XmlGui gui) {
            super(gui);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DomPosition getClosestDropPosition(Component dropComponent, Point location) {
            int offset;
            BasicEditorPane pane = CodeEditorDropHandler.this.getEditorPane();
            if (pane == dropComponent && (offset = pane.viewToModel(location)) >= 0) {
                this.getView().acquireReadLock();
                try {
                    DomPosition domPosition = CodeEditorItemHandler.getInsertionPositionAtOffset(this.getView().getBaseModel(), offset);
                    return domPosition;
                }
                finally {
                    this.getView().releaseReadLock();
                }
            }
            return null;
        }

        protected void findOtherClosePositions(Component dropComponent, Point location, DomPosition closestPosition, List out) {
            Document document;
            Element root;
            Node node;
            if (closestPosition != null && DomUtils.isDocument((Node)(node = closestPosition.getContainerNode(this.getView().getTreeTraversal()))) && (root = (document = (Document)node).getDocumentElement()) != null) {
                DomPosition newPosition = null;
                Node firstChild = root.getFirstChild();
                if (firstChild != null) {
                    DomModel domModel;
                    int rootOffset;
                    int offset = 0;
                    BasicEditorPane pane = CodeEditorDropHandler.this.getEditorPane();
                    if (pane == dropComponent) {
                        offset = pane.viewToModel(location);
                    }
                    if (offset <= (rootOffset = (domModel = this.getView().getDomModel()).getTextOffset(DomPositionFactory.before((Node)root)))) {
                        newPosition = DomPositionFactory.before((Node)firstChild);
                    } else {
                        Node lastChild = root.getLastChild();
                        newPosition = DomPositionFactory.after((Node)lastChild);
                    }
                } else {
                    newPosition = DomPositionFactory.inside((Node)root);
                }
                out.add(newPosition);
            }
        }
    }
}

