/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import oracle.bali.xml.addin.SchemaRegistryAddin;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.GuiXmlContextUtils;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevInspectableViewTracker;
import oracle.bali.xml.gui.jdev.JDevStatusBarGui;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.XmlController;
import oracle.bali.xml.gui.jdev.XmlGuiHostedJDevView;
import oracle.bali.xml.gui.jdev.util.JDevUtils;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import org.w3c.dom.Node;

public abstract class AbstractXmlVisualEditor
extends Editor
implements StatusProvider,
XmlGuiHostedJDevView {
    private JDevXmlContext _xmlContext;
    private final XmlUsage _usage;
    private final XmlController _controller;
    private final Listener _listener = new Listener();
    private static final Logger _LOGGER = Logger.getLogger(AbstractXmlVisualEditor.class.getName());

    protected AbstractXmlVisualEditor(XmlUsage usage) {
        this._usage = usage;
        this._controller = XmlController.getXmlController(usage);
        this.getLogger().log(Level.FINER, "AbstractXmlVisualEditor constructed: {0}", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelpInfo getHelpInfo() {
        XmlView view = this.getCurrentXmlView();
        if (view != null) {
            view.acquireReadLock();
            try {
                Selection selection = view.getSelection();
                if (!selection.isEmpty()) {
                    Node firstSelNode = selection.getEarliestSelectedNode();
                    String info = this.getCurrentXmlGui().getHelpTopic(firstSelNode, view.getNodeXmlKey(firstSelNode));
                    HelpInfo helpInfo = new HelpInfo(info);
                    return helpInfo;
                }
            }
            finally {
                view.releaseReadLock();
            }
        }
        return super.getHelpInfo();
    }

    public abstract Component getGUI();

    protected void handleXmlContextChange(JDevXmlContext oldXmlContext, JDevXmlContext newXmlContext) {
        XmlGui oldGui = GuiXmlContextUtils.getGui((GuiXmlContext)oldXmlContext, (XmlUsage)this.getXmlUsage(), (boolean)false);
        JDevStatusBarGui oldStatusGui = JDevUtils.getStatusGui(oldXmlContext, false);
        XmlGui newGui = GuiXmlContextUtils.getGui((GuiXmlContext)newXmlContext, (XmlUsage)this.getXmlUsage());
        JDevStatusBarGui newStatusGui = JDevUtils.getStatusGui(newXmlContext);
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().log(Level.FINER, "XmlContext on {0} changed from {1} to {2}", new Object[]{this, oldXmlContext, newXmlContext});
        }
        if (oldGui != null) {
            oldGui.hidden();
            oldGui.getView().removeModelListener((XmlModelListener)this._listener);
            if (oldGui instanceof JDevViewHostedGui) {
                ((JDevViewHostedGui)oldGui).setOwningJDevView(null);
            }
        }
        if (newGui != null) {
            if (newGui instanceof JDevViewHostedGui) {
                ((JDevViewHostedGui)newGui).setOwningJDevView((View)this);
            }
            newGui.getView().addModelListener((XmlModelListener)this._listener);
        }
        if (oldStatusGui != null) {
            oldStatusGui.hidden();
        }
        if (newStatusGui != null) {
            newStatusGui.shown();
        }
        if (newXmlContext != null) {
            SchemaRegistryAddin.loadSchema((Element)newXmlContext.getIdeDocument());
        }
        this._xmlContext = newXmlContext;
    }

    protected String getDynamicMenuName() {
        return null;
    }

    public final XmlUsage getXmlUsage() {
        return this._usage;
    }

    @Override
    public final XmlGui getCurrentXmlGui() {
        return GuiXmlContextUtils.getGui((GuiXmlContext)this.getCurrentXmlContext(), (XmlUsage)this.getXmlUsage());
    }

    protected JDevXmlContext getCurrentXmlContext() {
        return this._xmlContext;
    }

    protected final XmlModel getCurrentXmlModel() {
        return GuiXmlContextUtils.getModel((XmlContext)this.getCurrentXmlContext());
    }

    protected final XmlView getCurrentXmlView() {
        return GuiXmlContextUtils.getView((XmlContext)this.getCurrentXmlContext(), (XmlUsage)this.getXmlUsage());
    }

    public Controller getController() {
        return this.getXmlController();
    }

    public void setContext(Context ideContext) {
        this.getLogger().log(Level.FINER, "Set IDE context on editor: {0}", this);
        JDevXmlContext oldXmlContext = this.getCurrentXmlContext();
        JDevXmlContext newXmlContext = JDevXmlContext.getXmlContext(ideContext);
        if (oldXmlContext != newXmlContext) {
            this.handleXmlContextChange(oldXmlContext, newXmlContext);
        }
        this._xmlContext = newXmlContext;
        super.setContext(ideContext);
    }

    public void open() {
        this.getLogger().log(Level.FINER, "Editor opened: {0}", this);
    }

    public void close() {
        Context ideContext;
        super.close();
        this.getLogger().log(Level.FINER, "Editor closed: {0}", this);
        JDevXmlContext context = this.getCurrentXmlContext();
        if (context != null) {
            XmlGui currentGui = GuiXmlContextUtils.getGui((GuiXmlContext)context, (XmlUsage)this.getXmlUsage(), (boolean)false);
            this.handleXmlContextChange(context, null);
            if (currentGui != null) {
                currentGui.dispose();
            }
        }
        if ((ideContext = this.getContext()) != null) {
            ideContext.setSelection(null);
        }
        this._xmlContext = null;
    }

    public void activate() {
        super.activate();
        this.getLogger().log(Level.FINER, "Editor activated: {0}", this);
        JDevXmlContext context = this.getCurrentXmlContext();
        if (context != null) {
            context.acquireActiveGui(this.getCurrentXmlGui());
        }
    }

    public void editorHidden() {
        JDevStatusBarGui statusGui;
        super.editorHidden();
        this.getLogger().log(Level.FINER, "Editor hidden: {0}", this);
        XmlGui gui = GuiXmlContextUtils.getGui((GuiXmlContext)this.getCurrentXmlContext(), (XmlUsage)this.getXmlUsage(), (boolean)false);
        if (gui != null) {
            gui.hidden();
        }
        if ((statusGui = JDevUtils.getStatusGui(this._xmlContext, false)) != null) {
            statusGui.hidden();
        }
        boolean enabled = ToolTipManager.sharedInstance().isEnabled();
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(enabled);
    }

    public void editorShown() {
        JDevStatusBarGui statusGui;
        super.editorShown();
        this.getLogger().log(Level.FINER, "Editor shown: {0}", this);
        XmlGui gui = this.getCurrentXmlGui();
        if (gui != null) {
            gui.shown();
        }
        if ((statusGui = JDevUtils.getStatusGui(this._xmlContext)) != null) {
            statusGui.shown();
        }
    }

    public void update(Object observed, UpdateMessage message) {
    }

    protected Element[] getSelectionFromUI() {
        JDevXmlContext xmlContext = this.getCurrentXmlContext();
        if (xmlContext != null) {
            return new Element[]{xmlContext.createSelectionProxyElement()};
        }
        return null;
    }

    public JComponent[] getCustomCells() {
        JDevStatusBarGui gui = JDevUtils.getStatusGui(this._xmlContext);
        if (gui != null) {
            return gui.getCustomCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent component) {
        JDevStatusBarGui gui = JDevUtils.getStatusGui(this._xmlContext);
        if (gui != null) {
            return gui.isExpandable(component);
        }
        return false;
    }

    public Object getEditorAttribute(String attribute) {
        String val;
        if ("menu_id".equals(attribute) && (val = this.getDynamicMenuName()) != null) {
            return val;
        }
        return super.getEditorAttribute(attribute);
    }

    protected final Logger getLogger() {
        return _LOGGER;
    }

    protected final XmlController getXmlController() {
        return this._controller;
    }

    public void prepareForSaving(boolean isClosing) {
        Component comp;
        super.prepareForSaving(isClosing);
        if (isClosing && (comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && this._isParentOf(this.getGUI(), comp)) {
            FocusEvent event = new FocusEvent(comp, 1005, false);
            for (FocusListener listener : comp.getFocusListeners()) {
                listener.focusLost(event);
            }
        }
    }

    private boolean _isParentOf(Component gui, Component comp) {
        while (comp != null && comp != gui) {
            comp = comp.getParent();
        }
        return comp == gui;
    }

    private class Listener
    extends XmlModelAdapter {
        private Listener() {
        }

        public void modelChanged(XmlModelEvent event) {
            if (event.isSelectionChanged() && JDevInspectableViewTracker.INSTANCE.getLastViewSupportingInspection((View)AbstractXmlVisualEditor.this) == AbstractXmlVisualEditor.this) {
                AbstractXmlVisualEditor.this.updateSelectionImpl(true);
            }
        }
    }
}

