/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin;

import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.undo.TransactionMediator;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.share.TransactionToken;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.jdeveloper.controller.NodeActionDelegate;
import org.w3c.dom.Document;

public class XMLSourceNodeReformatActionDelegate
extends NodeActionDelegate {
    private TransactionToken _transactionToken;
    private UndoableEdit _postReformatActionUndoableEdit;
    private static final String KEY_PRETTY_PRINT_UNDO = "XMLADDIN.PRETTY_PRINT_UNDO";

    public boolean isEnabled(IdeAction action, Context context, Element[] elements, int[] text) {
        int cmdId = action.getCommandId();
        if (cmdId == Ide.findOrCreateCmdID((String)"CodeEditor.Format")) {
            return this._isPrettyPrintEnabled(action, context, elements, text);
        }
        return super.isEnabled(action, context, elements, text);
    }

    public int[] doAction(Context context, Element[] elements, int[] text, IdeAction action) throws Exception {
        int cmdId = action.getCommandId();
        if (cmdId == Ide.findOrCreateCmdID((String)"CodeEditor.Format")) {
            return this._doPrettyPrintAction(context, elements, text, action);
        }
        return null;
    }

    private boolean _isPrettyPrintEnabled(IdeAction action, Context context, Element[] elements, int[] text) {
        boolean[] status;
        boolean prettyPrintEnabled = false;
        Node node = context.getNode();
        if (node != null && node instanceof XMLSourceNode && (status = this._checkStatus(context))[0] && status[1]) {
            prettyPrintEnabled = true;
        }
        return prettyPrintEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] _doPrettyPrintAction(Context context, Element[] elements, int[] text, IdeAction action) throws Exception {
        Project project = context.getProject();
        Node node = context.getNode();
        if (node != null && node instanceof XMLSourceNode) {
            JDevXmlContext xmlContext = ((XMLSourceNode)node).getXmlContext(project);
            XmlModel model = xmlContext.getModel();
            DomModel domModel = model.getDomModel();
            org.w3c.dom.Node reformatRoot = null;
            int selStart = -1;
            int selEnd = -1;
            if (text != null) {
                selStart = text[0];
                selEnd = text[1];
            }
            org.w3c.dom.Node cursorNode = null;
            int cursorDelta = 0;
            model.acquireReadLock();
            try {
                cursorNode = domModel.getNodeAtOffset(selStart);
                if (cursorNode != null) {
                    org.w3c.dom.Node endNode;
                    cursorDelta = selStart - domModel.getTextOffset(DomPositionFactory.before((org.w3c.dom.Node)cursorNode));
                    if (selStart != selEnd && (endNode = domModel.getNodeAtOffset(selEnd)) != null) {
                        reformatRoot = DomUtils.lowestCommonAncestor((org.w3c.dom.Node)cursorNode, (org.w3c.dom.Node)endNode);
                    }
                }
                if (reformatRoot == null) {
                    reformatRoot = domModel.getDocument();
                }
            }
            finally {
                model.releaseReadLock();
            }
            this._transactionToken = TransactionMediator.getInstance().createToken();
            this._transactionToken.setOwnerIfUnset((Object)this);
            if (reformatRoot == null) {
                return null;
            }
            Document formatRoot = reformatRoot;
            model.startTransaction("Reformat");
            try {
                xmlContext.setTransactionToken(this._transactionToken);
                domModel.reformatSubtree(KEY_PRETTY_PRINT_UNDO, (org.w3c.dom.Node)formatRoot);
                model.commitTransaction(false);
            }
            catch (XmlCommitException xce) {
                model.rollbackTransaction();
                throw xce;
            }
            catch (Error error) {
                model.rollbackTransaction();
                throw error;
            }
            catch (RuntimeException re) {
                model.rollbackTransaction();
                throw re;
            }
            this._postReformatActionUndoableEdit = xmlContext.getIdeDocument().postReformatHook(xmlContext, text);
            return this._updateCodeEditorSelection(text, model, cursorNode, cursorDelta, reformatRoot);
        }
        return null;
    }

    public void undoAction(Context context, Element[] elements, int[] text, IdeAction action) {
        if (this._postReformatActionUndoableEdit != null) {
            this._postReformatActionUndoableEdit.undo();
            this._postReformatActionUndoableEdit = null;
        }
        if (this._transactionToken != null) {
            this._transactionToken.dispatch((Object)this, false);
            this._transactionToken = null;
        }
    }

    private boolean[] _checkStatus(Context context) {
        boolean shown = false;
        boolean enabled = false;
        Node node = context.getNode();
        if (node != null) {
            shown = this._supportedDocument(node);
            enabled = !node.isReadOnly();
        }
        return new boolean[]{shown, enabled};
    }

    private boolean _supportedDocument(Node node) {
        return node instanceof XMLSourceNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] _updateCodeEditorSelection(int[] text, XmlModel model, org.w3c.dom.Node cursorNode, int cursorDelta, org.w3c.dom.Node reformatRoot) {
        int[] newSel = null;
        if (text != null) {
            model.acquireReadLock();
            try {
                if (reformatRoot != null && !DomUtils.isDocument((org.w3c.dom.Node)reformatRoot)) {
                    if (model.isInModelDocumentHierarchy(reformatRoot)) {
                        newSel = new int[]{model.getTextOffset(DomPositionFactory.before((org.w3c.dom.Node)reformatRoot)), model.getTextOffset(DomPositionFactory.after((org.w3c.dom.Node)reformatRoot))};
                    }
                } else if (model.isInModelDocumentHierarchy(cursorNode)) {
                    newSel = new int[]{model.getTextOffset(DomPositionFactory.before((org.w3c.dom.Node)cursorNode)), model.getTextOffset(DomPositionFactory.before((org.w3c.dom.Node)cursorNode)) + cursorDelta};
                }
            }
            finally {
                model.releaseReadLock();
            }
        }
        return newSel;
    }
}

