/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.addin.JDevXmlContextFactory;
import oracle.bali.xml.addin.SchemaRegistryAddin;
import oracle.bali.xml.addin.XMLEditorAddin;
import oracle.bali.xml.addin.XMLSourceNodeHook;
import oracle.bali.xml.beanmodel.BeanBaseRegistry;
import oracle.bali.xml.dom.buffer.BufferDomModelPluginFactory;
import oracle.bali.xml.dom.buffer.DefaultDocumentScannerFactory;
import oracle.bali.xml.dom.buffer.DefaultParserConfiguration;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.ParserConfigurationDecorator;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptions;
import oracle.bali.xml.dom.buffer.util.ByteOrderMarkSkippingReader;
import oracle.bali.xml.dom.buffer.util.EncodingUtils;
import oracle.bali.xml.dom.impl.DomModelPluginFactory;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.instance.XmlInstanceGrammarProvider;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.gui.XmlGuiFactory;
import oracle.bali.xml.gui.jdev.JDevTextBufferSource;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.JDevXmlGuiFactory;
import oracle.bali.xml.gui.jdev.shaping.XmlShapingHook;
import oracle.bali.xml.indexing.IndexingMetadataMapper;
import oracle.bali.xml.indexing.IndexingProvider;
import oracle.bali.xml.indexing.IndexingStandaloneMetadataProvider;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataSchemaRegistry;
import oracle.bali.xml.metadata.NullMetadataProvider;
import oracle.bali.xml.metadata.grammar.GrammarMetadataProvider;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileRegistry;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlPersistentModelListener;
import oracle.bali.xml.model.annotation.AnnotationGrammar;
import oracle.bali.xml.model.annotation.AnnotationMetadataResolver;
import oracle.bali.xml.model.annotation.AnnotationModel;
import oracle.bali.xml.model.annotation.impl.NullAnnotationGrammar;
import oracle.bali.xml.model.annotation.impl.NullAnnotationModel;
import oracle.bali.xml.model.grammar.GrammarLoadingPolicyFactory;
import oracle.bali.xml.model.listenerImpl.IllegalListenerStateException;
import oracle.bali.xml.model.misc.XmlModelBasedTextSyncOptions;
import oracle.bali.xml.share.TextBufferSource;
import oracle.bali.xml.util.RegistryBasedDtdCreator;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.cmd.buffer.EditProcessor;
import oracle.ide.file.ContentSetKey;
import oracle.ide.file.ContentSetScope;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileChangeListener;
import oracle.ide.file.FileChanges;
import oracle.ide.file.FileScope;
import oracle.ide.model.DeployableTextNode;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.SingletonProvider;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.util.Encodings;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;
import oracle.javatools.util.NamedTimer;
import oracle.xml.parser.v2.XMLDOMImplementation;
import org.w3c.dom.DOMImplementation;

public class XMLSourceNode
extends DeployableTextNode {
    public static final int XML_CONTEXT_CREATED = UpdateMessage.newMessageID((String)"XMLSourceNode.XML_CONTEXT_CREATED");
    private static Log LOG = new Log("xmladapter");
    private static final SortedSet<XMLSourceNodeHook> _sourceNodeHooks = new TreeSet<XMLSourceNodeHook>(new Comparator<XMLSourceNodeHook>(){

        @Override
        public int compare(XMLSourceNodeHook o1, XMLSourceNodeHook o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            int diff = o1.getWeight() - o2.getWeight();
            if (diff == 0) {
                diff = 1;
            }
            return diff;
        }
    });
    private static final String KEY_CHANGE_ENCODING = "XMLADDIN.CHANGE_ENCODING";
    private static final Logger _LOGGER = Logger.getLogger(XMLSourceNode.class.getName());
    private static final String _DOM_IMPL_SYSTEM_PROPERTY = "oracle.bali.xml.DOMImplementation";
    private static final String _XDK_DOM_IMPLKEY = "xdk";
    private static final String _XERCES_DOM_IMPLKEY = "xerces";
    private static final String _XERCES_DOM_IMPLEMENTATION_CLASS_NAME = "org.apache.xerces.dom.DOMImplementationImpl";
    private static final String _ENCODING_ERROR = "Unexpected exception encountered while determining file encoding";
    private static final String _COMBINED_INPUT_STREAM_ERROR = "Unexpected exception encountered while combining input stream";
    private static JDevXmlContextFactory _sContextFactory = null;
    private static final Map<String, SoftReference<StandaloneMetadataFile>> _metadataFileMap = new HashMap<String, SoftReference<StandaloneMetadataFile>>();
    private Reference<JDevXmlContext> _contextRef = null;
    private String _loadEncoding = "UTF-8";
    private boolean _byteOrderMarkDetected = false;
    private transient DOMImplementation _domImplemenation;
    private volatile boolean _fileChanged;
    private static Object _fileChangeListenerLock = new Object();
    private static ConcurrentMap<ContentSetKey, FileChangeListener> _fileChangeListeners = new ConcurrentHashMap<ContentSetKey, FileChangeListener>(5);
    private Set<XmlPersistentModelListener> _persistentListeners = new CopyOnWriteArraySet<XmlPersistentModelListener>();
    private Set<DelegatingXmlModelListener> _delegatingListeners = new CopyOnWriteArraySet<DelegatingXmlModelListener>();
    private static ConcurrentHashMap<String, Integer> _sLongLabelToCreationCount = new ConcurrentHashMap();
    private static boolean _sVerboseLoggingEnabled = false;
    private static final Map<URLFileSystemHelper, Boolean> _urlFileSystemHelperReflectionCache = Collections.synchronizedMap(new WeakHashMap());
    private static final ThreadLocal<CreateReaderContext> _createReaderContextThreadLocal = new ThreadLocal();

    public XMLSourceNode() {
        this(null);
    }

    public XMLSourceNode(URL url) {
        super(url);
        this.getAttributes().set(ElementAttributes.BUILDABLE);
    }

    static boolean isXmlSourceNodeSubclass(Class xmlSourceNodeSubclass) {
        return XMLSourceNode.class.isAssignableFrom(xmlSourceNodeSubclass);
    }

    public static JDevXmlContext getXmlContext(Context ideContext) {
        Node ideNode;
        if (ideContext != null && (ideNode = ideContext.getNode()) instanceof XMLSourceNode) {
            try {
                return ((XMLSourceNode)ideNode)._getXmlContext(ideContext);
            }
            catch (Exception e) {
                _LOGGER.log(Level.SEVERE, "Error creating XmlContext for " + ideContext, e);
                return null;
            }
        }
        return null;
    }

    public static JDevXmlContext getXmlContextOrThrow(Context ideContext) throws Exception {
        if (ideContext == null) {
            throw new IllegalArgumentException("Context cannot be null!");
        }
        Node ideNode = ideContext.getNode();
        if (ideNode instanceof XMLSourceNode) {
            return ((XMLSourceNode)ideNode)._getXmlContext(ideContext);
        }
        throw new IllegalArgumentException("Node is not a XMLSourceNode!");
    }

    public synchronized JDevXmlContextFactory getJDevXmlContextFactory() {
        if (_sContextFactory == null) {
            JDevXmlContextFactory factoryFromTriggerHook = (JDevXmlContextFactory)SingletonProvider.find(JDevXmlContextFactory.class);
            _sContextFactory = factoryFromTriggerHook != null ? factoryFromTriggerHook : new JDevXmlContextFactory();
        }
        return _sContextFactory;
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"xmlfile.png");
    }

    public final XmlModel getModel() {
        return this.getXmlContext().getModel();
    }

    public final XmlModel getModel(Project project) {
        JDevXmlContext context = this.getXmlContext(project);
        if (context != null) {
            return context.getModel();
        }
        return null;
    }

    public final boolean hasXmlContextBeenCreated() {
        boolean hasXmlContextBeenCreated = false;
        this.readLock();
        try {
            hasXmlContextBeenCreated = this._getXmlContextDirectly() != null;
        }
        finally {
            this.readUnlock();
        }
        return hasXmlContextBeenCreated;
    }

    public final JDevXmlContext getXmlContext() {
        _LOGGER.log(Level.WARNING, "Call to getXmlContext without a project! This should be changed to pass the project.", new RuntimeException("stack trace"));
        return this.getXmlContext(null);
    }

    public final JDevXmlContext getXmlContext(Project project) {
        Context ideContext = new Context(null, null, project, (Node)this);
        try {
            return this._getXmlContext(ideContext);
        }
        catch (Exception e) {
            _LOGGER.log(Level.SEVERE, "Error creating XmlContext for " + (Object)((Object)this), e);
            return null;
        }
    }

    public final DOMImplementation getDOMImplementation() {
        if (this._domImplemenation == null) {
            this._domImplemenation = this.createDOMImplementation();
        }
        return this._domImplemenation;
    }

    public DocumentScannerFactory getDocumentScannerFactory(Context context, JDevXmlContext xmlContext) {
        return new DefaultDocumentScannerFactory();
    }

    public ParserConfiguration getParserConfiguration(final JDevXmlContext xmlContext) {
        return new ParserConfigurationDecorator((ParserConfiguration)new DefaultParserConfiguration()){
            private TextSyncOptions _tso;
            {
                super(x0);
                this._tso = null;
            }

            public TextSyncOptions getTextSyncOptions() {
                if (this._tso == null) {
                    this._tso = new XmlModelBasedTextSyncOptions((XmlContext)xmlContext, super.getTextSyncOptions());
                }
                return this._tso;
            }
        };
    }

    public DomModelPluginFactory createDomModelPluginFactory(JDevXmlContext xmlContext, XmlModel xmlModel) {
        DomModelPluginFactory current = this.createDomModelPluginFactoryImpl(xmlContext, xmlModel);
        for (XMLSourceNodeHook hook : _sourceNodeHooks) {
            try {
                current = hook.replaceDomModelPluginFactory(this, xmlContext, xmlModel, current);
            }
            catch (Throwable t) {
                if (_LOGGER.isLoggable(Level.WARNING)) {
                    LogRecord lr = new LogRecord(Level.WARNING, "Exception in XMLSourceNodeHook.replaceDomModelPluginFactory; hook={0} xmlContext={1}");
                    lr.setParameters(new Object[]{hook, xmlContext});
                    lr.setThrown(t);
                    _LOGGER.log(lr);
                }
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        return current;
    }

    public XMLCompletionInsightProvider createInsightProvider(JDevXmlContext xmlContext) {
        DocumentScannerFactory factory = this.getDocumentScannerFactory(xmlContext.createContext(), xmlContext);
        return new XMLCompletionInsightProvider((XmlContext)xmlContext, factory);
    }

    public GrammarProvider createGrammarProvider(JDevXmlContext context) {
        String extension = this.getExtension();
        if (extension == null || extension.length() == 0) {
            extension = "xml";
        }
        GrammarProvider base = SchemaRegistryAddin.getGrammarProvider(extension);
        XmlInstanceGrammarProvider provider = new XmlInstanceGrammarProvider(base);
        provider.setGrammarLoadingPolicy(GrammarLoadingPolicyFactory.getGrammarLoadingPolicy((XmlContext)context));
        provider.setDtdCreator(RegistryBasedDtdCreator.getInstance());
        return provider;
    }

    public final GrammarResolver createGrammarResolver(JDevXmlContext context, GrammarProvider provider) {
        GrammarResolver resolver = new GrammarResolver(provider);
        this.createGrammarResolverExtensions(context, resolver);
        return resolver;
    }

    public List<BeanBaseRegistry> createBeanRegistries(JDevXmlContext context) {
        return Collections.emptyList();
    }

    public AnnotationModel createAnnotationModel(JDevXmlContext context) {
        AnnotationModel current = this.createAnnotationModelImpl(context);
        for (XMLSourceNodeHook hook : _sourceNodeHooks) {
            try {
                current = hook.replaceAnnotationModel(this, context, current);
            }
            catch (Throwable t) {
                if (_LOGGER.isLoggable(Level.WARNING)) {
                    LogRecord lr = new LogRecord(Level.WARNING, "Exception in XMLSourceNodeHook.replaceAnnotationModel; hook={0} xmlContext={1}");
                    lr.setParameters(new Object[]{hook, context});
                    lr.setThrown(t);
                    _LOGGER.log(lr);
                }
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        return current;
    }

    public AnnotationGrammar createAnnotationGrammar(JDevXmlContext context) {
        AnnotationGrammar current = this.createAnnotationGrammarImpl(context);
        for (XMLSourceNodeHook hook : _sourceNodeHooks) {
            try {
                current = hook.replaceAnnotationGrammar(this, context, current);
            }
            catch (Throwable t) {
                if (!_LOGGER.isLoggable(Level.WARNING)) continue;
                LogRecord lr = new LogRecord(Level.WARNING, "Exception in XMLSourceNodeHook.replaceAnnotationGrammar; hook={0} xmlContext={1}");
                lr.setParameters(new Object[]{hook, context});
                lr.setThrown(t);
                _LOGGER.log(lr);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        return current;
    }

    public final AnnotationMetadataResolver createAnnotationMetadataResolver(JDevXmlContext context, MetadataProvider annotationMetadataProvider) {
        AnnotationMetadataResolver current = this.createAnnotationMetadataResolverImpl(context, annotationMetadataProvider);
        for (XMLSourceNodeHook hook : _sourceNodeHooks) {
            try {
                current = hook.replaceAnnotationMetadataResolver(this, context, current, annotationMetadataProvider);
            }
            catch (Throwable t) {
                if (_LOGGER.isLoggable(Level.WARNING)) {
                    LogRecord lr = new LogRecord(Level.WARNING, "Exception in XMLSourceNodeHook.replaceAnnotationMetadataProvider; hook={0} xmlContext={1}");
                    lr.setParameters(new Object[]{hook, context});
                    lr.setThrown(t);
                    _LOGGER.log(lr);
                }
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        return current;
    }

    public MetadataProvider createAnnotationMetadataProvider(JDevXmlContext context) {
        MetadataProvider current = this.createAnnotationMetadataProviderImpl(context);
        for (XMLSourceNodeHook hook : _sourceNodeHooks) {
            try {
                current = hook.replaceAnnotationMetadataProvider(this, context, current);
            }
            catch (Throwable t) {
                if (_LOGGER.isLoggable(Level.WARNING)) {
                    LogRecord lr = new LogRecord(Level.WARNING, "Exception in XMLSourceNodeHook.replaceAnnotationMetadataProvider; hook={0} xmlContext={1}");
                    lr.setParameters(new Object[]{hook, context});
                    lr.setThrown(t);
                    _LOGGER.log(lr);
                }
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        return current;
    }

    public final IndexingProvider createIndexingProvider() {
        return this.createIndexingProviderImpl();
    }

    public boolean isXmlSyntax(Project project) {
        return true;
    }

    public void reformatForLineBasedDiff(Project project, String undoLabel) {
        this.getXmlContext(project).getSourceModel().getDomModel().reformatSubtree(undoLabel, null, (Object)"rule5");
    }

    public boolean supportsXmlContextAction(Action a) {
        return true;
    }

    public boolean showAllValidComponentsPalettePage() {
        return false;
    }

    public String getBundleId() {
        String bundleId = URLFileSystem.getFileName((URL)this.getURL());
        int i = bundleId.indexOf(46);
        if (i != -1) {
            bundleId = bundleId.substring(0, i);
        }
        return bundleId + "Bundle";
    }

    public void addPersistentXmlModelListener(Workspace workspace, Project project, XmlPersistentModelListener listener, boolean requireSynchronousHelloEvent) {
        if (!this._persistentListeners.contains(listener)) {
            JDevXmlContext context = null;
            DelegatingXmlModelListener wrapperListener = new DelegatingXmlModelListener(listener);
            this._delegatingListeners.add(wrapperListener);
            context = !requireSynchronousHelloEvent ? this._getXmlContextDirectly() : this._createContext(workspace, project);
            if (context != null) {
                try {
                    context.getModel().addModelListener((XmlModelListener)wrapperListener);
                }
                catch (IllegalListenerStateException illegalListenerStateException) {
                    // empty catch block
                }
            }
            this._setFileChangeListener(workspace, project);
            this._persistentListeners.add(listener);
        }
    }

    public void removePersistentXmlModelListener(Workspace workspace, Project project, XmlPersistentModelListener listener) {
        this._persistentListeners.remove(listener);
        DelegatingXmlModelListener wrapperListener = null;
        for (DelegatingXmlModelListener dxml : this._delegatingListeners) {
            if (dxml.getListener() != listener) continue;
            wrapperListener = dxml;
            break;
        }
        if (wrapperListener != null) {
            XmlModel model;
            this._delegatingListeners.remove(wrapperListener);
            JDevXmlContext context = this._getXmlContextDirectly();
            XmlModel xmlModel = model = context != null ? context.getModel() : null;
            if (model != null) {
                try {
                    model.removeModelListener((XmlModelListener)wrapperListener);
                }
                catch (IllegalListenerStateException illegalListenerStateException) {
                    // empty catch block
                }
            }
        }
        this._removeFileChangeListener(workspace, project);
    }

    public static final void registerXmlSourceNodeHook(XMLSourceNodeHook hook) {
        if (hook != null) {
            _sourceNodeHooks.add(hook);
        }
    }

    public UndoableEdit postReformatHook(JDevXmlContext xmlContext, int[] text) {
        return null;
    }

    protected AnnotationModel createAnnotationModelImpl(JDevXmlContext context) {
        return NullAnnotationModel.getInstance((XmlContext)context);
    }

    protected AnnotationGrammar createAnnotationGrammarImpl(JDevXmlContext context) {
        return NullAnnotationGrammar.getInstance();
    }

    protected AnnotationMetadataResolver createAnnotationMetadataResolverImpl(JDevXmlContext context, MetadataProvider annotationMetadataProvider) {
        return new AnnotationMetadataResolver(annotationMetadataProvider);
    }

    protected IndexingProvider createIndexingProviderImpl() {
        HashSet<StandaloneMetadataFile> files = new HashSet<StandaloneMetadataFile>();
        List<URL> urls = this.getIndexingMetadataURLS();
        for (URL url : urls) {
            files.add(this._getStandaloneMetadataFile(url));
        }
        return new IndexingProvider(this.getIndexingMetadataMapper(), files, this._createXmlIndexingMetadataProvider(null));
    }

    protected MetadataProvider createAnnotationMetadataProviderImpl(JDevXmlContext context) {
        return NullMetadataProvider.getInstance();
    }

    protected DomModelPluginFactory createDomModelPluginFactoryImpl(JDevXmlContext xmlContext, XmlModel xmlModel) {
        JDevTextBufferSource textBufferSource = new JDevTextBufferSource((TextNode)this, this.nodeLock());
        return new BufferDomModelPluginFactory((TextBufferSource)textBufferSource, this.getDOMImplementation(), this.getParserConfiguration(xmlContext), this.getDocumentScannerFactory(xmlContext.createContext(), xmlContext));
    }

    protected void revertImpl() throws IOException {
        for (XMLSourceNodeHook hook : _sourceNodeHooks) {
            boolean handled;
            block5: {
                handled = false;
                try {
                    handled = hook.handleRevertAction(this, this._getXmlContextDirectly());
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Throwable t) {
                    if (_LOGGER.isLoggable(Level.WARNING)) {
                        LogRecord lr = new LogRecord(Level.WARNING, "Exception in XMLSourceNodeHook.handleRevertAction; hook={0} node={1}");
                        lr.setParameters(new Object[]{hook, this});
                        lr.setThrown(t);
                        _LOGGER.log(lr);
                    }
                    if (!(t instanceof ThreadDeath)) break block5;
                    throw (ThreadDeath)t;
                }
            }
            if (!handled) continue;
            return;
        }
        super.revertImpl();
    }

    protected void saveImpl() throws IOException {
        for (XMLSourceNodeHook hook : _sourceNodeHooks) {
            boolean handled;
            block5: {
                handled = false;
                try {
                    handled = hook.handleSaveAction(this, this._getXmlContextDirectly());
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Throwable t) {
                    if (_LOGGER.isLoggable(Level.WARNING)) {
                        LogRecord lr = new LogRecord(Level.WARNING, "Exception in XMLSourceNodeHook.handleSaveAction; hook={0} node={1}");
                        lr.setParameters(new Object[]{hook, this});
                        lr.setThrown(t);
                        _LOGGER.log(lr);
                    }
                    if (!(t instanceof ThreadDeath)) break block5;
                    throw (ThreadDeath)t;
                }
            }
            if (!handled) continue;
            return;
        }
        super.saveImpl();
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        assert (this.isWriteLocked());
        this._setXmlContextDirectly(null);
    }

    protected JDevXmlContext createContext(Context ideContext) {
        JDevXmlContext context = this.getJDevXmlContextFactory().createJDevXmlContext(ideContext);
        context.finishInitialization();
        return context;
    }

    protected void createGrammarResolverExtensions(JDevXmlContext context, GrammarResolver resolver) {
    }

    protected DOMImplementation createDOMImplementation() {
        String domImplKey = System.getProperty(_DOM_IMPL_SYSTEM_PROPERTY, _XDK_DOM_IMPLKEY).toLowerCase();
        return new XMLDOMImplementation();
    }

    protected XmlModel createXmlModel(JDevXmlContext context, MetadataProvider provider) {
        return new XmlModel(provider);
    }

    protected MetadataProvider createMetadataProvider(JDevXmlContext context, boolean isSourceModel) {
        return new GrammarMetadataProvider(context.getGrammarResolver());
    }

    protected void registerViewFactories(JDevXmlContext context) {
    }

    protected void registerGuiFactories(JDevXmlContext context) {
        context.registerGuiFactory((XmlGuiFactory)JDevXmlGuiFactory.getJDevGuiFactory());
    }

    protected void registerServiceProviders(JDevXmlContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Reader createReader(URL url) throws IOException {
        Reader reader = null;
        if (XMLSourceNode._canUseInputStreamReader(url)) {
            CreateReaderContext createReaderContext = new CreateReaderContext();
            _createReaderContextThreadLocal.set(createReaderContext);
            String encoding = this.getLoadEncoding();
            _createReaderContextThreadLocal.set(null);
            InputStream inStream = createReaderContext.getInputStream();
            if (inStream != null) {
                try {
                    reader = new InputStreamReader(inStream, encoding);
                }
                finally {
                    if (reader == null && inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            reader = URLFileSystem.createReader((URL)url, (String)encoding);
        } else {
            reader = URLFileSystem.createReader((URL)url, (String)this.getLoadEncoding());
        }
        if (this._byteOrderMarkDetected && !"UTF-16".equals(this._loadEncoding)) {
            reader = ByteOrderMarkSkippingReader.createByteOrderMarkSkippingReader((Reader)reader);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLoadEncoding() {
        String encodingClass = "UTF-8";
        boolean byteOrderMarkDetected = false;
        String encodingInFile = null;
        int encodingScanSize = 512;
        URL url = this.getURL();
        if (url != null) {
            InputStream inputStream = null;
            boolean reusingStream = false;
            try {
                CreateReaderContext context;
                inputStream = URLFileSystem.openInputStream((URL)url);
                byte[] scanArray = new byte[512];
                int length = EncodingUtils.fillEncodingScanArray((InputStream)inputStream, (byte[])scanArray, (int)512);
                EncodingUtils.EncodingClassDetails encodingClassDetails = EncodingUtils.getEncodingClassDetails((byte[])scanArray, (int)length);
                encodingClass = encodingClassDetails.getEncodingClass();
                byteOrderMarkDetected = encodingClassDetails.isByteOrderMarkDetected();
                ReadTextBuffer buffer = EncodingUtils.getTemporaryTextBuffer((byte[])scanArray, (int)length, (String)encodingClass);
                AttributeLocator encodingLocator = EncodingUtils.getEncodingAttributeLocator((ReadTextBuffer)buffer);
                if (encodingLocator != null) {
                    encodingInFile = EncodingUtils.getAttributeValue((ReadTextBuffer)buffer, (AttributeLocator)encodingLocator);
                }
                if ((context = _createReaderContextThreadLocal.get()) != null) {
                    SequenceInputStream combinedStream = null;
                    try {
                        ByteArrayInputStream byteStream = new ByteArrayInputStream(scanArray, 0, length);
                        combinedStream = new SequenceInputStream(byteStream, inputStream);
                        context.setInputStream(combinedStream);
                        reusingStream = true;
                    }
                    catch (Exception e) {
                        _LOGGER.log(Level.WARNING, _COMBINED_INPUT_STREAM_ERROR, e);
                        context.setInputStream(null);
                    }
                }
            }
            catch (IOException scanArray) {
            }
            catch (Exception e) {
                _LOGGER.log(Level.SEVERE, _ENCODING_ERROR, e);
            }
            finally {
                if (inputStream != null && !reusingStream) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        String encodingToUse = encodingClass;
        if (encodingInFile != null && encodingInFile.length() > 0 && Encodings.isSupported((String)encodingInFile)) {
            encodingToUse = encodingInFile;
        }
        this._loadEncoding = encodingToUse.intern();
        this._byteOrderMarkDetected = byteOrderMarkDetected;
        return encodingToUse;
    }

    public List<URL> getIndexingMetadataURLS() {
        ArrayList<URL> list = new ArrayList<URL>();
        Set urlSet = MetadataSchemaRegistry.getInstance().getIndexingFunctionMD();
        if (urlSet != null) {
            list.addAll(urlSet);
        }
        return list;
    }

    public IndexingMetadataMapper getIndexingMetadataMapper() {
        return null;
    }

    public String getSaveEncoding() {
        String encodingInFile;
        String encodingClass;
        String encodingToUse = encodingClass = this._loadEncoding;
        AttributeLocator encodingLocator = null;
        TextBuffer buffer = this.getTextBufferDirectly();
        if (buffer != null) {
            encodingLocator = EncodingUtils.getEncodingAttributeLocator((ReadTextBuffer)buffer);
        }
        if (encodingLocator != null && (encodingInFile = EncodingUtils.getAttributeValue((ReadTextBuffer)buffer, (AttributeLocator)encodingLocator)) != null && encodingInFile.length() > 0) {
            if (Encodings.isSupported((String)encodingInFile)) {
                encodingToUse = encodingInFile;
            } else {
                String newAttrValue = Encodings.convertJdk2IanaEncoding((String)encodingClass);
                if (newAttrValue == null) {
                    newAttrValue = encodingClass;
                }
                TextLocator valueLocator = encodingLocator.getValueLocator();
                int startOffset = valueLocator.getStartOffset();
                int endOffset = valueLocator.getEndOffset();
                int newLength = newAttrValue.length();
                char[] newEncoding = new char[newLength + 2];
                newEncoding[0] = 34;
                newAttrValue.getChars(0, newLength, newEncoding, 1);
                newEncoding[newEncoding.length - 1] = 34;
                MessageFormat undoNameFormatter = new MessageFormat(XMLEditorAddin.getTranslatedString(KEY_CHANGE_ENCODING));
                Object[] args = new Object[]{newAttrValue};
                EditProcessor.doReplace((char[])newEncoding, (int)startOffset, (int)endOffset, (Node)this, (boolean)true, (String)undoNameFormatter.format(args), (Object)((Object)this));
            }
        }
        return encodingToUse;
    }

    protected String getExtension() {
        String suffix = URLFileSystem.getSuffix((URL)this.getURL());
        int dotIndex = suffix.lastIndexOf(".");
        if (dotIndex != -1) {
            suffix = suffix.substring(dotIndex + 1);
        }
        return suffix;
    }

    protected List<String> getShapingIds() {
        ArrayList<String> shapingIdList = new ArrayList<String>();
        for (Class<?> currClass = ((Object)((Object)this)).getClass(); currClass != XMLSourceNode.class; currClass = currClass.getSuperclass()) {
            shapingIdList.add(currClass.getName());
        }
        return shapingIdList;
    }

    private MetadataProvider _createXmlIndexingMetadataProvider(MetadataProvider baseMetadataProvider) {
        MetadataProvider returnProvider = baseMetadataProvider;
        List<URL> urls = this.getIndexingMetadataURLS();
        for (URL url : urls) {
            try {
                StandaloneMetadataFile file = this._getStandaloneMetadataFile(url);
                if (file == null) continue;
                StandaloneMetadataFileRegistry registry = new StandaloneMetadataFileRegistry();
                registry.addStandaloneMetadataFile(file);
                returnProvider = new IndexingStandaloneMetadataProvider(returnProvider, registry, this.getIndexingMetadataMapper());
            }
            catch (StandaloneMetadataFileException smfe) {
                _LOGGER.log(Level.WARNING, "Exception processing standalone metadata file, " + url.toString(), smfe);
            }
        }
        return returnProvider;
    }

    private StandaloneMetadataFile _getStandaloneMetadataFile(URL url) {
        StandaloneMetadataFile file = null;
        if (_metadataFileMap.containsKey(url.toString())) {
            SoftReference<StandaloneMetadataFile> ref = _metadataFileMap.get(url.toString());
            file = ref.get();
        }
        if (file == null) {
            try {
                file = OracleStandaloneMetadataFactory.createStandaloneMetadataFile((URL)url);
                _metadataFileMap.put(url.toString(), new SoftReference<StandaloneMetadataFile>(file));
            }
            catch (StandaloneMetadataFileException smfe) {
                _LOGGER.log(Level.WARNING, "Exception processing standalone metadata file, " + url.toString(), smfe);
            }
        }
        return file;
    }

    private MetadataProvider _createXmlShapingMetadataProvider(MetadataProvider baseMetadataProvider) {
        XmlShapingHook xmlShapingHook = (XmlShapingHook)ExtensionRegistry.getExtensionRegistry().getHook(XmlShapingHook.NAME);
        if (xmlShapingHook != null) {
            return xmlShapingHook.createXmlShapingMetadataProvider(this.getShapingIds(), baseMetadataProvider);
        }
        return baseMetadataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JDevXmlContext _getXmlContext(Context ideContext) throws Exception {
        Node nodeFromContext = ideContext.getNode();
        if (nodeFromContext != this) {
            _LOGGER.log(Level.WARNING, "_getXmlContext(Context): Context had node {0} but this={1}! Using this instead.", new Object[]{nodeFromContext, this});
        }
        TextBuffer pinnedTextBuffer = null;
        try {
            pinnedTextBuffer = this.acquireTextBufferOrThrow();
            if (pinnedTextBuffer == null) {
                throw new IllegalStateException("XmlContext:  Error acquiring text buffer for file: " + this.getURL());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("XmlContext:  Error acquiring text buffer for file: " + this.getURL(), e);
        }
        JDevXmlContext context = null;
        this.readLock();
        try {
            context = this._getXmlContextDirectly();
            if (context != null) {
                context.reestablishContext(ideContext);
            }
        }
        finally {
            this.readUnlock();
        }
        if (context == null) {
            this.writeLock();
            try {
                context = this._getXmlContextDirectly();
                if (context == null) {
                    if (LOG.isEnabled() && Thread.currentThread().getName().startsWith("status-")) {
                        LOG.stack("XmlContext for {0} created on status thread", new Object[]{this});
                    }
                    context = this._createAndInitXmlContext(ideContext);
                    for (XmlModelListener xmlModelListener : this._delegatingListeners) {
                        context.getModel().addModelListener(xmlModelListener);
                    }
                }
            }
            finally {
                this.writeUnlock();
            }
        }
        return context;
    }

    private JDevXmlContext _createAndInitXmlContext(Context ideContext) throws Exception {
        long startTime = System.nanoTime();
        try {
            JDevXmlContext context = this.createContext(ideContext);
            this._setXmlContextDirectly(context);
            MetadataProvider xmlIndexingMetadataProvider = this._createXmlIndexingMetadataProvider(this.createMetadataProvider(context, true));
            MetadataProvider xmlShapingMetadataProvider = this._createXmlShapingMetadataProvider(xmlIndexingMetadataProvider);
            XmlModel sourceModel = this.createXmlModel(context, xmlShapingMetadataProvider);
            context.setModel(sourceModel);
            this.registerViewFactories(context);
            this.registerGuiFactories(context);
            this.registerServiceProviders(context);
            this._notifyObserversLater(new UpdateMessage(XML_CONTEXT_CREATED, (Object)this));
            JDevXmlContext jDevXmlContext = context;
            return jDevXmlContext;
        }
        catch (Throwable t) {
            this._setXmlContextDirectly(null);
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            throw new IllegalStateException("Error creating XmlContext for " + (Object)((Object)this), t);
        }
        finally {
            long endTime = System.nanoTime();
            long duration = (endTime - startTime) / 1000000L;
            String longLabel = this.getLongLabel();
            String message = "Timing:  [" + duration + "ms]  Create XmlContext for " + longLabel;
            if (_sVerboseLoggingEnabled) {
                Integer count = _sLongLabelToCreationCount.get(longLabel);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                _sLongLabelToCreationCount.put(longLabel, count);
                System.out.println(message + " Count: " + count);
            } else {
                _LOGGER.log(Level.FINE, message);
            }
        }
    }

    private JDevXmlContext _getXmlContextDirectly() {
        return this._contextRef == null ? null : this._contextRef.get();
    }

    private void _setXmlContextDirectly(JDevXmlContext context) {
        this._contextRef = context == null ? null : new WeakReference<JDevXmlContext>(context);
    }

    private void _notifyObserversLater(final UpdateMessage updateMessage) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XMLSourceNode.this.notifyObservers((Object)XMLSourceNode.this, updateMessage);
            }
        });
    }

    private JDevXmlContext _createContext(Workspace ws, Project p) {
        Context c = new Context(ws, p);
        c.setNode((Node)this);
        return XMLSourceNode.getXmlContext(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setFileChangeListener(Workspace ws, Project p) {
        ContentSetKey key = ContentSetKey.getInstance((Workspace)ws, (Project)p);
        Object object = _fileChangeListenerLock;
        synchronized (object) {
            FileChangeListener listener = (FileChangeListener)_fileChangeListeners.get(key);
            if (listener == null) {
                listener = new XmlFileChangeListener();
                ContentSetScope fs = null;
                fs = p == null ? ContentSetScope.getInstance((Workspace)ws) : ContentSetScope.getInstance((Workspace)ws, (Project)p);
                fs.addFileChangeListener(listener);
                _fileChangeListeners.put(key, listener);
            }
            ((XmlFileChangeListener)listener).addURL(this.getURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeFileChangeListener(Workspace ws, Project p) {
        ContentSetKey key = ContentSetKey.getInstance((Workspace)ws, (Project)p);
        Object object = _fileChangeListenerLock;
        synchronized (object) {
            FileChangeListener listener = (FileChangeListener)_fileChangeListeners.get(key);
            if (listener != null) {
                XmlFileChangeListener xmlListener = (XmlFileChangeListener)listener;
                xmlListener.removeURL(this.getURL());
                if (xmlListener.isEmpty()) {
                    ContentSetScope fs = null;
                    fs = p == null ? ContentSetScope.getInstance((Workspace)ws) : ContentSetScope.getInstance((Workspace)ws, (Project)p);
                    fs.removeFileChangeListener(listener);
                    _fileChangeListeners.remove(listener);
                }
            }
        }
    }

    private static boolean _canUseInputStreamReader(URL url) {
        URLFileSystemHelper topLevelHelper = URLFileSystem.findHelper((URL)url);
        Boolean canUseInputStreamReader = _urlFileSystemHelperReflectionCache.get(topLevelHelper);
        if (canUseInputStreamReader == null) {
            try {
                URLFileSystemHelper currentHelper = topLevelHelper;
                Method createReaderMethod = null;
                boolean foundMethodWithImpl = false;
                while (!foundMethodWithImpl) {
                    createReaderMethod = currentHelper.getClass().getMethod("createReader", URL.class, String.class);
                    if (createReaderMethod.getDeclaringClass() == URLFileSystemHelperDecorator.class) {
                        currentHelper = ((URLFileSystemHelperDecorator)currentHelper).getHelper();
                        continue;
                    }
                    foundMethodWithImpl = true;
                }
                canUseInputStreamReader = createReaderMethod.getDeclaringClass() == URLFileSystemHelper.class;
            }
            catch (Exception e) {
                canUseInputStreamReader = false;
            }
            _urlFileSystemHelperReflectionCache.put(topLevelHelper, canUseInputStreamReader);
        }
        return canUseInputStreamReader;
    }

    static {
        try {
            Boolean sysProp = Boolean.getBoolean("oracle.bali.xml.addin.XMLSourceNode.verboseLogging");
            _sVerboseLoggingEnabled = sysProp;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class XmlFileChangeListener
    implements FileChangeListener {
        private JDevXmlContext _pinnedContext;
        private ConcurrentMap<String, URL> _map = new ConcurrentHashMap<String, URL>();

        private XmlFileChangeListener() {
        }

        public void filesChanged(FileScope fs, FileChanges changes) {
            for (FileChange fc : changes) {
                XMLSourceNode node;
                URL url = fc.getURL();
                if (!this._isRelevantURL(url) || (node = this._getNode(url)) == null) continue;
                JDevXmlContext context = node._getXmlContextDirectly();
                if (context != null) {
                    this._pinnedContext = context;
                    NamedTimer t = new NamedTimer(this.getClass().getName());
                    t.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            _pinnedContext = null;
                        }
                    }, 2000L);
                    continue;
                }
                if (fc.getChangeType().equals((Object)FileChange.Type.REMOVED)) continue;
                node._fileChanged = true;
                if (!(fs instanceof ContentSetScope)) continue;
                ContentSetScope css = (ContentSetScope)fs;
                Workspace ws = css.getWorkspace();
                Project p = css.getProject();
                Context c = new Context(ws, p);
                c.setNode((Node)node);
                XMLSourceNode.getXmlContext(c);
            }
        }

        public void addURL(URL url) {
            this._map.put(url.toExternalForm(), url);
        }

        public void removeURL(URL url) {
            this._map.remove(url.toExternalForm());
        }

        public boolean isEmpty() {
            return this._map.isEmpty();
        }

        private boolean _isRelevantURL(URL url) {
            return this._map.get(url.toExternalForm()) != null;
        }

        private XMLSourceNode _getNode(URL url) {
            if (url == null) {
                return null;
            }
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                if (node instanceof XMLSourceNode) {
                    return (XMLSourceNode)node;
                }
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "Exception finding or creating XmlSourceNode" + this, e);
            }
            return null;
        }
    }

    private class DelegatingXmlModelListener
    implements XmlModelListener {
        private final XmlPersistentModelListener _listener;

        public DelegatingXmlModelListener(XmlPersistentModelListener listener) {
            this._listener = listener;
        }

        public void listenerAttached(XmlModelEvent event) {
            this._listener.xmlContextCreated(event, XMLSourceNode.this._fileChanged);
            XMLSourceNode.this._fileChanged = false;
        }

        public void invalidate(XmlModelEvent event) {
            this._listener.invalidate(event);
        }

        public void modelChanged(XmlModelEvent event) {
            this._listener.modelChanged(event);
        }

        public void noChange(XmlModelEvent event) {
        }

        public void listenerDetached(XmlModelEvent event) {
        }

        public XmlPersistentModelListener getListener() {
            return this._listener;
        }
    }

    private class CreateReaderContext {
        private InputStream _inStream = null;

        public InputStream getInputStream() {
            return this._inStream;
        }

        public void setInputStream(InputStream inStream) {
            this._inStream = inStream;
        }
    }
}

