/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.FontMetrics;
import java.text.BreakIterator;
import java.util.Locale;
import oracle.bali.ewt.olaf2.WrapInfo;

class WordWrapper {
    private static WordWrapper _sWordWrapper;

    public static WordWrapper getTextWrapper() {
        if (_sWordWrapper == null) {
            _sWordWrapper = new WordWrapper();
        }
        return _sWordWrapper;
    }

    public void wrapParagraph(WrapInfo wrapInfo, String text) {
        char[] textChars = text.toCharArray();
        int numChars = textChars.length;
        int currIndex = 0;
        int arrayOffset = 0;
        int wrapWidth = wrapInfo.getWrapWidth();
        FontMetrics metrics = wrapInfo.getFontMetrics();
        Locale locale = wrapInfo.getLocale();
        BreakIterator wordWrapper = BreakIterator.getLineInstance(locale);
        boolean isPreferred = wrapInfo.isCalculatingPreferred();
        wordWrapper.setText(text);
        while (currIndex < numChars) {
            int currLineWidth = 0;
            int oldLineWidth = 0;
            int lastIndex = currIndex;
            int nextIndex = currIndex;
            int wordCount = 0;
            do {
                String displayString;
                ++wordCount;
                nextIndex = wordWrapper.next();
                if (nextIndex == -1) {
                    nextIndex = numChars;
                }
                if (nextIndex > 0) {
                    char thisChar = textChars[arrayOffset + nextIndex - 1];
                    while (thisChar == ':' || thisChar == '.' || thisChar == '-') {
                        nextIndex = wordWrapper.next();
                        if (nextIndex == -1) {
                            nextIndex = numChars;
                            break;
                        }
                        thisChar = textChars[arrayOffset + nextIndex - 1];
                    }
                }
                boolean tabInWord = false;
                for (int i = lastIndex; i < nextIndex; ++i) {
                    if (textChars[i + arrayOffset] != '\t') continue;
                    tabInWord = true;
                    break;
                }
                if (tabInWord) {
                    displayString = new String(textChars, currIndex + arrayOffset, nextIndex - currIndex);
                    currLineWidth = metrics.stringWidth(displayString);
                } else {
                    displayString = new String(textChars, lastIndex + arrayOffset, nextIndex - lastIndex);
                    currLineWidth += metrics.stringWidth(displayString);
                }
                if (currLineWidth > wrapWidth && oldLineWidth != 0) {
                    wordWrapper.previous();
                    break;
                }
                lastIndex = nextIndex;
                oldLineWidth = currLineWidth;
            } while (lastIndex < numChars && currLineWidth <= wrapWidth);
            if (wordCount == 1 && currLineWidth > wrapWidth && wrapWidth > 0 && !isPreferred) {
                lastIndex = WordWrapper.__getNextIndex(textChars, metrics, wrapWidth, currIndex + arrayOffset, wrapWidth / metrics.charWidth('e')) - arrayOffset;
                if (!wrapInfo.addLine(text, currIndex, lastIndex)) {
                    return;
                }
                text = text.substring(lastIndex);
                currIndex = 0;
                numChars = text.length();
                wordWrapper.setText(text);
                arrayOffset += lastIndex;
                continue;
            }
            if (!wrapInfo.addLine(text, currIndex, lastIndex)) {
                return;
            }
            currIndex = lastIndex;
        }
    }

    static int __getNextIndex(char[] textChars, FontMetrics metrics, int wrapWidth, int currIndex, int guessChars) {
        int wrapIndex;
        block5: {
            int guessWidth;
            block7: {
                block6: {
                    wrapIndex = currIndex + guessChars;
                    int numChars = textChars.length;
                    if (wrapIndex > numChars) {
                        wrapIndex = numChars;
                        guessChars = wrapIndex - currIndex;
                    }
                    if ((guessWidth = metrics.charsWidth(textChars, currIndex, guessChars)) >= wrapWidth) break block6;
                    while (wrapIndex < numChars) {
                        int charWidth;
                        char ch = textChars[wrapIndex];
                        if ((guessWidth += (charWidth = ch == '\t' ? metrics.charsWidth(textChars, 0, wrapIndex + 1) - guessWidth : metrics.charWidth(ch))) > wrapWidth && wrapIndex > currIndex) {
                            guessWidth -= charWidth;
                            break block5;
                        }
                        ++wrapIndex;
                    }
                    break block5;
                }
                if (guessWidth != wrapWidth) break block7;
                if (wrapIndex != currIndex) break block5;
                wrapWidth = metrics.charWidth(textChars[wrapIndex]);
                ++wrapIndex;
                break block5;
            }
            while (guessWidth > wrapWidth && wrapIndex > currIndex + 1) {
                char ch;
                if ((ch = textChars[--wrapIndex]) == '\t') {
                    guessWidth = metrics.charsWidth(textChars, 0, wrapIndex + 1);
                    continue;
                }
                guessWidth -= metrics.charWidth(textChars[wrapIndex]);
            }
        }
        return wrapIndex;
    }

    private WordWrapper() {
    }
}

