/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.util.EventObject;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.LinkItem;

public class LinkToolEvent
extends EventObject {
    public static final int LINK_CREATING = 1;
    public static final int LINK_CREATED = 2;
    public static final int LINK_POSITIONING = 3;
    private LinkItem _link;
    private LayoutItem _source;
    private LayoutItem _dest;
    private Point2D _sourcePt;
    private Point2D _destPt;
    private int _id;

    public LinkToolEvent(Object source, int id, LinkItem link, LayoutItem sourceItem, Point2D sourcePt, LayoutItem destItem, Point2D destPt) {
        super(source);
        this._id = id;
        this._link = link;
        this._source = sourceItem;
        this._dest = destItem;
        this._sourcePt = sourcePt;
        this._destPt = destPt;
    }

    public int getId() {
        return this._id;
    }

    public LinkItem getLinkItem() {
        return this._link;
    }

    public LayoutItem getSourceItem() {
        return this._source;
    }

    public LayoutItem getDestinationItem() {
        return this._dest;
    }

    public Point2D getSourcePoint() {
        return this._sourcePt;
    }

    public Point2D getDestinationPoint() {
        return this._destPt;
    }

    @Override
    public String toString() {
        String type = null;
        switch (this._id) {
            case 1: {
                type = "LINK_CREATING";
                break;
            }
            case 2: {
                type = "LINK_CREATED";
                break;
            }
            case 3: {
                type = "LINK_POSITIONING";
            }
        }
        return this.getClass().getName() + ": " + type + ", link=" + this._link + ", source=" + this._source + ", dest=" + this._dest + ", srcPt=" + this._sourcePt + ", destPt=" + this._destPt;
    }
}

