/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.LayoutItemTransfer;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.Cancelable;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.tool.ClipboardToolEvent;
import oracle.bali.jle.tool.ClipboardToolListener;
import oracle.bali.jle.tool.ClipboardToolValidateEvent;
import oracle.bali.jle.tool.SelectedItemProvider;
import oracle.bali.jle.tool.undo.ClipboardUndo;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.bali.share.event.ListenerManager;

public class ClipboardTool
extends BaseTool
implements ClipboardOwner {
    private static final Object _CUT_PARENT_KEY = new StringKey("_CUT_PARENT_KEY");
    private static final Object _CUT_INDEX_KEY = new StringKey("_CUT_INDEX_KEY");
    private static final Object _CUT_KEY = new StringKey("_CUT_KEY");
    private static final KeyStroke _sDefaultCopyStroke = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static final KeyStroke _sDefaultCutStroke = KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static final KeyStroke _sDefaultPasteStroke = KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static final Clipboard _sJLEClipboard = new Clipboard("JLEClipboard");
    private static final DataFlavor _sMultiFlavor = LayoutItemTransfer.MULTI_LAYOUT_ITEM_FLAVOR;
    private static final DataFlavor _sFlavor = LayoutItemTransfer.LAYOUT_ITEM_FLAVOR;
    private SelectedItemProvider _selector;
    private KeyStroke _copyStroke = _sDefaultCopyStroke;
    private KeyStroke _cutStroke = _sDefaultCutStroke;
    private KeyStroke _pasteStroke = _sDefaultPasteStroke;
    private boolean _postUndo = false;
    private ListenerManager _listeners;
    private double _pasteOffset = 0.0;

    public ClipboardTool(SelectedItemProvider selector) {
        if (selector == null) {
            throw new IllegalArgumentException("selection provider cannot be null");
        }
        this._selector = selector;
    }

    @Override
    public void pickup(JLECanvas canvas, JLEEventSource eventSource) {
        super.pickup(canvas, eventSource);
        this._postUndo = canvas.hasUndoableEditListeners();
    }

    @Override
    public void drop() {
        super.drop();
        this._postUndo = false;
    }

    protected boolean fireClipboardToolEvent(int id, LayoutItem[] items) {
        Enumeration listeners;
        ClipboardToolEvent event;
        boolean cancelable = false;
        if (id == 1 || id == 3 || id == 5) {
            event = new ClipboardToolValidateEvent(this, id, items);
            cancelable = true;
        } else {
            event = new ClipboardToolEvent(this, id, items);
        }
        Enumeration enumeration = listeners = this._listeners == null ? null : this._listeners.getListeners();
        if (listeners == null) {
            return true;
        }
        while (listeners.hasMoreElements()) {
            ClipboardToolListener listener = (ClipboardToolListener)listeners.nextElement();
            if (id == 1) {
                listener.itemsCopying(event);
                continue;
            }
            if (id == 2) {
                listener.itemsCopied(event);
                continue;
            }
            if (id == 3) {
                listener.itemsCutting(event);
                continue;
            }
            if (id == 4) {
                listener.itemsCut(event);
                continue;
            }
            if (id == 5) {
                listener.itemsPasting(event);
                continue;
            }
            if (id != 6) continue;
            listener.itemsPasted(event);
        }
        return cancelable ? !((Cancelable)((Object)event)).isCancelled() : true;
    }

    @Override
    protected void processKeyPressed(JLEEvent e) {
        if (e.isConsumed()) {
            return;
        }
        LayoutItem[] items = null;
        boolean isCut = false;
        if (e.equals(this._copyStroke)) {
            this.processCopy();
        } else if (e.equals(this._cutStroke)) {
            items = this.processCut();
            isCut = true;
        } else if (e.equals(this._pasteStroke)) {
            items = this.processPaste();
        } else {
            return;
        }
        if (items != null && this._postUndo) {
            ClipboardUndo edit = new ClipboardUndo(items, isCut, this);
            this.getCanvas().processUndoableEditEvent(new UndoableEditEvent(this, edit));
        }
        e.consume();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public LayoutItem[] processCopy() {
        LayoutItem[] items = this._selector.getSelectedItems();
        return this.processCopy(items, true);
    }

    public LayoutItem[] processCut(LayoutItem[] items) {
        if (items == null || !this.isOKToCut()) {
            return null;
        }
        JLECanvas canvas = this.getCanvas() != null ? this.getCanvas() : items[0].getCanvas();
        LayoutItem[] cutting = ItemUtils.removeChildren(canvas, items);
        if (!this.fireClipboardToolEvent(3, cutting)) {
            return null;
        }
        if ((cutting = this.processCopy(cutting, false)) == null) {
            return null;
        }
        for (int i = 0; i < cutting.length; ++i) {
            LayoutItem curr = cutting[i];
            LayoutItem parent = curr.getItemParent();
            int index = ItemUtils.getItemIndex(curr, parent);
            curr.putProperty(_CUT_PARENT_KEY, parent);
            curr.putProperty(_CUT_INDEX_KEY, new Integer(index));
            curr.putProperty(_CUT_KEY, null);
            curr.getItemParent().removeItem(cutting[i]);
        }
        this.fireClipboardToolEvent(4, cutting);
        canvas.repaintInterior();
        return cutting;
    }

    public final LayoutItem[] processCut() {
        LayoutItem[] items = this._selector.getSelectedItems();
        return this.processCut(items);
    }

    public LayoutItem[] processPaste() {
        Clipboard systemClipboard = ClipboardTool.getClipboard();
        Transferable paste = systemClipboard.getContents(this);
        LayoutItem[] items = null;
        double offset = 0.0;
        double offsetX = 0.0;
        double offsetY = 0.0;
        int insertIndex = -1;
        LayoutItem parent = null;
        Point2D leftLoc = null;
        if (paste != null && this.isOKToPaste(paste)) {
            LayoutItem[] oldSelect = this._selector.getSelectedItems();
            if (oldSelect.length > 0 && this._pasteOffset != 0.0) {
                LayoutItem upperLeft = this._findUpperLeft(oldSelect);
                offset = this._pasteOffset;
                leftLoc = upperLeft.getItemLocation();
                parent = upperLeft.getItemParent();
                insertIndex = ItemUtils.getItemIndex(upperLeft, parent);
            }
            for (int i = 0; i < oldSelect.length; ++i) {
                this._selector.processDeselect(oldSelect[i]);
            }
            try {
                if (paste.isDataFlavorSupported(_sMultiFlavor)) {
                    items = (LayoutItem[])paste.getTransferData(_sMultiFlavor);
                    if (!this.fireClipboardToolEvent(5, items)) {
                        return null;
                    }
                    if (items.length > 0 && offset > 0.0) {
                        LayoutItem oldUpperLeft = this._findUpperLeft(items);
                        Point2D oldLeftLoc = oldUpperLeft.getItemLocation();
                        offsetX -= oldLeftLoc.getX();
                        offsetY -= oldLeftLoc.getY();
                        offsetX += offset;
                        offsetY += offset;
                    }
                    for (int i = 0; i < items.length; ++i) {
                        items[i] = this._pasteItem(items[i], parent, leftLoc, offsetX, offsetY, insertIndex);
                    }
                } else if (paste.isDataFlavorSupported(_sFlavor)) {
                    LayoutItem item = (LayoutItem)paste.getTransferData(_sFlavor);
                    items = new LayoutItem[]{item};
                    if (!this.fireClipboardToolEvent(5, items)) {
                        return null;
                    }
                    if (offset > 0.0) {
                        Point2D oldLoc = item.getItemLocation();
                        offsetX -= oldLoc.getX();
                        offsetY -= oldLoc.getY();
                        offsetX += offset;
                        offsetY += offset;
                    }
                    items[0] = this._pasteItem(item, parent, leftLoc, offsetX, offsetY, insertIndex);
                }
                if (items != null) {
                    this.fireClipboardToolEvent(6, items);
                }
            }
            catch (UnsupportedFlavorException noFlavor) {
                return null;
            }
            catch (IOException noData) {
                return null;
            }
        }
        return items;
    }

    public boolean isOKToPaste(Transferable pasteCandidate) {
        return pasteCandidate != null && (pasteCandidate.isDataFlavorSupported(LayoutItemTransfer.MULTI_LAYOUT_ITEM_FLAVOR) || pasteCandidate.isDataFlavorSupported(LayoutItemTransfer.LAYOUT_ITEM_FLAVOR));
    }

    public final boolean isOKToPaste() {
        if (!this.isActive()) {
            return false;
        }
        return this.isOKToPaste(ClipboardTool.getClipboard().getContents(this));
    }

    public boolean isOKToCopy() {
        return this._selector.getSelectedItemCount() > 0;
    }

    public boolean isOKToCut() {
        return this._selector.getSelectedItemCount() > 0;
    }

    public KeyStroke getCopyKeyStroke() {
        return this._copyStroke;
    }

    public void setCopyKeyStroke(KeyStroke stroke) {
        this._copyStroke = stroke;
    }

    public KeyStroke getCutKeyStroke() {
        return this._cutStroke;
    }

    public void setCutKeyStroke(KeyStroke stroke) {
        this._cutStroke = stroke;
    }

    public KeyStroke getPasteKeyStroke() {
        return this._pasteStroke;
    }

    public void setPasteKeyStroke(KeyStroke stroke) {
        this._copyStroke = stroke;
    }

    @Override
    public long getDefaultEnabledEvents() {
        return 8L;
    }

    public SelectedItemProvider getSelectedItemProvider() {
        return this._selector;
    }

    public void addClipboardToolListener(ClipboardToolListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeClipboardToolListener(ClipboardToolListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    protected LayoutItem[] processCopy(LayoutItem[] items, boolean postEvent) {
        if (items == null || !this.isOKToCopy()) {
            return null;
        }
        if (postEvent && !this.fireClipboardToolEvent(1, items)) {
            return null;
        }
        LayoutItemTransfer selection = new LayoutItemTransfer(items);
        Clipboard systemClipboard = ClipboardTool.getClipboard();
        systemClipboard.setContents(selection, this);
        if (postEvent) {
            this.fireClipboardToolEvent(2, items);
        }
        return items;
    }

    public static Clipboard getClipboard() {
        return _sJLEClipboard;
    }

    public double getPasteOffset() {
        return this._pasteOffset;
    }

    public void setPasteOffset(double offset) {
        this._pasteOffset = offset;
    }

    private LayoutItem _pasteItem(LayoutItem item, LayoutItem newParent, Point2D parentLoc, double offsetX, double offsetY, int insertIndex) {
        int index;
        LayoutItem insert = item;
        boolean cloned = false;
        if (item.removeProperty(_CUT_KEY) == PropertyManager.NOT_FOUND_OBJECT) {
            cloned = true;
            try {
                insert = (LayoutItem)insert.clone();
            }
            catch (CloneNotSupportedException e) {
                insert = null;
                return null;
            }
        }
        if (insert == null) {
            return null;
        }
        LayoutItem parent = newParent != null ? newParent : null;
        int n = index = newParent != null ? insertIndex : -1;
        if (parent == null) {
            if (cloned) {
                parent = item.getItemParent();
                index = ItemUtils.getItemIndex(item, parent);
            } else {
                Object found = insert.removeProperty(_CUT_PARENT_KEY);
                if (found != PropertyManager.NOT_FOUND_OBJECT) {
                    parent = (LayoutItem)found;
                }
                if ((found = insert.removeProperty(_CUT_INDEX_KEY)) != PropertyManager.NOT_FOUND_OBJECT) {
                    index = (Integer)found;
                }
            }
        }
        if (parent == null || this.getCanvas() != parent.getCanvas()) {
            parent = this.getCanvas().getContentItem();
        } else if (index >= 0 && index > parent.getItemCount()) {
            index = -1;
        }
        if (parentLoc != null) {
            Point2D oldLoc = insert.getItemLocation();
            double newX = oldLoc.getX() + offsetX + parentLoc.getX();
            double newY = oldLoc.getY() + offsetY + parentLoc.getY();
            insert.setItemLocation(newX, newY);
        }
        parent.addItem(insert, index);
        this._selector.processSelect(insert);
        return insert;
    }

    private LayoutItem _findUpperLeft(LayoutItem[] items) {
        double total = Double.MAX_VALUE;
        LayoutItem found = items[0];
        for (int i = 0; i < items.length; ++i) {
            Point2D location = items[i].getItemLocation();
            double currTotal = location.getX() + location.getY();
            if (!(currTotal < total)) continue;
            found = items[i];
            total = currTotal;
        }
        return found;
    }
}

