/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.item.DefaultLinkPainter;
import oracle.bali.jle.item.GridSnap;
import oracle.bali.jle.item.LinkPainter;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.item.LinkPortEvent;
import oracle.bali.jle.item.LinkPortListener;
import oracle.bali.jle.tool.BoundsTool;
import oracle.bali.jle.tool.LinkTool;
import oracle.bali.jle.util.ItemUtils;

public abstract class LinkItem
extends BaseItem
implements LinkPortListener {
    private LinkPort[] _ports;
    private String _label;
    private Vector _lockedPorts;
    private LinkPainter _painter;
    private static Vector _sLinkCollector;

    public LinkItem() {
        BoundsTool.setMovable(this, false);
        BoundsTool.setResizable(this, false);
        GridSnap.setGridSnapOverride(this, true);
    }

    public static Point getPortInDevice(LinkPort port) {
        LayoutItem parent = port.getItem();
        return ItemUtils.itemToDevice(parent, port.getLocation());
    }

    public static Point2D getPortInDeviceDouble(LinkPort port) {
        LayoutItem parent = port.getItem();
        return ItemUtils.itemToDevice(parent, port.getX(), port.getY());
    }

    public static LayoutItem[] getAttachedItems(LayoutItem item) {
        LinkPort[] ports = LinkTool.getLinkPorts(item);
        if (ports.length < 1) {
            return new LayoutItem[0];
        }
        if (_sLinkCollector == null) {
            _sLinkCollector = new Vector();
        }
        for (int i = 0; i < ports.length; ++i) {
            LinkPortListener[] listeners = ports[i].getLinkPortListeners();
            for (int j = 0; j < listeners.length; ++j) {
                LinkPortListener curr = listeners[j];
                if (!(curr instanceof LayoutItem) || _sLinkCollector.contains(curr)) continue;
                _sLinkCollector.addElement(curr);
            }
        }
        Object[] result = new LayoutItem[_sLinkCollector.size()];
        _sLinkCollector.copyInto(result);
        _sLinkCollector.removeAllElements();
        return result;
    }

    public abstract void setPorts(LinkPort[] var1);

    public abstract LinkPort[] getPorts();

    public abstract int getPortCount();

    public void setLinkPainter(LinkPainter painter) {
        if (painter != null && painter != this._painter) {
            this._painter = painter;
            this.updateBounds();
            this.repaintItem();
        }
    }

    public LinkPainter getLinkPainter() {
        if (this._painter == null) {
            this._painter = DefaultLinkPainter.getLinkPainter();
        }
        return this._painter;
    }

    @Override
    public void portMoved(LinkPortEvent e) {
        this.updatePorts(e.getLinkPort());
    }

    @Override
    public void portDead(LinkPortEvent e) {
        LinkPort dead = e.getLinkPort();
        dead.removeLinkPortListener(this);
        this.updatePorts(dead);
    }

    @Override
    public void paintItemImpl(Graphics g, AffineTransform trans) {
        this.getLinkPainter().paintLink(this, g, trans);
    }

    @Override
    public void paintItemZoomed(Graphics g, AffineTransform trans, double zoomX, double zoomY) {
        this.getLinkPainter().paintLink(this, g, trans);
    }

    @Override
    public boolean hitTest(double x, double y) {
        return this.getLinkPainter().hitTest(this, x, y);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void setItemParent(LayoutItem parent) {
        super.setItemParent(parent);
        if (this.getItemParent() == null) {
            LinkPort[] ports = this.getPorts();
            for (int i = 0; i < ports.length; ++i) {
                ports[i].removeLinkPortListener(this);
            }
        } else {
            this.updateBounds();
        }
    }

    protected abstract LinkPort[] updatePorts(LinkPort var1);

    protected void updateBounds() {
        Rectangle2D parentBounds = this.getLinkPainter().getLinkBounds(this);
        if (parentBounds == null) {
            return;
        }
        this.setItemBounds(parentBounds.getX(), parentBounds.getY(), parentBounds.getWidth(), parentBounds.getHeight());
    }
}

