/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.FSType;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.XQException;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.OXQuerySequence;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;

public class Variable
extends Expr {
    QName qname;
    int valueIndex = -1;
    int refCount = 0;
    OXMLSequenceType userSpecifiedType;

    @Override
    public XMLNode toXML() {
        return this.DefinitionToXML();
    }

    public XMLNode DefinitionToXML() {
        XMLElement xMLElement = (XMLElement)Variable.getDoc().createElement("Variable");
        xMLElement.setAttribute("name", XQueryUtils.getQNameString(this.qname));
        return xMLElement;
    }

    @Override
    public ConvertXML fromXML(XMLElement xMLElement) {
        String string = xMLElement.getAttribute("name");
        Variable variable = (Variable)Variable.getSymbolTable().get(string);
        return variable;
    }

    @Override
    public ConvertXML DefinitionFromXML(XMLElement xMLElement) {
        String string = xMLElement.getAttribute("name");
        this.qname = XQueryUtils.createQNameFromString(null, string);
        Variable.getSymbolTable().put(string, this);
        return this;
    }

    public final String getCanonicalName() {
        return XQueryUtils.getQNameString(this.qname);
    }

    public void toSqlDefn(XQXGen xQXGen) {
        this.toSql(xQXGen);
    }

    @Override
    public void toSql(XQXGen xQXGen) {
        xQXGen.startElement("variable");
        xQXGen.startElement("simpleIdentifier");
        xQXGen.characters(this.qname.toString());
        xQXGen.endElement("simpleIdentifier");
        xQXGen.endElement("variable");
    }

    public final void toSqlAlias(XQXGen xQXGen) {
        xQXGen.startElement("alias");
        xQXGen.characters(this.qname.toString());
        xQXGen.endElement("alias");
    }

    public Variable(QName qName) {
        this.qname = qName;
        this.staticType = OXMLSequenceType.ITEM_ZERO_OR_MORE;
    }

    public Variable(QName qName, OXMLSequenceType oXMLSequenceType) {
        this.qname = qName;
        this.userSpecifiedType = oXMLSequenceType;
        this.staticType = oXMLSequenceType == null ? OXMLSequenceType.ITEM_ZERO_OR_MORE : oXMLSequenceType;
    }

    public OXMLSequenceType getDefinedType() {
        return this.userSpecifiedType;
    }

    @Override
    protected void setStaticType(FSType fSType) {
        this.staticType = fSType;
    }

    @Override
    public void getStrRep(StringBuffer stringBuffer) {
        stringBuffer.append(XQueryUtils.getQNameString(this.qname));
    }

    public final String getName() {
        return XQueryUtils.getQNameString(this.qname);
    }

    int getValueIndex() {
        return this.valueIndex;
    }

    void resetValueIndex() {
        this.valueIndex = -1;
    }

    void setValueIndex(int n) {
        this.valueIndex = n;
    }

    public void setValue(boolean bl, OXMLSequence oXMLSequence, QueryState queryState) {
        OXMLSequence oXMLSequence2 = ((OXQuerySequence)oXMLSequence).materializeIt();
        if (bl && this.userSpecifiedType != null) {
            if (!oXMLSequence2.isOfType(this.userSpecifiedType)) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
            oXMLSequence2.setKnownType(this.userSpecifiedType);
        }
        queryState.setRuntimeValue(this, oXMLSequence2);
    }

    public void copyValue(boolean bl, Variable variable, QueryState queryState) {
        this.setValue(bl, queryState.getRuntimeValue(variable), queryState);
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        OXMLSequence oXMLSequence = queryState.getRuntimeValue(this);
        ((OXQuerySequence)oXMLSequence).restart();
        if (this.refCount > 1) {
            oXMLSequence = (OXMLSequence)oXMLSequence.clone();
        }
        if (this.userSpecifiedType != null) {
            oXMLSequence.setKnownType(this.userSpecifiedType);
        }
        return oXMLSequence;
    }

    public QName getVariableQName() {
        return this.qname;
    }

    public void incrementRefCount() {
        ++this.refCount;
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
        visitor.visitVariable(this);
    }
}

