/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Stack;
import java.util.Vector;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.FSType;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLCollator;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.XQException;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.ConvertXMLUtils;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.NodeSource;
import oracle.xquery.exec.NodeSourceIterator;
import oracle.xquery.exec.NodeSourceVisitor;
import oracle.xquery.exec.OXQueryItem;
import oracle.xquery.exec.OXQuerySequence;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.StaticTypingVisitor;
import oracle.xquery.exec.Trace;
import oracle.xquery.exec.VarExpr;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SortNS
extends NodeSource {
    private int nKeys;
    private int nNonKeys;
    Expr[] keys;
    Expr[] nonKeys;
    private BitSet collationSequence;
    private BitSet emptyGreatestSequence;
    private String[] collations;
    private boolean aggregation;
    private ArrayList sortArea;
    private Stack freeList;
    private int fetchIndex;

    private SortRec getSortRec(QueryState queryState) {
        SortRec sortRec = this.freeList.empty() ? new SortRec(this.nKeys, this.nNonKeys) : (SortRec)this.freeList.pop();
        return sortRec;
    }

    private void freeSortRec(SortRec sortRec, QueryState queryState) {
        this.freeList.push(sortRec);
    }

    private boolean isNaN(OXMLItem oXMLItem) {
        boolean bl = false;
        int n = oXMLItem.getPrimitiveType();
        if ((n == 4 || n == 3) && Double.isNaN(oXMLItem.getDouble())) {
            bl = true;
        }
        return bl;
    }

    private void Cleanup(QueryState queryState) {
        for (int i = 0; i < this.sortArea.size(); ++i) {
            this.freeSortRec((SortRec)this.sortArea.get(i), queryState);
        }
        this.sortArea.clear();
    }

    @Override
    public ConvertXML fromXML(XMLElement xMLElement) {
        int n;
        super.fromXML(xMLElement);
        String string = xMLElement.getAttribute("aggregate");
        if (string != null && string.equals("true")) {
            this.aggregation = true;
        }
        NodeList nodeList = xMLElement.getElementsByTagName("KEY");
        NodeList nodeList2 = xMLElement.getElementsByTagName("NON_KEY");
        this.nKeys = nodeList == null ? 0 : nodeList.getLength();
        int n2 = this.nNonKeys = nodeList2 == null ? 0 : nodeList2.getLength();
        if (this.nKeys > 0) {
            this.keys = new Expr[this.nKeys];
            this.collationSequence = new BitSet(this.nKeys);
            for (n = 0; n < this.nKeys; ++n) {
                this.keys[n] = (Expr)ConvertXMLUtils.createFromXML((XMLElement)nodeList.item(n).getFirstChild(), false);
                if (!((XMLElement)nodeList.item(n)).getAttribute("order").equals("DESC")) continue;
                this.collationSequence.set(n);
            }
        }
        if (this.nNonKeys > 0) {
            this.nonKeys = new Expr[this.nNonKeys];
            for (n = 0; n < this.nNonKeys; ++n) {
                this.nonKeys[n] = (Expr)ConvertXMLUtils.createFromXML((XMLElement)nodeList2.item(n).getFirstChild(), false);
            }
        }
        return this;
    }

    @Override
    public XMLNode toXML() {
        int n;
        XMLElement xMLElement = (XMLElement)SortNS.getDoc().createElement("Sort");
        this.toXMLDefault(xMLElement);
        if (this.aggregation) {
            xMLElement.setAttribute("aggregate", "true");
        } else {
            xMLElement.setAttribute("aggregate", "false");
        }
        for (n = 0; n < this.nKeys; ++n) {
            XMLElement xMLElement2 = (XMLElement)ConvertXMLUtils.toXMLAndTag(SortNS.getDoc(), this.keys[n], "KEY");
            if (this.collationSequence.get(n)) {
                xMLElement2.setAttribute("order", "DESC");
            } else {
                xMLElement2.setAttribute("order", "ASC");
            }
            xMLElement.appendChild((Node)xMLElement2);
        }
        for (n = 0; n < this.nNonKeys; ++n) {
            XMLElement xMLElement3 = (XMLElement)ConvertXMLUtils.toXMLAndTag(SortNS.getDoc(), this.nonKeys[n], "NON_KEY");
            xMLElement.appendChild((Node)xMLElement3);
        }
        this.toXMLOutput(xMLElement);
        return xMLElement;
    }

    @Override
    public void toSql(XQXGen xQXGen) {
        if (this.aggregation) {
            xQXGen.startElement("simpleQuery");
            xQXGen.startElement("selectList", XQXGen.createAttrs("selectQuantifier", "distinct"));
            xQXGen.startElement("selectItem");
            this.keys[0].toSql(xQXGen);
            this.getOutVariable().var.toSqlAlias(xQXGen);
            xQXGen.endElement("selectItem");
            xQXGen.endElement("selectList");
            xQXGen.startElement("fromList");
            xQXGen.startElement("fromItem");
            xQXGen.startElement("fromSubquery");
            this.kids[0].toSql(xQXGen);
            xQXGen.endElement("fromSubquery");
            xQXGen.endElement("fromItem");
            xQXGen.endElement("fromList");
            this.toSqlFilter(xQXGen);
            xQXGen.endElement("simpleQuery");
        } else {
            xQXGen.startElement("query");
            xQXGen.startElement("simpleQuery");
            xQXGen.startElement("selectList");
            xQXGen.startElement("selectItem");
            this.nonKeys[0].toSql(xQXGen);
            this.getOutVariable().var.toSqlAlias(xQXGen);
            xQXGen.endElement("selectItem");
            xQXGen.endElement("selectList");
            xQXGen.startElement("fromList");
            xQXGen.startElement("fromItem");
            xQXGen.startElement("fromSubquery");
            this.kids[0].toSql(xQXGen);
            xQXGen.endElement("fromSubquery");
            xQXGen.endElement("fromItem");
            xQXGen.endElement("fromList");
            this.toSqlFilter(xQXGen);
            xQXGen.endElement("simpleQuery");
            xQXGen.startElement("orderByList");
            for (int i = 0; i < this.keys.length; ++i) {
                boolean bl = this.collationSequence.get(i);
                xQXGen.startElement("orderByItem", bl ? XQXGen.createAttrs("orderSpec", "descending") : null);
                this.keys[i].toSql(xQXGen);
                xQXGen.endElement("orderByItem");
            }
            xQXGen.endElement("orderByList");
            xQXGen.endElement("query");
        }
    }

    @Override
    public NodeSource normalize() {
        int n;
        for (n = 0; n < this.nKeys; ++n) {
            this.keys[n] = this.keys[n].normalize();
        }
        for (n = 0; n < this.nNonKeys; ++n) {
            this.nonKeys[n] = this.nonKeys[n].normalize();
        }
        return super.normalize();
    }

    @Override
    public NodeSource optimize(OptimizeContext optimizeContext) {
        int n;
        for (n = 0; n < this.nKeys; ++n) {
            this.keys[n] = this.keys[n].optimize(optimizeContext);
        }
        for (n = 0; n < this.nNonKeys; ++n) {
            this.nonKeys[n] = this.nonKeys[n].optimize(optimizeContext);
        }
        return super.optimize(optimizeContext);
    }

    private void init() {
        this.sortArea = new ArrayList();
        this.freeList = new Stack();
        this.fetchIndex = -1;
    }

    public SortNS() {
        this.init();
    }

    public SortNS(NodeSource nodeSource, Expr[] exprArray, Expr[] exprArray2, BitSet bitSet, BitSet bitSet2, String[] stringArray, boolean bl, VarExpr varExpr) {
        super(varExpr);
        if (nodeSource != null) {
            this.setChildNodeSrc(nodeSource);
        }
        this.keys = exprArray;
        this.nKeys = this.keys == null ? 0 : this.keys.length;
        this.nonKeys = exprArray2;
        this.nNonKeys = this.nonKeys == null ? 0 : this.nonKeys.length;
        this.collationSequence = bitSet;
        this.emptyGreatestSequence = bitSet2;
        this.collations = stringArray;
        if (this.collationSequence == null) {
            this.collationSequence = new BitSet(this.nKeys);
        }
        if (this.emptyGreatestSequence == null) {
            this.emptyGreatestSequence = new BitSet(this.nKeys);
        }
        this.aggregation = bl;
        this.init();
    }

    public void setNonKeys(Expr[] exprArray) {
        this.nonKeys = exprArray;
        this.nNonKeys = this.nonKeys == null ? 0 : this.nonKeys.length;
    }

    public void setChildNodeSrc(NodeSource nodeSource) {
        this.kids = new NodeSource[1];
        this.kids[0] = nodeSource;
        nodeSource.parent = this;
    }

    @Override
    public NodeSourceIterator getNSIterator(QueryState queryState) {
        return new SortNSIterator(this, queryState);
    }

    @Override
    FSType staticTypeChecking(StaticTypingVisitor staticTypingVisitor) {
        return staticTypingVisitor.visitSortNS(this);
    }

    @Override
    void acceptVisitor(NodeSourceVisitor nodeSourceVisitor) {
        nodeSourceVisitor.visitSortNS(this);
    }

    public static class SortNSIterator
    extends NodeSourceIterator {
        NodeSourceIterator childIter;
        Vector sortArea;
        int fetchIndex;
        SortRecComparator comparator;

        public SortNSIterator(NodeSource nodeSource, QueryState queryState) {
            super(nodeSource, queryState);
            this.childIter = nodeSource.kids[0].getNSIterator(queryState);
            this.sortArea = new Vector();
            this.fetchIndex = -1;
            SortNS sortNS = (SortNS)nodeSource;
            sortNS.getClass();
            this.comparator = sortNS.new SortRecComparator(queryState.getSortCollation(), queryState.getDBCharSet());
        }

        @Override
        public void Start() {
            int n = 0;
            SortNS sortNS = (SortNS)this.nodeSrc;
            this.Cleanup(this.qryState);
            Trace.trace(1, this, "entered Start");
            this.childIter.Start();
            while (this.childIter.Fetch()) {
                int n2;
                if (!sortNS.EvaluateFilter(this.qryState)) continue;
                Trace.trace(2, this, "new record from input");
                ++n;
                SortRec sortRec = sortNS.getSortRec(this.qryState);
                for (n2 = 0; n2 < sortNS.nKeys; ++n2) {
                    OXMLSequence oXMLSequence = sortNS.keys[n2].Evaluate(this.qryState);
                    boolean bl = sortNS.keys[n2].needAtomization();
                    if (bl) {
                        oXMLSequence = oXMLSequence.atomize();
                    }
                    if (oXMLSequence.next()) {
                        OXMLItem oXMLItem = oXMLSequence.getItem();
                        if (sortNS.keys[n2].needCast() && oXMLItem.matchesType(OXMLSequenceType.TUNTYPED)) {
                            oXMLItem = XQueryUtils.convert(oXMLItem, OXMLSequenceType.TSTRING, this.qryState);
                        }
                        ((SortRec)sortRec).keys[n2] = oXMLItem;
                        if (oXMLSequence.next()) {
                            throw new XQException(this.qryState.getMesg().getMessage1("XPTY0004", this.qryState.getMesg().getMessage0("XQE-0503")));
                        }
                        if (!bl) continue;
                        this.qryState.returnSequence(oXMLSequence);
                        continue;
                    }
                    ((SortRec)sortRec).keys[n2] = null;
                }
                for (n2 = 0; n2 < sortNS.nNonKeys; ++n2) {
                    ((SortRec)sortRec).nonKeys[n2] = sortNS.nonKeys[n2].Evaluate(this.qryState);
                    ((OXQuerySequence)sortRec.nonKeys[n2]).materializeMe();
                }
                this.sortArea.add(sortRec);
            }
            Collections.sort(this.sortArea, this.comparator);
            this.fetchIndex = 0;
            Trace.trace(2, this, "Leaving Start: Got " + n + " records");
        }

        @Override
        public boolean Started() {
            return this.fetchIndex >= 0;
        }

        @Override
        public void Close() {
            Trace.trace(1, this, "Entering Close");
            this.Cleanup(this.qryState);
            this.fetchIndex = -1;
            this.childIter.Close();
        }

        @Override
        public boolean Fetch() {
            SortNS sortNS = (SortNS)this.nodeSrc;
            if (!this.Eof()) {
                SortRec sortRec;
                SortRec sortRec2 = (SortRec)this.sortArea.get(this.fetchIndex);
                ++this.fetchIndex;
                if (!sortNS.aggregation) {
                    this.nodeSrc.getOutVariable().setValue(false, sortRec2.nonKeys[0], this.qryState);
                    Trace.trace(2, this, "Fetch: got a row");
                    return true;
                }
                while (!this.Eof() && this.comparator.compare(sortRec2, sortRec = (SortRec)this.sortArea.get(this.fetchIndex)) == 0) {
                    ++this.fetchIndex;
                }
                this.nodeSrc.getOutVariable().setValue(false, this.qryState.createSequence(sortRec2.keys[0]), this.qryState);
                Trace.trace(2, this, "Fetch: got a row");
                return true;
            }
            Trace.trace(2, this, "Fetch: end-of-fetch");
            return false;
        }

        private boolean Eof() {
            return this.fetchIndex >= this.sortArea.size() || this.fetchIndex < 0;
        }

        private void Cleanup(QueryState queryState) {
            for (int i = 0; i < this.sortArea.size(); ++i) {
                ((SortNS)this.nodeSrc).freeSortRec((SortRec)this.sortArea.get(i), queryState);
            }
            this.sortArea.clear();
        }
    }

    class SortRecComparator
    implements Comparator {
        private String defaultColla = null;
        private String dbCharSet = null;

        public SortRecComparator(String string, String string2) {
            this.defaultColla = string;
            this.dbCharSet = string2;
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            SortRec sortRec = (SortRec)object;
            SortRec sortRec2 = (SortRec)object2;
            for (int i = 0; i < sortRec.keys.length; ++i) {
                boolean bl = SortNS.this.emptyGreatestSequence.get(i);
                if (sortRec.keys[i] == null && sortRec2.keys[i] == null) {
                    n = 0;
                } else if (sortRec.keys[i] == null) {
                    n = bl ? 1 : -1;
                } else if (sortRec2.keys[i] == null) {
                    n = bl ? -1 : 1;
                } else {
                    String string = this.defaultColla;
                    if (SortNS.this.collations != null && !SortNS.this.collations[i].equals("null")) {
                        string = SortNS.this.collations[i];
                    }
                    OXMLCollator oXMLCollator = FNUtil.getCollator((String)string, (String)this.dbCharSet);
                    n = XQueryUtils.compareValue(sortRec.keys[i], sortRec2.keys[i], oXMLCollator);
                    if (n == -2) {
                        boolean bl2 = SortNS.this.isNaN(sortRec.keys[i]);
                        boolean bl3 = SortNS.this.isNaN(sortRec2.keys[i]);
                        if (bl2 && bl3) {
                            n = 0;
                        } else if (bl) {
                            n = bl2 && !bl3 ? 1 : -1;
                        } else {
                            int n2 = n = bl2 && !bl3 ? -1 : 1;
                        }
                    }
                }
                if (n == 0) continue;
                if (SortNS.this.collationSequence.get(i)) {
                    n = -1 * n;
                }
                return n;
            }
            return 0;
        }
    }

    private static class SortRec {
        private OXMLItem[] keys;
        private OXMLSequence[] nonKeys;

        SortRec(int n, int n2) {
            this.keys = new OXQueryItem[n];
            if (n2 > 0) {
                this.nonKeys = new OXQuerySequence[n2];
            }
        }
    }
}

