/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.TIMESTAMPTZ;
import oracle.xdb.XMLType;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.scalable.PageManager;
import oracle.xml.sql.OracleXMLSQLNoRowsException;
import oracle.xml.sql.query.OracleXMLQuery;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.ThreadSerialNum;
import oracle.xquery.XQException;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Trace;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SQLQuery
extends Expr {
    private String sqlquery = null;
    private String connstr = null;
    private Connection conn = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private String rowTag = "ROW";
    private boolean isXMLType = false;
    private String tabName = null;
    private String schName = null;
    private QName rootElementName = null;
    private OXMLSequenceType[] bindVarType = null;
    private boolean needRowTag = true;
    private boolean needXMLRes = false;
    private int QType;
    public static final int SQLQUERY_ORA_VIEW = 1;
    public static final int SQLQUERY_ORA_DOC_RES = 2;
    public static final int SQLQUERY_ORA_COLL_RES = 3;
    public static final int SQLQUERY_ORA_VIEW_RES = 4;
    private boolean hasConnStr = false;
    private boolean dbtentwo = false;

    public void setQType(int n) {
        this.QType = n;
    }

    int getType() {
        return this.QType;
    }

    @Override
    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)SQLQuery.getDoc().createElement("SQLQuery");
        XMLNode xMLNode = (XMLNode)SQLQuery.getDoc().createTextNode(this.sqlquery);
        xMLElement.appendChild((Node)xMLNode);
        return xMLElement;
    }

    @Override
    public ConvertXML fromXML(XMLElement xMLElement) {
        String string = xMLElement.getText();
        String string2 = xMLElement.getAttribute("conn");
        this.setup(string2);
        this.setSQLQuery(string);
        return this;
    }

    private void setup(String string) {
        this.connstr = string;
        if (string != null) {
            String string2 = null;
            String string3 = null;
            if (string.length() >= 4 && string.substring(0, 4).equals("jdbc")) {
                string3 = string;
            } else {
                string2 = string;
            }
            try {
                this.conn = XQueryUtils.getConnection(string2, string3);
            }
            catch (Exception exception) {
                throw new XQException(exception);
            }
        }
    }

    public SQLQuery(String string, String string2) {
        this.setup(string);
        this.setSQLQuery(string2);
    }

    public SQLQuery(Connection connection, String string) {
        this.sqlquery = string;
        this.conn = connection;
    }

    public SQLQuery() {
    }

    public SQLQuery(Connection connection, String string, Expr[] exprArray) {
        super(exprArray);
        this.sqlquery = string;
        this.conn = connection;
    }

    public void setSQLQuery(String string) {
        this.sqlquery = string;
    }

    public String getSQLQuery() {
        return this.sqlquery;
    }

    public void setSQLConn(String string) {
        this.connstr = string;
    }

    public Connection getSQLConn() {
        return this.conn;
    }

    public void setBindVarType(OXMLSequenceType[] oXMLSequenceTypeArray) {
        this.bindVarType = oXMLSequenceTypeArray;
    }

    public OXMLSequenceType[] getBindVarType() {
        return this.bindVarType;
    }

    public void setRootElement(QName qName) {
        this.rootElementName = qName;
    }

    QName getRootElementName() {
        return this.rootElementName;
    }

    public void setRowTag(String string) {
        this.rowTag = string;
    }

    public String getRowTag() {
        return this.rowTag;
    }

    public void setNeedRowTag(boolean bl) {
        this.needRowTag = bl;
    }

    public void setSchTabName(String string, String string2) {
        this.schName = string;
        this.tabName = string2;
    }

    public void setNeedXMLRes(boolean bl) {
        this.needXMLRes = bl;
    }

    public void setXMLType(String string, String string2) {
        this.isXMLType = true;
        this.setSchTabName(string, string2);
    }

    public void setHasConnStr(boolean bl) {
        this.hasConnStr = bl;
    }

    public void setDBVsn(boolean bl) {
        this.dbtentwo = bl;
    }

    public boolean getDBVsn() {
        return this.dbtentwo;
    }

    @Override
    public Expr optimize(OptimizeContext optimizeContext) {
        if (optimizeContext != null) {
            if (this.QType != 1 || this.hasConnStr) {
                optimizeContext.setXqPushdown(false);
            }
            if (optimizeContext.xqPushdown) {
                boolean bl = false;
                if (optimizeContext.sqlconn == null) {
                    int n;
                    int n2;
                    Connection connection = this.conn;
                    try {
                        DatabaseMetaData databaseMetaData = connection.getMetaData();
                        n2 = databaseMetaData.getDatabaseMajorVersion();
                        n = databaseMetaData.getDatabaseMinorVersion();
                    }
                    catch (Exception exception) {
                        throw new XQException(exception);
                    }
                    if (bl) {
                        System.out.println("major version: " + Integer.toString(n2));
                        System.out.println("minor version: " + Integer.toString(n));
                    }
                    if (n2 == 10 && n2 >= 2 || n2 > 10) {
                        optimizeContext.setSQLConn(connection);
                    } else {
                        optimizeContext.setXqPushdown(false);
                    }
                } else {
                    try {
                        DatabaseMetaData databaseMetaData = optimizeContext.sqlconn.getMetaData();
                        DatabaseMetaData databaseMetaData2 = this.conn.getMetaData();
                        String string = databaseMetaData.getURL();
                        String string2 = databaseMetaData.getUserName();
                        if (bl) {
                            System.out.println("URL: " + string);
                            System.out.println("User Name: " + string2);
                            System.out.println("Current URL: " + databaseMetaData2.getURL());
                            System.out.println("Current User: " + databaseMetaData2.getUserName());
                        }
                        if (!string.equalsIgnoreCase(databaseMetaData2.getURL()) || !string2.equalsIgnoreCase(databaseMetaData2.getUserName())) {
                            optimizeContext.setXqPushdown(false);
                        }
                    }
                    catch (Exception exception) {
                        throw new XQException(exception);
                    }
                }
            }
        }
        return super.optimize(optimizeContext);
    }

    public boolean verifyXpPushdown() {
        int n = 0;
        int n2 = 0;
        if (this.QType != 1) {
            return false;
        }
        if (this.tabName == null) {
            return false;
        }
        if (this.conn == null) {
            return false;
        }
        try {
            DatabaseMetaData databaseMetaData = this.conn.getMetaData();
            n = databaseMetaData.getDatabaseMajorVersion();
            n2 = databaseMetaData.getDatabaseMinorVersion();
        }
        catch (Exception exception) {
            return false;
        }
        if (n < 10 || n == 10 && n2 < 1) {
            return false;
        }
        if (n == 10 && n2 == 1) {
            this.setDBVsn(false);
        } else {
            this.setDBVsn(true);
        }
        return true;
    }

    public Expr xpPushdownRewrite(StringBuffer stringBuffer) {
        boolean bl = false;
        if (stringBuffer == null) {
            return this;
        }
        String string = this.schName != null ? "ora:view(''" + this.schName + "'',''" + this.tabName + "'')" : "ora:view(''" + this.tabName + "'')";
        string = "select p.column_value.getclobval() from table(xmlsequence(extract(xmlquery('" + string + "' returning content)" + ", '" + stringBuffer + "'))) p";
        if (bl) {
            System.out.println("sqlquery: " + string);
        }
        SQLQuery sQLQuery = new SQLQuery(this.conn, string);
        sQLQuery.setNeedRowTag(false);
        sQLQuery.setNeedXMLRes(true);
        sQLQuery.setXMLType(null, null);
        return sQLQuery;
    }

    private void setOXMLQuery(OracleXMLQuery oracleXMLQuery) {
        oracleXMLQuery.setDateFormat("yyyy-MM-dd");
        oracleXMLQuery.setRowsetTag("");
        if (this.needRowTag) {
            oracleXMLQuery.setRowTag(this.rowTag);
        } else {
            oracleXMLQuery.setRowTag("");
        }
        oracleXMLQuery.setRowIdAttrName(null);
        oracleXMLQuery.useTypeForCollElemTag(true);
        oracleXMLQuery.setMaxRows(1);
        oracleXMLQuery.keepObjectOpen(true);
        oracleXMLQuery.setRaiseNoRowsException(true);
        oracleXMLQuery.setRaiseException(true);
    }

    private OracleXMLQuery getOracleXMLQuery(Connection connection, String string) {
        OracleXMLQuery oracleXMLQuery = new OracleXMLQuery(connection, string);
        this.setOXMLQuery(oracleXMLQuery);
        return oracleXMLQuery;
    }

    private ResultSet getResultSetBind(Connection connection, String string, OXMLSequence[] oXMLSequenceArray) {
        ResultSet resultSet = null;
        boolean bl = false;
        if (bl) {
            System.out.println("sql query bind : " + string);
            if (connection == null) {
                System.out.println("sql query bind : connection is null");
            }
        }
        try {
            this.pstmt = connection.prepareStatement(string);
            for (int i = 0; i < oXMLSequenceArray.length; ++i) {
                Object object;
                OXMLItem oXMLItem = XQueryUtils.getEmptyOrSingleItem(oXMLSequenceArray[i]);
                if (oXMLItem != null) {
                    switch (oXMLItem.getPrimitiveType()) {
                        case 1: {
                            this.pstmt.setString(i + 1, oXMLItem.getString());
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.pstmt.setDouble(i + 1, oXMLItem.getDouble());
                            break;
                        }
                        case 5: 
                        case 22: {
                            if (oXMLItem.withinRange()) {
                                this.pstmt.setInt(i + 1, oXMLItem.getInt());
                                if (!bl) break;
                                System.out.println(Integer.toString(oXMLItem.getInt()));
                                break;
                            }
                            this.pstmt.setBigDecimal(i + 1, oXMLItem.getDecimal());
                            break;
                        }
                        case 7: {
                            SimpleTimeZone simpleTimeZone;
                            Comparable<Date> comparable;
                            object = oXMLItem.getCalendar();
                            if (oXMLItem.hasTimeZone()) {
                                GregorianCalendar gregorianCalendar;
                                TimeZone timeZone = ((GregorianCalendar)object).getTimeZone();
                                int n = ((SimpleTimeZone)timeZone).getRawOffset();
                                long l = ((Calendar)object).getTimeInMillis();
                                Timestamp timestamp = new Timestamp(l);
                                int n2 = TimeZone.getDefault().getOffset(l);
                                long l2 = l - (long)n2 + (long)n;
                                comparable = new Timestamp(l2);
                                if (bl) {
                                    System.out.println("Offset: " + Integer.toString(n));
                                    System.out.println("Time: " + l);
                                    System.out.println("JAVA Timestamp: " + timestamp.toString());
                                    System.out.println("Default Offset: " + n2);
                                }
                                if (n == 0) {
                                    simpleTimeZone = new SimpleTimeZone(0, "");
                                    gregorianCalendar = new GregorianCalendar(simpleTimeZone);
                                } else {
                                    gregorianCalendar = new GregorianCalendar(timeZone);
                                }
                                simpleTimeZone = new TIMESTAMPTZ(connection, comparable, (Calendar)gregorianCalendar);
                                if (bl) {
                                    System.out.println("TSTZ " + TIMESTAMPTZ.toString((Connection)connection, (byte[])simpleTimeZone.toBytes()));
                                }
                                ((OraclePreparedStatement)this.pstmt).setTIMESTAMPTZ(i + 1, (TIMESTAMPTZ)simpleTimeZone);
                                break;
                            }
                            long l = ((Calendar)object).getTimeInMillis();
                            TimeZone timeZone = ((GregorianCalendar)object).getTimeZone();
                            int n = ((SimpleTimeZone)timeZone).getRawOffset();
                            int n3 = TimeZone.getDefault().getOffset(l);
                            long l3 = l - (long)n3 + (long)n;
                            Timestamp timestamp = new Timestamp(l3);
                            SimpleTimeZone simpleTimeZone2 = new SimpleTimeZone(0, "");
                            comparable = new GregorianCalendar(simpleTimeZone2);
                            simpleTimeZone = new TIMESTAMPTZ(connection, timestamp, (Calendar)comparable);
                            ((OraclePreparedStatement)this.pstmt).setTIMESTAMPTZ(i + 1, (TIMESTAMPTZ)simpleTimeZone);
                        }
                    }
                    continue;
                }
                object = this.bindVarType[i];
                if (object.isOfType(OXMLSequenceType.NUMERIC_ZERO_OR_ONE)) {
                    this.pstmt.setNull(i + 1, 2);
                    continue;
                }
                this.pstmt.setNull(i + 1, 12);
            }
            resultSet = this.pstmt.executeQuery();
        }
        catch (Exception exception) {
            if (this.pstmt != null) {
                try {
                    this.pstmt.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new XQException(exception);
        }
        return resultSet;
    }

    private OracleXMLQuery getOraXMLQueryBind(Connection connection, String string, OXMLSequence[] oXMLSequenceArray) {
        OracleXMLQuery oracleXMLQuery = null;
        ResultSet resultSet = null;
        resultSet = this.getResultSetBind(connection, string, oXMLSequenceArray);
        oracleXMLQuery = new OracleXMLQuery(connection, resultSet);
        this.setOXMLQuery(oracleXMLQuery);
        return oracleXMLQuery;
    }

    private ResultSet getXMLTypeResultSet() throws Exception {
        this.stmt = this.conn.createStatement();
        return this.stmt.executeQuery(this.sqlquery);
    }

    private void getXMLTypeItem(QueryState queryState, Reader reader, OXMLItem oXMLItem, ResultSet resultSet, PageManager pageManager) throws Exception {
        Text text;
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        if (this.QType != 4 && pageManager != null) {
            dOMParser.setAttribute("oracle.xml.parser.DOMParser.PartialDOM", (Object)Boolean.TRUE);
            dOMParser.setAttribute("oracle.xml.parser.DOMParser.PageManager", (Object)pageManager);
        }
        if (!this.needXMLRes && this.rootElementName != null) {
            dOMParser.setXMLSchema((Object)queryState.getSchema());
            dOMParser.setValidationMode(3);
            dOMParser.setAttribute("oracle.xml.parser.DOMParser.SchemaPSVI", (Object)Boolean.TRUE);
        }
        dOMParser.parse(reader);
        XMLDocument xMLDocument = dOMParser.getDocument();
        if (this.QType == 4) {
            text = xMLDocument.createTextNode(resultSet.getString(2));
            Element element = xMLDocument.createElement("path");
            Node node = xMLDocument.getFirstChild();
            element.appendChild(text);
            Element element2 = xMLDocument.createElement("data");
            element2.appendChild(node);
            Element element3 = xMLDocument.createElement("res");
            element3.appendChild(element);
            element3.appendChild(element2);
            xMLDocument.appendChild((Node)element3);
        }
        if (this.needXMLRes) {
            text = (XMLNode)xMLDocument.getFirstChild();
            oXMLItem.setNode((XMLNode)text);
        } else {
            oXMLItem.setNode((XMLNode)xMLDocument);
        }
    }

    private void getRelationalXMLItem(OracleXMLQuery oracleXMLQuery, OXMLItem oXMLItem) throws OracleXMLSQLNoRowsException {
        XMLDocument xMLDocument = new XMLDocument();
        XMLNode xMLNode = (XMLNode)xMLDocument.createDocumentFragment();
        oracleXMLQuery.getXMLDOM((Node)xMLNode);
        XMLDocument xMLDocument2 = xMLNode.getDocument();
        xMLDocument2.appendChild((Node)xMLNode);
        oXMLItem.setNode((XMLNode)xMLDocument2);
    }

    @Override
    public ExprResultIterator getIterator(QueryState queryState) {
        return new SQLQueryIterator(this, queryState);
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        return this.EvaluateUsingIterator(queryState);
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
        visitor.visitOraView(this);
    }

    class SQLQueryIterator
    implements ExprResultIterator {
        SQLQuery myExpr;
        OracleXMLQuery qry;
        boolean eof;
        QueryState qryState;
        ResultSet rset;
        PageManager pgm;

        public SQLQueryIterator(SQLQuery sQLQuery2, QueryState queryState) {
            this.myExpr = sQLQuery2;
            this.eof = true;
            this.qryState = queryState;
            this.pgm = null;
        }

        @Override
        public void Restart() {
            this.eof = false;
            OXMLSequence[] oXMLSequenceArray = null;
            if (SQLQuery.this.kids != null) {
                oXMLSequenceArray = new OXMLSequence[SQLQuery.this.kids.length];
                for (int i = 0; i < SQLQuery.this.kids.length; ++i) {
                    OXMLSequenceType oXMLSequenceType = SQLQuery.this.bindVarType[i];
                    oXMLSequenceArray[i] = SQLQuery.this.kids[i].Evaluate(this.qryState);
                    oXMLSequenceArray[i] = XQueryUtils.normalizeParameter(this.qryState, oXMLSequenceType, oXMLSequenceArray[i], SQLQuery.this.kids[i].staticTypingStatus);
                    if (oXMLSequenceArray[i].isOfType(oXMLSequenceType)) continue;
                    throw new XQException(this.qryState.getMesg().getMessage0("XPTY0004"));
                }
            }
            if (this.myExpr.isXMLType || SQLQuery.this.needXMLRes) {
                if (SQLQuery.this.kids != null) {
                    this.rset = SQLQuery.this.getResultSetBind(this.myExpr.conn, this.myExpr.sqlquery, oXMLSequenceArray);
                } else {
                    try {
                        this.rset = SQLQuery.this.getXMLTypeResultSet();
                    }
                    catch (Exception exception) {
                        this.Close();
                        throw new XQException(exception);
                    }
                }
            } else {
                this.qry = SQLQuery.this.kids != null ? SQLQuery.this.getOraXMLQueryBind(this.myExpr.conn, this.myExpr.sqlquery, oXMLSequenceArray) : SQLQuery.this.getOracleXMLQuery(this.myExpr.conn, this.myExpr.sqlquery);
            }
        }

        @Override
        public OXMLItem Fetch() {
            boolean bl = false;
            if (this.eof) {
                return null;
            }
            if (SQLQuery.this.isXMLType || SQLQuery.this.needXMLRes) {
                Reader reader = null;
                try {
                    if (this.rset.next()) {
                        OXMLItem oXMLItem = this.qryState.createItem();
                        if (SQLQuery.this.isXMLType) {
                            Clob clob = this.rset.getClob(1);
                            if (clob.length() > 0L) {
                                if (bl) {
                                    System.out.println(clob.getSubString(1L, 100000));
                                }
                                reader = clob.getCharacterStream();
                                if (this.pgm == null) {
                                    this.pgm = this.getPageManager();
                                }
                                this.myExpr.getXMLTypeItem(this.qryState, reader, oXMLItem, this.rset, this.pgm);
                            }
                        } else {
                            XMLType xMLType = (XMLType)this.rset.getObject(1);
                            if (bl) {
                                System.out.println(xMLType.getStringVal());
                            }
                            reader = new StringReader(xMLType.getStringVal());
                            if (this.pgm == null) {
                                this.pgm = this.getPageManager();
                            }
                            this.myExpr.getXMLTypeItem(this.qryState, reader, oXMLItem, this.rset, this.pgm);
                        }
                        return oXMLItem;
                    }
                    this.Close();
                    return null;
                }
                catch (Exception exception) {
                    this.Close();
                    throw new XQException(exception);
                }
            }
            OXMLItem oXMLItem = this.qryState.createItem();
            try {
                SQLQuery.this.getRelationalXMLItem(this.qry, oXMLItem);
                return oXMLItem;
            }
            catch (OracleXMLSQLNoRowsException oracleXMLSQLNoRowsException) {
                this.qryState.returnItem(oXMLItem);
                this.Close();
                return null;
            }
        }

        @Override
        public void Close() {
            Trace.trace(1, this, "Entering Close");
            this.eof = true;
            if (this.qry != null) {
                this.qry.close();
            }
            if (SQLQuery.this.stmt != null) {
                try {
                    SQLQuery.this.stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (SQLQuery.this.pstmt != null) {
                try {
                    SQLQuery.this.pstmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.pgm != null) {
                this.pgm.close();
            }
            this.pgm = null;
        }

        private PageManager getPageManager() {
            PageManager pageManager = null;
            if (this.qryState.getLazyDom()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SQLQuery_");
                if (SQLQuery.this.tabName != null) {
                    stringBuffer.append(SQLQuery.this.tabName).append('_');
                }
                stringBuffer.append(ThreadSerialNum.getNextNum());
                String string = stringBuffer.toString();
                pageManager = this.qryState.getPageManagerPool().getPageManager(string);
                this.qryState.addToPgmHT(string, pageManager);
            }
            return pageManager;
        }
    }
}

