/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.util.ArrayList;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xquery.XQException;
import oracle.xquery.exec.Variable;

class RuntimeFrame {
    private ArrayList varValues;
    private ArrayList vars;

    RuntimeFrame() {
        this(-1);
    }

    RuntimeFrame(int n) {
        if (n <= 0) {
            this.varValues = new ArrayList();
            this.vars = new ArrayList();
        } else {
            this.varValues = new ArrayList(n);
            this.vars = new ArrayList(n);
        }
    }

    int size() {
        return this.varValues.size();
    }

    OXMLSequence getVarValue(Variable variable) {
        int n = variable.getValueIndex();
        return (OXMLSequence)this.varValues.get(n);
    }

    void setVarValue(Variable variable, OXMLSequence oXMLSequence) {
        int n;
        int n2 = variable.getValueIndex();
        if (n2 < (n = this.varValues.size())) {
            this.varValues.set(n2, oXMLSequence);
            this.vars.set(n2, variable);
        } else if (n2 == n) {
            this.varValues.add(oXMLSequence);
            this.vars.add(variable);
        } else {
            throw new XQException("setRuntimeValue - index: " + n2 + " size: " + n);
        }
    }

    int getNextFrameIndex() {
        return this.varValues.size();
    }

    void cleanup(RuntimeFrame runtimeFrame) {
        Variable variable;
        int n;
        int n2;
        int n3 = runtimeFrame.size();
        int n4 = n3 < (n2 = this.size()) ? n3 : n2;
        for (n = 0; n < n4; ++n) {
            variable = (Variable)runtimeFrame.vars.get(n);
            Variable variable2 = (Variable)this.vars.get(n);
            if (variable2 == variable) continue;
            variable2.resetValueIndex();
        }
        if (n2 > n3) {
            for (n = n3; n < n2; ++n) {
                variable = (Variable)this.vars.get(n);
                variable.resetValueIndex();
            }
        }
    }

    public Object clone() {
        int n = this.size();
        RuntimeFrame runtimeFrame = new RuntimeFrame(n);
        for (int i = 0; i < n; ++i) {
            runtimeFrame.varValues.add(this.varValues.get(i));
            runtimeFrame.vars.add(this.vars.get(i));
        }
        return runtimeFrame;
    }

    void reset() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)this.vars.get(i);
            variable.resetValueIndex();
        }
        this.vars = null;
        this.varValues = null;
    }

    boolean isEmpty() {
        return this.size() == 0;
    }
}

