/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xquery.XQException;
import oracle.xquery.XQMesg;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.XQueryUtils;
import org.w3c.dom.Node;

public class OXMLItemList {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private List itemArray = null;

    public OXMLItemList() {
        this.itemArray = new ArrayList();
    }

    public OXMLItemList(int n) {
        this.itemArray = new ArrayList(n);
    }

    public int getLength() {
        return this.itemArray.size();
    }

    public OXMLItem getItem(QueryState queryState, int n) {
        Object e = this.itemArray.get(n);
        if (e instanceof OXMLItem) {
            return (OXMLItem)e;
        }
        OXMLItem oXMLItem = queryState.createItem();
        oXMLItem.setNode((XMLNode)e);
        return oXMLItem;
    }

    public void addItem(OXMLItem oXMLItem) {
        this.itemArray.add(oXMLItem);
    }

    public Node getNode(int n) {
        Object e = this.itemArray.get(n);
        if (e instanceof Node) {
            return (Node)e;
        }
        OXMLItem oXMLItem = (OXMLItem)e;
        if (oXMLItem.getPrimitiveType() != 90) {
            throw new XQException(XQMesg.getInstance().getMessage0("XPTY0019"));
        }
        return oXMLItem.getNode();
    }

    public void addNode(XMLNode xMLNode) {
        this.itemArray.add(xMLNode);
    }

    public void addAll(OXMLItemList oXMLItemList) {
        this.itemArray.addAll(oXMLItemList.getList());
    }

    public List getList() {
        return this.itemArray;
    }

    public void reset() {
        this.itemArray.clear();
    }

    public Iterator getIterator() {
        return this.itemArray.iterator();
    }

    public void makeDocOrder(int n) {
        NodeCompare nodeCompare = new NodeCompare(n);
        SequenceTreeMap sequenceTreeMap = new SequenceTreeMap(nodeCompare);
        int n2 = this.itemArray.size();
        for (int i = 0; i < n2; ++i) {
            XMLNode xMLNode = (XMLNode)this.getNode(i);
            sequenceTreeMap.put(xMLNode, xMLNode);
        }
        this.itemArray = sequenceTreeMap.values();
    }

    public void removeDuplicates() {
        int n = this.itemArray.size();
        ArrayList arrayList = new ArrayList(n);
        HashMap hashMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            Object e = this.itemArray.get(i);
            if (hashMap.containsKey(e)) continue;
            arrayList.add(e);
            hashMap.put(e, e);
        }
        this.itemArray = arrayList;
    }

    class NodeCompare
    implements Comparator {
        private int sortOrder;

        public NodeCompare(int n) {
            this.sortOrder = n;
        }

        public int compare(Object object, Object object2) {
            XMLNode xMLNode = (XMLNode)object;
            XMLNode xMLNode2 = (XMLNode)object2;
            int n = XQueryUtils.compareNodeOrder(xMLNode, xMLNode2);
            if (n != 0) {
                return n * this.sortOrder;
            }
            return 0;
        }

        public boolean equals(Object object, Object object2) {
            return object == object2 ? true : this.compare(object, object2) == 0;
        }
    }

    class SequenceTreeMap {
        private TreeMap tm;

        public SequenceTreeMap(Comparator comparator) {
            this.tm = new TreeMap(comparator);
        }

        public void put(XMLNode xMLNode, XMLNode xMLNode2) {
            if (!this.tm.containsKey(xMLNode)) {
                this.tm.put(xMLNode, xMLNode2);
            }
        }

        public List values() {
            ArrayList arrayList = new ArrayList();
            Collection collection = this.tm.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList;
        }
    }
}

