/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xquery.XQException;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Expr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConvertXMLUtils {
    private static String classpath = "oracle.xquery.exec.";

    public static ConvertXML createFromXML(XMLElement xMLElement, boolean bl) {
        if (xMLElement == null) {
            return null;
        }
        String string = xMLElement.getTagName();
        string = classpath + string;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            ConvertXML convertXML = (ConvertXML)clazz.newInstance();
            convertXML = !bl ? convertXML.fromXML(xMLElement) : convertXML.DefinitionFromXML(xMLElement);
            return convertXML;
        }
        catch (Exception exception) {
            throw new XQException(exception, "createFromXML:" + string);
        }
    }

    public static void toXMLKids(XMLDocument xMLDocument, XMLNode xMLNode, ConvertXML[] convertXMLArray) {
        if (convertXMLArray == null) {
            return;
        }
        for (int i = 0; i < convertXMLArray.length; ++i) {
            XMLElement xMLElement = (XMLElement)xMLDocument.createElement("KID");
            if (convertXMLArray[i] instanceof Expr) {
                Expr expr = (Expr)convertXMLArray[i];
                ConvertXMLUtils.printStaticTypingStatus(expr, xMLElement);
            }
            xMLElement.appendChild((Node)convertXMLArray[i].toXML());
            xMLNode.appendChild((Node)xMLElement);
        }
    }

    static void printStaticTypingStatus(Expr expr, XMLElement xMLElement) {
        StringBuffer stringBuffer = new StringBuffer(20);
        if (expr.unknownStaticType()) {
            stringBuffer.append("unknown ");
        }
        if (expr.needAtomization()) {
            stringBuffer.append("atomization ");
        }
        if (expr.needCast()) {
            stringBuffer.append("cast ");
        }
        if (expr.needTypePromotion()) {
            stringBuffer.append("typePromotion ");
        }
        xMLElement.setAttribute("staticTypeStatus", stringBuffer.toString());
    }

    public static ConvertXML[] fromXMLKids(ConvertXML convertXML, XMLElement xMLElement) {
        NodeList nodeList = xMLElement.getChildrenByTagName("KID");
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        ConvertXML[] convertXMLArray = new ConvertXML[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XMLElement xMLElement2 = (XMLElement)nodeList.item(i);
            xMLElement2 = (XMLElement)xMLElement2.getFirstChild();
            convertXMLArray[i] = ConvertXMLUtils.createFromXML(xMLElement2, false);
        }
        return convertXMLArray;
    }

    public static XMLNode toXMLAndTag(XMLDocument xMLDocument, ConvertXML convertXML, String string) {
        XMLNode xMLNode = convertXML.toXML();
        XMLElement xMLElement = (XMLElement)xMLDocument.createElement(string);
        if (convertXML instanceof Expr) {
            ConvertXMLUtils.printStaticTypingStatus((Expr)convertXML, xMLElement);
        }
        xMLElement.appendChild((Node)xMLNode);
        return xMLElement;
    }

    public static ConvertXML fromXMLUntag(XMLElement xMLElement, String string) {
        NodeList nodeList = xMLElement.getChildrenByTagName(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        XMLElement xMLElement2 = (XMLElement)nodeList.item(0).getFirstChild();
        return ConvertXMLUtils.createFromXML(xMLElement2, false);
    }

    public static ConvertXML[] fromXMLUntagMany(XMLElement xMLElement, String string) {
        NodeList nodeList = xMLElement.getChildrenByTagName(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        ConvertXML[] convertXMLArray = new ConvertXML[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            convertXMLArray[i] = ConvertXMLUtils.createFromXML((XMLElement)nodeList.item(i), false);
        }
        return convertXMLArray;
    }

    public static ConvertXML fromXMLUntag(XMLElement xMLElement) {
        XMLElement xMLElement2 = (XMLElement)xMLElement.getFirstChild();
        return xMLElement2 == null ? null : ConvertXMLUtils.createFromXML(xMLElement2, false);
    }
}

