/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.util.HashSet;
import oracle.xquery.XQException;
import oracle.xquery.exec.AbstractVisitor;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.FunctionCall;
import oracle.xquery.exec.LetExpr;
import oracle.xquery.exec.QueryState;

public class CircularityDetectionVisitor
extends AbstractVisitor {
    private LetExpr var;
    private QueryState qs;
    private HashSet fds;

    public CircularityDetectionVisitor(LetExpr letExpr, QueryState queryState) {
        this.var = letExpr;
        this.qs = queryState;
        this.fds = new HashSet();
    }

    private void raiseError() {
        throw new XQException(this.qs.getMesg().getMessage0("XQST0054"));
    }

    @Override
    public void visitLetExpr(LetExpr letExpr) {
        if (letExpr == this.var) {
            this.raiseError();
        }
        letExpr.kids[0].acceptVisitor(this);
    }

    @Override
    public void visitFunctionCall(FunctionCall functionCall) {
        this.generalVisit(functionCall);
        if (this.fds.contains(functionCall.fd)) {
            return;
        }
        if (functionCall.fd.getFunctionObj() == null) {
            this.fds.add(functionCall.fd);
            Expr expr = functionCall.fd.getFunctionExpr();
            expr.acceptVisitor(this);
        }
    }
}

