/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.XQException;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;

public class ArithOp
extends Expr {
    int type;

    @Override
    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)ArithOp.getDoc().createElement("ArithOp");
        xMLElement.setAttribute("type", XQueryUtils.getOperatorString(this.type));
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    @Override
    public ConvertXML fromXML(XMLElement xMLElement) {
        this.type = XQueryUtils.getOperatorConstant(xMLElement.getAttribute("type"));
        this.fromXMLKids(xMLElement);
        return this;
    }

    @Override
    public void getStrRep(StringBuffer stringBuffer) {
        this.toKidsStrRep(stringBuffer, XQueryUtils.getOperatorString(this.type));
    }

    @Override
    public void toSql(XQXGen xQXGen) {
        xQXGen.startElement("function", XQXGen.createAttrs("builtin", "true", "infix", "true", "name", XQueryUtils.getOperatorString(this.type)));
        this.toSqlDefault(xQXGen);
        xQXGen.endElement("function");
    }

    public ArithOp(int n, Expr expr) {
        super(expr);
        this.type = n;
    }

    public ArithOp(int n, Expr expr, Expr expr2) {
        super(expr, expr2);
        this.type = n;
    }

    public ArithOp(int n, Expr[] exprArray) {
        super(exprArray);
        this.type = n;
    }

    public ArithOp() {
    }

    @Override
    public OXMLSequence Evaluate(QueryState queryState) {
        OXMLSequence oXMLSequence = this.kids[0].Evaluate(queryState);
        boolean bl = this.kids[0].needAtomization();
        if (bl) {
            oXMLSequence = oXMLSequence.atomize();
        }
        if (!oXMLSequence.next()) {
            return bl ? queryState.createSequence(oXMLSequence) : queryState.createSequence();
        }
        OXMLSequence oXMLSequence2 = this.kids[1].Evaluate(queryState);
        boolean bl2 = this.kids[1].needAtomization();
        if (bl2) {
            oXMLSequence2 = oXMLSequence2.atomize();
        }
        if (!oXMLSequence2.next()) {
            return bl2 ? queryState.createSequence(oXMLSequence2) : queryState.createSequence();
        }
        OXMLItem oXMLItem = queryState.createItem();
        OXMLItem oXMLItem2 = oXMLSequence.getItem();
        OXMLItem oXMLItem3 = oXMLSequence2.getItem();
        if (oXMLSequence.next()) {
            throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
        }
        if (oXMLSequence2.next()) {
            throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
        }
        if (this.kids[0].needCast() && FNUtil.isUntypedAtomic((OXMLItem)oXMLItem2)) {
            oXMLItem2 = XQueryUtils.convert(oXMLItem2, OXMLSequenceType.TDOUBLE, queryState);
        }
        if (this.kids[1].needCast() && FNUtil.isUntypedAtomic((OXMLItem)oXMLItem3)) {
            oXMLItem3 = XQueryUtils.convert(oXMLItem3, OXMLSequenceType.TDOUBLE, queryState);
        }
        XQueryUtils.arithmetic(oXMLItem2, oXMLItem3, this.type, oXMLItem);
        if (bl) {
            queryState.returnSequence(oXMLSequence);
        }
        if (bl2) {
            queryState.returnSequence(oXMLSequence2);
        }
        return queryState.createSequence(oXMLItem);
    }

    @Override
    public void acceptVisitor(Visitor visitor) {
        visitor.visitArithmeticExpr(this);
    }
}

