/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.comp;

import java.util.BitSet;
import java.util.Hashtable;
import oracle.xquery.XQException;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.NodeSource;
import oracle.xquery.exec.VarExpr;

public class QueryMgr {
    static QueryMgr qryMgr = new QueryMgr();
    Hashtable nodeInfo = new Hashtable();
    Hashtable exprInfo = new Hashtable();

    public BitSet getDeplist(NodeSource nodeSource) {
        NodeInfo nodeInfo = (NodeInfo)this.nodeInfo.get(nodeSource);
        if (nodeInfo == null) {
            throw new XQException("Invalid node " + nodeSource.toString());
        }
        return nodeInfo.deps;
    }

    public BitSet getDeplist(Expr expr) {
        ExprInfo exprInfo = (ExprInfo)this.exprInfo.get(expr);
        if (exprInfo == null) {
            throw new XQException("Invalid expression " + expr.toString());
        }
        return exprInfo.deps;
    }

    public void registerExpr(Expr expr, BitSet bitSet) {
        if (this.exprInfo.get(expr) != null) {
            throw new XQException("Duplicate entry for expression " + expr.toString());
        }
        ExprInfo exprInfo = new ExprInfo(bitSet);
        this.exprInfo.put(expr, exprInfo);
    }

    public void registerNode(NodeSource nodeSource, BitSet bitSet) {
        if (this.nodeInfo.get(nodeSource) != null) {
            throw new XQException("Duplicate entry for node " + nodeSource.toString());
        }
        NodeInfo nodeInfo = new NodeInfo(bitSet);
        VarExpr varExpr = nodeSource.getOutVariable();
        if (varExpr != null) {
            ExprInfo exprInfo = (ExprInfo)this.exprInfo.get(varExpr);
            if (exprInfo == null) {
                throw new XQException("No entry for variable " + varExpr.toString());
            }
            exprInfo.deps.set(nodeInfo.nodeId);
            exprInfo.deps.or(bitSet);
        }
        this.nodeInfo.put(nodeSource, nodeInfo);
    }

    public static BitSet getDependencies(NodeSource nodeSource) {
        return qryMgr.getDeplist(nodeSource);
    }

    public static BitSet getDependencies(Expr expr) {
        return qryMgr.getDeplist(expr);
    }

    public static void register(NodeSource nodeSource, BitSet bitSet) {
        qryMgr.registerNode(nodeSource, bitSet);
    }

    public static void register(Expr expr, BitSet bitSet) {
        qryMgr.registerExpr(expr, bitSet);
    }

    private static class ExprInfo {
        BitSet deps;

        ExprInfo(BitSet bitSet) {
            this.deps = bitSet;
        }
    }

    private static class NodeInfo {
        static int id = 0;
        int nodeId;
        BitSet deps;

        NodeInfo(BitSet bitSet) {
            this.deps = bitSet;
            this.nodeId = id++;
        }
    }
}

