/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.ideimpl.webbrowser.BrowserOptionsPanel;
import oracle.ideimpl.webbrowser.InternetFilesPanel;

public class WebBrowserAndProxyPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private BrowserOptionsPanel browserOptionsPanel;
    private ProxySettingsPanel proxyPanel;
    private InternetFilesPanel internetFilesPanel;
    private JTabbedPane tabbedPane;

    public WebBrowserAndProxyPanel() {
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    private void initializeComponent() {
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        this.browserOptionsPanel = new BrowserOptionsPanel();
        JPanel browsersTabPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, emptyInsets, 0, 0);
        browsersTabPanel.add((Component)((Object)this.browserOptionsPanel), constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, emptyInsets, 0, 0);
        browsersTabPanel.add(Box.createGlue(), constraints);
        this.proxyPanel = new ProxySettingsPanel();
        JPanel proxyTabPanel = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, emptyInsets, 0, 0);
        proxyTabPanel.add((Component)((Object)this.proxyPanel), constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, emptyInsets, 0, 0);
        proxyTabPanel.add(Box.createGlue(), constraints);
        this.internetFilesPanel = new InternetFilesPanel();
        JPanel internetFilesTabPanel = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, defaultInsets, 0, 0);
        internetFilesTabPanel.add((Component)((Object)this.internetFilesPanel), constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, emptyInsets, 0, 0);
        internetFilesTabPanel.add(Box.createGlue(), constraints);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(BrowserArb.getString(20), browsersTabPanel);
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab(BrowserArb.getString(21), proxyTabPanel);
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.addTab(BrowserArb.getString(22), internetFilesTabPanel);
        this.tabbedPane.setMnemonicAt(2, 51);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        this.add(this.tabbedPane, constraints);
    }

    public void onEntry(TraversableContext tc) {
        this.browserOptionsPanel.onEntry(tc);
        this.proxyPanel.onEntry(tc);
        this.internetFilesPanel.onEntry(tc);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this.browserOptionsPanel.onExit(tc);
        this.proxyPanel.onExit(tc);
        this.internetFilesPanel.onExit(tc);
    }

    public String getHelpID() {
        Component selectedPanelComponent;
        Component selectedComponent = this.tabbedPane.getSelectedComponent();
        if (selectedComponent instanceof JPanel) {
            // empty if block
        }
        if ((selectedPanelComponent = ((JPanel)selectedComponent).getComponent(0)) instanceof DefaultTraversablePanel) {
            return ((DefaultTraversablePanel)selectedPanelComponent).getHelpID();
        }
        return this.browserOptionsPanel.getHelpID();
    }

    public void apply(ApplyEvent e) {
        if (this.proxyPanel != null) {
            this.proxyPanel.apply(e);
        }
    }

    public void cancel(ApplyEvent e) {
        if (this.proxyPanel != null) {
            this.proxyPanel.cancel(e);
        }
    }
}

