/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.IdeProxySelector;
import oracle.ideimpl.webbrowser.Strings;
import oracle.javatools.util.PlatformUtils;

public class SystemProxySettings {
    private static final Logger LOG = Logger.getLogger(SystemProxySettings.class.getName());
    static boolean initialized = false;
    static SystemProxyType systemProxyType;
    static String systemProxyHost;
    static String systemProxyPort;
    static String systemSocksHost;
    static String systemSocksPort;
    static String systemProxyExceptions;
    public static final String JDEVELOPER_SYSTEM_HTTP_PROXY = "jdeveloper.system_http_proxy";
    public static final String JDEVELOPER_SYSTEM_SOCKS_PROXY = "jdeveloper.system_socks_proxy";
    public static final String JDEVELOPER_SYSTEM_NON_PROXY_HOSTS = "jdeveloper.system_http_non_proxy_hosts";
    public static final String DIRECT = "DIRECT";
    public static final String PAC_PREFIX = "PAC ";
    public static final String HTTP_PROTOCOL_PREFIX = "http://";
    public static final String DEFAULT_HTTP_PROXY_PORT = "80";
    public static final String DEFAULT_SOCKS_PROXY_PORT = "1080";

    static void initializeSystemProxySettings() {
        if (initialized) {
            return;
        }
        String proxyHost = System.getProperty(JDEVELOPER_SYSTEM_HTTP_PROXY);
        if (DIRECT.equals(proxyHost) || proxyHost == null || proxyHost.trim().length() == 0) {
            systemProxyType = SystemProxyType.DIRECT_CONNECTION;
            systemProxyHost = null;
            systemProxyPort = null;
            systemSocksHost = null;
            systemSocksPort = null;
            systemProxyExceptions = null;
        } else if (proxyHost.startsWith(PAC_PREFIX)) {
            systemProxyType = SystemProxyType.PAC;
            String SOME_EXTERNAL_HTTP_URL = "http://www.internic.net";
            try {
                List<Proxy> proxyList;
                URI someExtHttpUri = new URI("http://www.internic.net");
                String pacFile = SystemProxySettings.getSystemProxyAutoConfigUrl();
                if (pacFile != null && (proxyList = IdeProxySelector.resolveProxyListFromPAC(someExtHttpUri, pacFile)).size() > 0) {
                    Proxy p = proxyList.get(0);
                    if (Proxy.Type.DIRECT == p.type()) {
                        systemProxyHost = null;
                        systemProxyPort = null;
                    } else if (p.address() instanceof InetSocketAddress) {
                        systemProxyHost = ((InetSocketAddress)p.address()).getHostName();
                        systemProxyPort = Integer.toString(((InetSocketAddress)p.address()).getPort());
                    } else {
                        systemProxyHost = null;
                    }
                }
                systemSocksHost = null;
                systemSocksPort = null;
                systemProxyExceptions = ProxyOptions.ensureLocalExceptionsAdded(null);
            }
            catch (Exception e) {
                LOG.fine("Failed to get system proxy settings from DefaultProxySelector. Default to no proxy.");
            }
        } else {
            String systemSocksProxy;
            systemProxyType = SystemProxyType.MANUAL_PROXY;
            if (proxyHost != null) {
                String[] hostAndPort = Strings.hostAndPort(proxyHost);
                if (hostAndPort != null) {
                    systemProxyHost = hostAndPort[0];
                    systemProxyPort = hostAndPort[1] == null ? DEFAULT_HTTP_PROXY_PORT : hostAndPort[1];
                } else {
                    LOG.warning("jdeveloper.system_http_proxy env var is invalid: " + proxyHost);
                }
            }
            if ((systemSocksProxy = System.getProperty(JDEVELOPER_SYSTEM_SOCKS_PROXY)) != null) {
                String[] socksHostAndPort = Strings.hostAndPort(systemSocksProxy);
                if (socksHostAndPort != null) {
                    systemSocksHost = socksHostAndPort[0];
                    systemSocksPort = socksHostAndPort[1] == null ? DEFAULT_SOCKS_PROXY_PORT : socksHostAndPort[1];
                } else {
                    LOG.warning("jdeveloper.system_socks_proxy env var is invalid: " + systemSocksProxy);
                }
            }
            String nonProxyHosts = System.getProperty(JDEVELOPER_SYSTEM_NON_PROXY_HOSTS);
            systemProxyExceptions = ProxyOptions.ensureLocalExceptionsAdded(nonProxyHosts);
        }
        initialized = true;
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        proxyOptions.applyToCurrentVM();
    }

    public static boolean isDirectConnectionType() {
        SystemProxySettings.initializeSystemProxySettings();
        return systemProxyType == SystemProxyType.DIRECT_CONNECTION;
    }

    public static boolean isProxyAutoConfigurationType() {
        SystemProxySettings.initializeSystemProxySettings();
        return systemProxyType == SystemProxyType.PAC;
    }

    public static boolean isManulProxyType() {
        SystemProxySettings.initializeSystemProxySettings();
        return systemProxyType == SystemProxyType.MANUAL_PROXY;
    }

    public static SystemProxyType getSystemProxyType() {
        SystemProxySettings.initializeSystemProxySettings();
        return systemProxyType;
    }

    public static String getSystemProxyHost() {
        SystemProxySettings.initializeSystemProxySettings();
        return systemProxyHost;
    }

    public static String getSystemProxyPort() {
        SystemProxySettings.initializeSystemProxySettings();
        return systemProxyPort;
    }

    public static String getSystemSocksHost() {
        SystemProxySettings.initializeSystemProxySettings();
        return systemSocksHost;
    }

    public static String getSystemSocksPort() {
        SystemProxySettings.initializeSystemProxySettings();
        return systemSocksPort;
    }

    public static String getSystemProxyExceptions() {
        SystemProxySettings.initializeSystemProxySettings();
        return systemProxyExceptions;
    }

    public static String getSystemProxyAutoConfigUrl() {
        if (System.getProperty(JDEVELOPER_SYSTEM_HTTP_PROXY) != null && System.getProperty(JDEVELOPER_SYSTEM_HTTP_PROXY).startsWith(PAC_PREFIX)) {
            return System.getProperty(JDEVELOPER_SYSTEM_HTTP_PROXY).substring(4);
        }
        return null;
    }

    protected static void initSystemProxyVariablesIfNecessary() {
        block18: {
            if (PlatformUtils.isWindows()) {
                try {
                    String[] proxySettings = SystemProxySettings.readProxySettingsFromRegistry();
                    if (proxySettings == null) {
                        System.setProperty(JDEVELOPER_SYSTEM_HTTP_PROXY, DIRECT);
                        break block18;
                    }
                    if (proxySettings.length == 1) {
                        System.setProperty(JDEVELOPER_SYSTEM_HTTP_PROXY, PAC_PREFIX + proxySettings[0]);
                        break block18;
                    }
                    if (proxySettings.length == 2) {
                        if (proxySettings[0] == null) {
                            System.setProperty(JDEVELOPER_SYSTEM_HTTP_PROXY, DIRECT);
                        } else {
                            String[] hostAndPort = Strings.hostAndPort(proxySettings[0]);
                            if (hostAndPort == null || hostAndPort[0] == null) {
                                System.setProperty(JDEVELOPER_SYSTEM_HTTP_PROXY, DIRECT);
                            } else {
                                if (hostAndPort[1] == null) {
                                    hostAndPort[1] = DEFAULT_HTTP_PROXY_PORT;
                                }
                                String proxyExceptions = ProxyOptions.ensureLocalExceptionsAdded(proxySettings[1]);
                                System.setProperty(JDEVELOPER_SYSTEM_HTTP_PROXY, hostAndPort[0] + ":" + hostAndPort[1]);
                                System.setProperty(JDEVELOPER_SYSTEM_NON_PROXY_HOSTS, proxyExceptions);
                                System.clearProperty(JDEVELOPER_SYSTEM_SOCKS_PROXY);
                            }
                        }
                        break block18;
                    }
                    System.setProperty(JDEVELOPER_SYSTEM_HTTP_PROXY, DIRECT);
                }
                catch (UnsupportedOperationException e) {
                    LOG.warning("Unable to default HTTP proxy: " + e.getMessage());
                }
                catch (IllegalStateException e) {
                    LOG.warning("Unable to default HTTP proxy: " + e.getMessage());
                }
            } else {
                if (System.getProperty(JDEVELOPER_SYSTEM_HTTP_PROXY) != null) {
                    return;
                }
                String httpProxy = SystemProxySettings.getenv("http_proxy");
                if (httpProxy == null) {
                    System.setProperty(JDEVELOPER_SYSTEM_HTTP_PROXY, DIRECT);
                    return;
                }
                String[] hostAndPort = Strings.hostAndPort(httpProxy);
                if (hostAndPort == null || hostAndPort[0] == null) {
                    System.setProperty(JDEVELOPER_SYSTEM_HTTP_PROXY, DIRECT);
                } else {
                    if (hostAndPort[1] == null) {
                        hostAndPort[1] = DEFAULT_HTTP_PROXY_PORT;
                    }
                    String noProxy = SystemProxySettings.getenv("no_proxy");
                    String proxyExceptions = ProxyOptions.ensureLocalExceptionsAdded(noProxy);
                    System.setProperty(JDEVELOPER_SYSTEM_HTTP_PROXY, hostAndPort[0] + ":" + hostAndPort[1]);
                    System.setProperty(JDEVELOPER_SYSTEM_NON_PROXY_HOSTS, proxyExceptions);
                    System.clearProperty(JDEVELOPER_SYSTEM_SOCKS_PROXY);
                }
            }
        }
    }

    static String getenv(String envVar) {
        String value = System.getenv(envVar.toLowerCase());
        if (value == null) {
            value = System.getenv(envVar.toUpperCase());
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readProxySettingsFromRegistry() {
        RegistryKey userKeyHive;
        String KEY_INTERNET_SETTINGS = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
        String KEY_PROXY_ENABLE = "ProxyEnable";
        String KEY_PROXY_SERVER_NAME = "ProxyServer";
        String KEY_PROXY_OVERRIDE_NAME = "ProxyOverride";
        String KEY_AUTO_CONFIG_URL = "AutoConfigURL";
        try {
            userKeyHive = NativeHandler.getRegistry().getCurrentUserKey();
        }
        catch (Exception e) {
            return null;
        }
        if (userKeyHive == null) {
            return null;
        }
        RegistryKey internetSettingsKey = null;
        boolean isManualProxyEnabled = false;
        String serverName = null;
        String overrideName = null;
        String autoConfigUrl = null;
        try {
            String[] stringArray;
            internetSettingsKey = userKeyHive.openKey("Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings", 131097L);
            if (internetSettingsKey != null) {
                try {
                    isManualProxyEnabled = internetSettingsKey.getNumericValue("ProxyEnable") > 0L;
                }
                catch (RegistryException registryException) {
                    // empty catch block
                }
                try {
                    serverName = internetSettingsKey.getStringValue("ProxyServer");
                }
                catch (RegistryException registryException) {
                    // empty catch block
                }
                try {
                    overrideName = internetSettingsKey.getStringValue("ProxyOverride");
                }
                catch (RegistryException registryException) {
                    // empty catch block
                }
                try {
                    autoConfigUrl = internetSettingsKey.getStringValue("AutoConfigURL");
                }
                catch (RegistryException registryException) {
                    // empty catch block
                }
            }
            if (isManualProxyEnabled) {
                stringArray = new String[]{serverName, overrideName};
                return stringArray;
            }
            if (autoConfigUrl != null) {
                stringArray = new String[]{autoConfigUrl};
                return stringArray;
            }
            stringArray = null;
            return stringArray;
        }
        catch (Exception e) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (internetSettingsKey != null) {
                try {
                    internetSettingsKey.close();
                }
                catch (RegistryException e) {
                    return null;
                }
            }
        }
    }

    public static enum SystemProxyType {
        DIRECT_CONNECTION,
        MANUAL_PROXY,
        PAC;

    }
}

