/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.ProxyAutoConfig;
import oracle.ideimpl.webbrowser.SystemProxySettings;

public class IdeProxySelector
extends ProxySelector {
    private static final Logger LOG = Logger.getLogger(IdeProxySelector.class.getName());
    private static final List<Proxy> NO_PROXY_LIST = Collections.singletonList(Proxy.NO_PROXY);
    private static ProxySelector original = null;
    private static ThreadLocal<ProxyOptions> tempProxyOptions = new ThreadLocal();

    public IdeProxySelector(ProxySelector originalProxySelector) {
        original = originalProxySelector;
    }

    public static void setTemporaryProxyOptions(ProxyOptions newTempProxyOptions) {
        LOG.fine("Setting temporary proxy options for IdeProxySelector");
        tempProxyOptions.set(newTempProxyOptions);
        newTempProxyOptions.applyToCurrentVM();
    }

    public static void clearTemporaryProxyOptions() {
        LOG.fine("Clearing temporary proxy options for IdeProxySelector");
        tempProxyOptions.set(null);
        ProxyOptions.getProxyOptions().applyToCurrentVM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Proxy> select(URI uri) {
        String scheme = uri.getScheme();
        if (!"http".equals(scheme) && !"https".equals(scheme)) {
            return NO_PROXY_LIST;
        }
        ProxyOptions.doTaskLock.lock();
        try {
            if (uri == null) {
                throw new IllegalArgumentException("URI must not be null.");
            }
            ProxyOptions activeProxyOptions = tempProxyOptions.get() == null ? ProxyOptions.getProxyOptions() : tempProxyOptions.get();
            ProxyOptions.ProxyType activeProxyType = activeProxyOptions.getProxyType();
            if (ProxyOptions.ProxyType.SYSTEM_PROXY.equals((Object)activeProxyType)) {
                if (SystemProxySettings.isDirectConnectionType()) {
                    List<Proxy> list = NO_PROXY_LIST;
                    return list;
                }
                if (SystemProxySettings.isProxyAutoConfigurationType()) {
                    String pacFile = SystemProxySettings.getSystemProxyAutoConfigUrl();
                    List<Proxy> list = IdeProxySelector.resolveProxyListFromPAC(uri, pacFile);
                    return list;
                }
                if (SystemProxySettings.isManulProxyType()) {
                    String httpHost = SystemProxySettings.getSystemProxyHost();
                    String httpPort = SystemProxySettings.getSystemProxyPort();
                    String socksHost = SystemProxySettings.getSystemSocksHost();
                    String socksPort = SystemProxySettings.getSystemSocksPort();
                    String proxyExceptions = SystemProxySettings.getSystemProxyExceptions();
                    List<Proxy> list = IdeProxySelector.resolveProxyList(uri, httpHost, httpPort, socksHost, socksPort, proxyExceptions);
                    return list;
                }
                throw new IllegalStateException("Invalid System Proxy type");
            }
            if (ProxyOptions.ProxyType.DIRECT_CONNECTION.equals((Object)activeProxyType)) {
                List<Proxy> httpHost = NO_PROXY_LIST;
                return httpHost;
            }
            if (ProxyOptions.ProxyType.PAC.equals((Object)activeProxyOptions.getProxyType())) {
                String pacFile = activeProxyOptions.getAutoConfigScript();
                List<Proxy> httpPort = IdeProxySelector.resolveProxyListFromPAC(uri, pacFile);
                return httpPort;
            }
            if (ProxyOptions.ProxyType.MANUAL_PROXY.equals((Object)activeProxyType)) {
                String httpHost = activeProxyOptions.getProxyHost();
                String httpPort = activeProxyOptions.getProxyPort();
                String proxyExceptions = activeProxyOptions.getProxyExceptions();
                List<Proxy> list = IdeProxySelector.resolveProxyList(uri, httpHost, httpPort, null, null, proxyExceptions);
                return list;
            }
            try {
                throw new IllegalStateException("Invalid Proxy Type: " + (activeProxyType != null ? activeProxyType : "null"));
            }
            catch (Exception e) {
                LOG.fine("Failed to resolve a proxy for " + uri + ": exception = " + e.getMessage());
                List<Proxy> list = NO_PROXY_LIST;
                return list;
            }
        }
        finally {
            ProxyOptions.doTaskLock.unlock();
        }
    }

    public static List<Proxy> resolveProxyListFromPAC(URI uri, String pacFile) {
        ProxyAutoConfig pac = null;
        try {
            pac = ProxyAutoConfig.get(pacFile);
        }
        catch (Throwable t) {
            LOG.finest("Error retrieving Proxy Auto Config file " + pacFile + ": exception = " + t.getMessage());
        }
        if (pac == null) {
            LOG.finest("No instance of ProxyAutoConfig(" + pacFile + ") for URI " + uri);
            return NO_PROXY_LIST;
        }
        if (pac.getPacURI().getHost() == null || pac.getPacURI().getHost().equals(uri.getHost())) {
            LOG.finest("Malformed PAC URI " + pac.getPacURI() + " for URI " + uri);
            return NO_PROXY_LIST;
        }
        List<Proxy> proxies = pac.findProxyForURL(uri);
        return proxies;
    }

    private static List<Proxy> resolveProxyList(URI uri, String httpHost, String httpPort, String socksHost, String socksPort, String proxyExceptions) throws Exception {
        InetSocketAddress addr;
        if (!(httpHost != null && httpHost.trim().length() != 0 || socksHost != null && socksHost.trim().length() != 0)) {
            return NO_PROXY_LIST;
        }
        String[] exceptions = ProxyOptions.splitExceptionsIntoArray(proxyExceptions);
        if (exceptions != null) {
            for (String exception : exceptions) {
                if (!exception.equalsIgnoreCase(uri.getHost())) continue;
                return NO_PROXY_LIST;
            }
        }
        ArrayList<Proxy> res = new ArrayList<Proxy>(2);
        if (httpHost != null && httpHost.trim().length() > 0) {
            int httpPortParsed = 80;
            if (httpPort != null && httpPort.trim().length() > 0) {
                httpPortParsed = Integer.parseInt(httpPort);
            }
            addr = new InetSocketAddress(httpHost, httpPortParsed);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
            res.add(proxy);
        }
        if (socksHost != null && socksHost.trim().length() > 0) {
            int socksPortParsed = 80;
            if (socksPort != null && socksPort.trim().length() > 0) {
                socksPortParsed = Integer.parseInt(socksPort);
            }
            addr = new InetSocketAddress(socksHost, socksPortParsed);
            Proxy proxy = new Proxy(Proxy.Type.SOCKS, addr);
            res.add(proxy);
        }
        if (res.size() > 0) {
            return res;
        }
        return NO_PROXY_LIST;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        LOG.fine("Connection failed: URI + " + uri + ", exception: " + ioe.getMessage());
    }

    public ProxySelector getOriginalProxySelector() {
        return original;
    }
}

