/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.javatools.util.Pair;
import oracle.javatools.util.PlatformUtils;
import oracle.security.misc.Checksum;

public final class Util {
    private static Boolean _cachedInternal;
    private static List<Worker> _queue;
    private static Thread _detectThread;
    private static final String _forceReadTimeout;
    static String charsetName;
    static String csn;

    private Util() {
    }

    public static void isInsideOracle(Worker worker) {
        Boolean result = Util.isInsideOracleImpl(worker);
        if (result != null) {
            worker.onResult(result);
        }
    }

    private static synchronized Boolean isInsideOracleImpl(Worker worker) {
        if (_cachedInternal != null) {
            return (boolean)_cachedInternal;
        }
        _queue.add(worker);
        if (_detectThread == null) {
            _detectThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean result = Util.detectInternal();
                    List queueCopy = Util.setIsInsideOracle(result);
                    Iterator i = queueCopy.iterator();
                    while (i.hasNext()) {
                        ((Worker)i.next()).onResult(result);
                    }
                }
            });
            _detectThread.start();
        }
        return null;
    }

    private static synchronized List<Worker> setIsInsideOracle(Boolean isInsideOracle) {
        _cachedInternal = isInsideOracle;
        LinkedList<Worker> queueCopy = new LinkedList<Worker>();
        queueCopy.addAll(_queue);
        _queue.clear();
        return queueCopy;
    }

    @Deprecated
    public static synchronized boolean isInsideOracle() {
        if (_cachedInternal != null) {
            return _cachedInternal;
        }
        _cachedInternal = Util.detectInternal();
        return _cachedInternal;
    }

    private static boolean isVerboseLogging() {
        return Boolean.getBoolean("ide.internalcheck.verbose");
    }

    private static boolean detectInternal() {
        try {
            if (Util.pingIdeWebSite()) {
                if (Util.isVerboseLogging()) {
                    System.err.println("Detected internal user: pinged internal website");
                }
                return true;
            }
            if (Util.checkHostname()) {
                if (Util.isVerboseLogging()) {
                    System.err.println("Detected internal user from hostname");
                }
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (Util.isVerboseLogging()) {
                System.err.println("Failed to detect internal user");
                t.printStackTrace();
            }
            return false;
        }
    }

    private static synchronized boolean checkHostname() {
        block4: {
            try {
                InetAddress[] inets = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                for (int i = 0; i < inets.length; ++i) {
                    String hostName = inets[i].getCanonicalHostName();
                    if (hostName == null || !hostName.endsWith(".oracle.com")) continue;
                    return true;
                }
            }
            catch (UnknownHostException uhe) {
                if (!Util.isVerboseLogging()) break block4;
                uhe.printStackTrace();
            }
        }
        if (Util.isVerboseLogging()) {
            System.err.println("Failed to detect internal user: No hostname contains .oracle.com");
        }
        return false;
    }

    private static synchronized boolean pingIdeWebSite() {
        ProxyOptions tmppo = new ProxyOptions();
        tmppo.setProxyType(ProxyOptions.ProxyType.DIRECT_CONNECTION);
        final boolean[] response = new boolean[]{false};
        tmppo.doTask(new Runnable(){

            @Override
            public void run() {
                ArrayList<Pair> pingSites = new ArrayList<Pair>();
                String internalCheckUrl = System.getProperty("ide.internalcheck.url");
                if (internalCheckUrl != null) {
                    String internalCheckExpr = System.getProperty("ide.internalcheck.regex");
                    pingSites.add(new Pair((Object)internalCheckUrl, (Object)internalCheckExpr));
                }
                pingSites.add(new Pair((Object)"http://ide.us.oracle.com/internal.txt", (Object)"^OK"));
                pingSites.add(new Pair((Object)"http://wpad.us.oracle.com/wpad.dat", (Object)"Oracle NIS group"));
                for (Pair urlAndRegex : pingSites) {
                    response[0] = Util.httpPing((String)urlAndRegex.getFirst(), (String)urlAndRegex.getSecond());
                    if (!response[0]) continue;
                    break;
                }
            }
        });
        return response[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean httpPing(String urlString, String expr) {
        boolean result = false;
        InputStream in = null;
        URLConnection conn = null;
        try {
            URL urlToPing = new URL(urlString);
            conn = urlToPing.openConnection();
            conn.setConnectTimeout(800);
            if (!PlatformUtils.isMac() || Boolean.parseBoolean(_forceReadTimeout)) {
                conn.setReadTimeout(800);
            }
            if (expr == null) {
                ((HttpURLConnection)conn).setRequestMethod("HEAD");
            }
            conn.connect();
            int resp = ((HttpURLConnection)conn).getResponseCode();
            if (resp >= 200 && resp <= 299) {
                if (expr == null) {
                    result = true;
                } else {
                    in = conn.getInputStream();
                    Scanner scanner = new Scanner(in);
                    String match = scanner.findWithinHorizon(expr, 0);
                    boolean bl = result = match != null;
                    if (!result && Util.isVerboseLogging()) {
                        System.err.println("Response from " + urlString + " did not match expected pattern when detecting internal user.");
                    }
                }
            }
        }
        catch (IOException ioe) {
            if (Util.isVerboseLogging()) {
                System.err.println("Could not connect to " + urlString + " when detecting internal user.");
                ioe.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return result;
    }

    public static String encode(String data) {
        if (data == null) {
            return null;
        }
        try {
            byte[] b = data.getBytes();
            return Util.e(Checksum.MD5((byte[])b, null));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String encode(char[] data) {
        if (data == null) {
            return null;
        }
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outStream, csn);
            out.write(data);
            ((Writer)out).close();
            byte[] b = outStream.toByteArray();
            String encodedData = Util.e(Checksum.MD5((byte[])b, null));
            for (int j = 0; j < b.length; ++j) {
                b[j] = 32;
            }
            return encodedData;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String decode(String data) {
        if (data == null) {
            return null;
        }
        byte[] b = Util.d(data);
        if (b.length > 0) {
            try {
                b = Checksum.SHA((byte[])b, null);
                return new String(b);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public static char[] decodeCharArray(String data) {
        if (data == null) {
            return null;
        }
        byte[] b = Util.d(data);
        if (b.length > 0) {
            try {
                int ch;
                b = Checksum.SHA((byte[])b, null);
                String charsetName = Charset.defaultCharset().name();
                String csn = charsetName == null ? "ISO-8859-1" : charsetName;
                ByteArrayInputStream bais = new ByteArrayInputStream(b);
                InputStreamReader isr = new InputStreamReader((InputStream)bais, csn);
                BufferedReader in = new BufferedReader(isr);
                ArrayList<Character> clist = new ArrayList<Character>(b.length);
                while ((ch = ((Reader)in).read()) > -1) {
                    clist.add(Character.valueOf((char)ch));
                }
                ((Reader)in).close();
                for (int j = 0; j < b.length; ++j) {
                    b[j] = 32;
                }
                char[] result = new char[clist.size()];
                int i = 0;
                Iterator it = clist.iterator();
                while (it.hasNext()) {
                    result[i++] = ((Character)it.next()).charValue();
                    it.remove();
                }
                return result;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public static String e(byte[] b) {
        StringBuffer result = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            result.append(Util.intToAlpha((b[i] & 0xF0) >> 4));
            result.append(Util.intToAlpha(b[i] & 0xF));
        }
        return result.toString();
    }

    public static byte[] d(String s) {
        int len = s.length();
        byte[] result = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            byte b1 = Util.alphaToInt(s.charAt(i));
            byte b2 = Util.alphaToInt(s.charAt(i + 1));
            result[i / 2] = (byte)(b1 << 4 & 0xF0 | b2 & 0xF);
        }
        return result;
    }

    private static char intToAlpha(int i) {
        assert (i < 16);
        return (char)(i < 10 ? i + 48 : i - 10 + 65);
    }

    private static byte alphaToInt(char c) {
        assert (c >= '0' && c <= '9' || c >= 'A' && c <= 'F');
        return (byte)(c >= 'A' ? c - 65 + 10 : c - 48);
    }

    static {
        _queue = new LinkedList<Worker>();
        _detectThread = null;
        _forceReadTimeout = System.getProperty("oracle.ide.webbrowser.forceReadTimeout", "false");
        charsetName = Charset.defaultCharset().name();
        csn = charsetName == null ? "ISO-8859-1" : charsetName;
    }

    public static interface Worker {
        public void onResult(boolean var1);
    }
}

