/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.ocsp.CertID;

public class SingleRequest
implements ASN1Object {
    private CertID certID;
    private X509ExtensionSet singleReqExts = null;
    private ASN1Sequence req;

    public SingleRequest(X509Certificate cert, X509Certificate caCert) throws NoSuchAlgorithmException, CertificateEncodingException {
        this.certID = new CertID(cert, caCert);
    }

    public SingleRequest(X509Certificate cert, X509Certificate caCert, AlgorithmIdentifier hashAlgID) throws NoSuchAlgorithmException, CertificateEncodingException {
        this.certID = new CertID(cert, caCert, hashAlgID);
    }

    SingleRequest(InputStream is) throws IOException {
        this.input(is);
    }

    public CertID getCertID() {
        return this.certID;
    }

    public void addSingleReqExtension(X509Extension ext) {
        if (this.singleReqExts == null) {
            this.singleReqExts = new X509ExtensionSet();
        }
        this.singleReqExts.addExtension(ext);
        this.reset();
    }

    public void setSingleReqExtensions(X509ExtensionSet extensionSet) {
        this.singleReqExts = extensionSet;
    }

    public X509Extension getSingleReqExtension(ASN1ObjectID type) {
        if (this.singleReqExts != null) {
            return this.singleReqExts.getExtension(type);
        }
        return null;
    }

    public X509ExtensionSet getSingleReqExtensions() {
        return this.singleReqExts;
    }

    public void input(InputStream is) throws IOException {
        this.reset();
        try {
            ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
            this.certID = new CertID((InputStream)seq);
            if (seq.hasMoreData()) {
                ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream((InputStream)seq, 0);
                this.singleReqExts = new X509ExtensionSet((InputStream)cis);
                cis.terminate();
            }
            seq.terminate();
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.req != null) {
            return this.req;
        }
        this.req = new ASN1Sequence();
        this.req.addElement((ASN1Object)this.certID);
        if (this.singleReqExts != null) {
            this.req.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.singleReqExts, 0));
        }
        return this.req;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void reset() {
        this.req = null;
    }

    public String toString() {
        return "Single request: certID = " + this.certID + "; singleRequestExtensions = " + this.singleReqExts;
    }
}

