/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.ocsp.ResponseInfo;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class OCSPResponse
implements ASN1Object {
    private RespStatus respStatus;
    private ResponseInfo responseInfo = null;
    private ASN1Sequence contents;

    public OCSPResponse() {
    }

    public OCSPResponse(RespStatus respStatus) {
        this.respStatus = respStatus;
    }

    public OCSPResponse(RespStatus respStatus, ResponseInfo responseInfo) {
        this.respStatus = respStatus;
        this.responseInfo = responseInfo;
    }

    public OCSPResponse(InputStream is) throws IOException {
        this.input(is);
    }

    public RespStatus getRespStatus() {
        return this.respStatus;
    }

    void setRespStatus(RespStatus respStatus) {
        this.respStatus = respStatus;
    }

    void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public ASN1ObjectID getResponseType() {
        return this.responseInfo != null ? this.responseInfo.getResponseType() : null;
    }

    public void input(InputStream is) throws IOException {
        this.reset();
        try {
            ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
            ASN1GenericPrimitive statusPrim = new ASN1GenericPrimitive((InputStream)seq);
            ASN1Integer statusInt = (ASN1Integer)statusPrim.withTag(2);
            int status = statusInt.intValue();
            if (status == RespStatus.SUCCESSFUL.getValue()) {
                this.respStatus = RespStatus.SUCCESSFUL;
            } else if (status == RespStatus.MALFORMED_REQUEST.getValue()) {
                this.respStatus = RespStatus.MALFORMED_REQUEST;
            } else if (status == RespStatus.INTERNAL_ERROR.getValue()) {
                this.respStatus = RespStatus.INTERNAL_ERROR;
            } else if (status == RespStatus.TRY_LATER.getValue()) {
                this.respStatus = RespStatus.TRY_LATER;
            } else if (status == RespStatus.SIG_REQUIRED.getValue()) {
                this.respStatus = RespStatus.SIG_REQUIRED;
            } else if (status == RespStatus.UNAUTHORIZED.getValue()) {
                this.respStatus = RespStatus.UNAUTHORIZED;
            } else {
                throw new ASN1FormatException("Unrecognized response status code");
            }
            if (seq.hasMoreData()) {
                ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream((InputStream)seq, 0);
                ASN1SequenceInputStream seqRespBytes = new ASN1SequenceInputStream((InputStream)cis);
                ASN1ObjectID respType = new ASN1ObjectID((InputStream)seqRespBytes);
                this.responseInfo = ResponseInfo.inputInstance(respType, new ByteArrayInputStream(ASN1OctetString.inputValue((InputStream)seqRespBytes)));
                seqRespBytes.terminate();
                cis.terminate();
            } else {
                this.responseInfo = null;
            }
            seq.terminate();
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence rsp = new ASN1Sequence();
        rsp.addElement((ASN1Object)new ASN1GenericPrimitive((ASN1Object)new ASN1Integer((long)this.respStatus.getValue()), 10, 0));
        if (this.responseInfo != null && this.respStatus.getValue() == RespStatus.SUCCESSFUL.getValue()) {
            ASN1Sequence respBytes = new ASN1Sequence();
            respBytes.addElement((ASN1Object)this.responseInfo.getResponseType());
            respBytes.addElement((ASN1Object)new ASN1OctetString(Utils.toBytes((Streamable)this.responseInfo)));
            rsp.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)respBytes, 0));
        }
        this.contents = rsp;
        return this.contents;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void reset() {
        this.contents = null;
    }

    public String toString() {
        return "OCSP response: response statuc = " + this.respStatus + (this.responseInfo != null ? "; responseInfo = " + this.responseInfo : "");
    }

    public static class RespStatus {
        public static final RespStatus SUCCESSFUL = new RespStatus(0);
        public static final RespStatus MALFORMED_REQUEST = new RespStatus(1);
        public static final RespStatus INTERNAL_ERROR = new RespStatus(2);
        public static final RespStatus TRY_LATER = new RespStatus(3);
        public static final RespStatus SIG_REQUIRED = new RespStatus(5);
        public static final RespStatus UNAUTHORIZED = new RespStatus(6);
        private int value;

        private RespStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            if (this.value == SUCCESSFUL.getValue()) {
                return "SUCCESSFUL";
            }
            if (this.value == MALFORMED_REQUEST.getValue()) {
                return "MALFORMED REQUEST";
            }
            if (this.value == INTERNAL_ERROR.getValue()) {
                return "INTERNAL ERROR";
            }
            if (this.value == TRY_LATER.getValue()) {
                return "TRY LATER";
            }
            if (this.value == SIG_REQUIRED.getValue()) {
                return "SIG REQUIRED";
            }
            if (this.value == UNAUTHORIZED.getValue()) {
                return "UNAUTHORIZED";
            }
            return null;
        }
    }
}

