/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.IOException;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.URLConnection;
import oracle.security.crypto.ocsp.OCSPResponse;

public class OCSPContentHandlerFactory
implements ContentHandlerFactory {
    @Override
    public ContentHandler createContentHandler(String mimetype) {
        return mimetype.equals("application/ocsp-response") ? new OCSPResponseContentHandler() : null;
    }

    static class OCSPResponseContentHandler
    extends ContentHandler {
        OCSPResponseContentHandler() {
        }

        @Override
        public Object getContent(URLConnection urlc) throws IOException {
            return new OCSPResponse(urlc.getInputStream());
        }
    }
}

