/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.ocsp.OCSPUtils;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class CertID
implements ASN1Object {
    private AlgorithmIdentifier hashAlgID;
    private byte[] nameHash;
    private byte[] keyHash;
    private BigInteger serialNo;
    private ASN1Sequence cid;

    public CertID(X509Certificate cert, X509Certificate caCert) throws NoSuchAlgorithmException, CertificateEncodingException {
        this(cert, caCert, AlgID.sha_1);
    }

    public CertID(X509Certificate cert, X509Certificate caCert, AlgorithmIdentifier hashAlgID) throws NoSuchAlgorithmException, CertificateEncodingException {
        this.hashAlgID = hashAlgID;
        MessageDigest md = MessageDigest.getInstance(OCSPUtils.getAlgoName(hashAlgID));
        this.nameHash = md.digest(cert.getIssuerX500Principal().getEncoded());
        PublicKey publicKey = caCert.getPublicKey();
        oracle.security.crypto.core.PublicKey osdtPublicKey = CryptoUtils.fromJCEPublicKey((PublicKey)publicKey);
        byte[] publicKeyEncoded = Utils.toBytes((Streamable)osdtPublicKey.getContents());
        MessageDigest md1 = MessageDigest.getInstance(OCSPUtils.getAlgoName(hashAlgID));
        this.keyHash = md1.digest(publicKeyEncoded);
        this.serialNo = cert.getSerialNumber();
    }

    public CertID(InputStream is) throws IOException {
        this.input(is);
    }

    public AlgorithmIdentifier getHashAlgID() {
        return this.hashAlgID;
    }

    public byte[] getIssuerNameHash() {
        return this.nameHash;
    }

    public byte[] getIssuerKeyHash() {
        return this.keyHash;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public boolean compareTo(X509Certificate cert, X509Certificate caCert) throws NoSuchAlgorithmException, CertificateEncodingException {
        return this.compareTo(cert, caCert, AlgID.sha_1);
    }

    public boolean compareTo(X509Certificate cert, X509Certificate caCert, AlgorithmIdentifier hashAlgID) throws NoSuchAlgorithmException, CertificateEncodingException {
        CertID certID = new CertID(cert, caCert, hashAlgID);
        return this.equals(certID);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CertID)) {
            return false;
        }
        CertID certID = (CertID)o;
        if (!this.getHashAlgID().equals((Object)certID.getHashAlgID())) {
            return false;
        }
        if (!Utils.areEqual((byte[])this.getIssuerNameHash(), (byte[])certID.getIssuerNameHash())) {
            return false;
        }
        if (!Utils.areEqual((byte[])this.getIssuerKeyHash(), (byte[])certID.getIssuerKeyHash())) {
            return false;
        }
        return this.getSerialNo().equals(certID.getSerialNo());
    }

    public int hashCode() {
        return this.hashAlgID.hashCode() ^ new String(this.nameHash).hashCode() ^ new String(this.keyHash).hashCode() ^ this.serialNo.hashCode();
    }

    public void input(InputStream is) throws IOException {
        try {
            this.reset();
            ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
            this.hashAlgID = new AlgorithmIdentifier((InputStream)seq);
            this.nameHash = ASN1OctetString.inputValue((InputStream)seq);
            this.keyHash = ASN1OctetString.inputValue((InputStream)seq);
            this.serialNo = ASN1Integer.inputValue((InputStream)seq);
            seq.terminate();
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.cid != null) {
            return this.cid;
        }
        this.cid = new ASN1Sequence();
        this.cid.addElement((ASN1Object)this.hashAlgID);
        this.cid.addElement((ASN1Object)new ASN1OctetString(this.nameHash));
        this.cid.addElement((ASN1Object)new ASN1OctetString(this.keyHash));
        this.cid.addElement((ASN1Object)new ASN1Integer(this.serialNo));
        return this.cid;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void reset() {
        this.cid = null;
    }

    public String toString() {
        return "hashAlgID = " + this.hashAlgID + "; nameHash = " + Utils.toHexString((byte[])this.nameHash) + "; keyHash = " + Utils.toHexString((byte[])this.keyHash) + "; serialNo = " + this.serialNo;
    }
}

