/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.ocsp.OCSP;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class CRLReferenceExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = OCSP.id_pkix_ocsp_crl;
    private String crlUrl = null;
    private BigInteger crlNum = null;
    private Date crlTime = null;

    public CRLReferenceExtension() {
        super(TYPE);
    }

    public CRLReferenceExtension(boolean critical) {
        super(TYPE, critical);
        this.setValue(this.toByteArray());
    }

    public CRLReferenceExtension(String crlUrl) {
        super(TYPE);
        this.crlUrl = crlUrl;
        this.setValue(this.toByteArray());
    }

    public CRLReferenceExtension(BigInteger crlNum) {
        super(TYPE);
        this.crlNum = crlNum;
        this.setValue(this.toByteArray());
    }

    public CRLReferenceExtension(Date crlTime) {
        super(TYPE);
        this.crlTime = crlTime;
        this.setValue(this.toByteArray());
    }

    public CRLReferenceExtension(InputStream is) throws IOException {
        super(is);
    }

    public void setCrlUrl(String crlUrl) {
        this.crlUrl = crlUrl;
        this.setValue(this.toByteArray());
    }

    public String getCrlUrl() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.crlUrl;
    }

    public void setCrlNum(BigInteger crlNum) {
        this.crlNum = crlNum;
        this.setValue(this.toByteArray());
    }

    public BigInteger getCrlNum() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.crlNum;
    }

    public void setCrlTime(Date crlTime) {
        this.crlTime = crlTime;
        this.setValue(this.toByteArray());
    }

    public Date getCrlTime() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.crlTime;
    }

    private byte[] toByteArray() {
        ASN1Sequence crlSeq = new ASN1Sequence();
        if (this.crlUrl != null) {
            crlSeq.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1String(this.crlUrl, 22), 0));
        }
        if (this.crlNum != null) {
            crlSeq.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Integer(this.crlNum), 1));
        }
        if (this.crlTime != null) {
            crlSeq.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Date(this.crlTime, true), 2));
        }
        byte[] b = Utils.toBytes((Streamable)crlSeq);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            ASN1ConstructedInputStream cis;
            ByteArrayInputStream is = new ByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream seq = new ASN1SequenceInputStream((InputStream)is);
            if (seq.getCurrentTag() == 0) {
                cis = new ASN1ConstructedInputStream((InputStream)seq, 0);
                this.crlUrl = ASN1String.inputValue((InputStream)cis);
                cis.terminate();
            } else {
                this.crlUrl = null;
            }
            if (seq.getCurrentTag() == 1) {
                cis = new ASN1ConstructedInputStream((InputStream)seq, 1);
                this.crlNum = ASN1Integer.inputValue((InputStream)cis);
                cis.terminate();
            } else {
                this.crlNum = null;
            }
            if (seq.getCurrentTag() == 2) {
                cis = new ASN1ConstructedInputStream((InputStream)seq, 2);
                this.crlTime = ASN1Date.inputValue((InputStream)cis);
                cis.terminate();
            } else {
                this.crlTime = null;
            }
            seq.terminate();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        return "CRL reference extension: " + (this.crlUrl != null ? "crlURL = " + this.crlUrl : "") + (this.crlNum != null ? "crlNum = " + this.crlNum : "") + (this.crlTime != null ? "crlTime = " + this.crlTime : "");
    }
}

