/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.ocsp.OCSP;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class ArchiveCutOffExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = OCSP.id_pkix_ocsp_archive_cutoff;
    private Date archiveCutOff;

    public ArchiveCutOffExtension() {
        super(TYPE);
    }

    public ArchiveCutOffExtension(Date archiveCutOff) {
        this(archiveCutOff, false);
    }

    public ArchiveCutOffExtension(Date archiveCutOff, boolean critical) {
        super(TYPE, critical);
        this.archiveCutOff = archiveCutOff;
        this.setValue(this.toByteArray());
    }

    public ArchiveCutOffExtension(InputStream is) throws IOException {
        super(is);
    }

    public Date getArchiveCutOff() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.archiveCutOff;
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1Date(this.archiveCutOff, true));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            this.archiveCutOff = ASN1Date.inputValue((InputStream)new ByteArrayInputStream(this.getValue()));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        return "archive cut off extension = " + this.archiveCutOff;
    }
}

