/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.worksheet.commands.scriptrunner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptConsumer;
import oracle.olap.worksheet.commands.scriptrunner.OLAPConsumerManager;

public abstract class OLAPDBCommandRunnerProvider
implements ActionProvider<Void> {
    protected List<WorksheetAction> m_actions = new ArrayList<WorksheetAction>();
    protected OLAPConsumerManager m_consumerManager = null;
    WorksheetContext m_worksheetContext = null;

    public OLAPDBCommandRunnerProvider() {
        WorksheetAction worksheetAction = WorksheetAction.createWorksheetAction((String)this.getAction(), (WorksheetAction.ActionType)WorksheetAction.ActionType.BOTH, (int)0, (double)0.0);
        this.addToActions(worksheetAction);
    }

    public WorksheetTaskWrapper<Void> doAction(String string, WorksheetContext worksheetContext) {
        this.m_worksheetContext = worksheetContext;
        if (this.m_consumerManager == null) {
            this.m_consumerManager = new OLAPConsumerManager(this.getAction(), this.getWorksheetContext());
        } else {
            this.m_consumerManager.init(this.getAction(), this.getWorksheetContext());
        }
        WorksheetTaskWrapper worksheetTaskWrapper = null;
        if (this.getAction().equals(string)) {
            DatabaseQueryTask databaseQueryTask = this.getTask(this.getWorksheetContext(), this.getConsumerManager(), string, IRaptorTaskRunMode.TASKVIEWER);
            worksheetTaskWrapper = new WorksheetTaskWrapper((RaptorTask)databaseQueryTask, this.getTaskListeners(), Collections.EMPTY_LIST, this.getTaskViewers(), this.getWorksheetContext());
        }
        return worksheetTaskWrapper;
    }

    protected List<IRaptorTaskListener> getTaskListeners() {
        return Collections.EMPTY_LIST;
    }

    protected List<ITaskViewer> getTaskViewers() {
        return Collections.EMPTY_LIST;
    }

    protected abstract DatabaseQueryTask getTask(WorksheetContext var1, OLAPConsumerManager var2, String var3, IRaptorTaskRunMode var4);

    protected abstract String getAction();

    protected void addToActions(WorksheetAction worksheetAction) {
        this.m_actions.add(worksheetAction);
    }

    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        boolean bl = worksheetContext.isBusy();
        worksheetContext.getEditor().setEditable(!bl);
        boolean bl2 = worksheetContext.getConnectionName() != null;
        boolean bl3 = worksheetContext.getEditor().getDocument().getLength() > 0;
        return bl2 && !bl && bl3;
    }

    public WorksheetAction getActionAt(int n) {
        return this.m_actions.get(n);
    }

    public int getActionsCount() {
        return 1;
    }

    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    public int getPanelCount() {
        return 0;
    }

    protected WorksheetContext getWorksheetContext() {
        return this.m_worksheetContext;
    }

    protected abstract boolean isScriptOutputWindowAlwaysRequired();

    private List<IScriptConsumer> getConsumers() {
        return this.getConsumerManager().getConsumers();
    }

    private OLAPConsumerManager getConsumerManager() {
        return this.m_consumerManager;
    }
}

