/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.olap.OLAPImagesArb;
import oracle.olap.app.db.Column;
import oracle.olap.app.db.DatabaseObject;
import oracle.olap.app.tree.view.CheckTreeManager;
import oracle.olap.app.tree.view.JTree2;
import oracle.olap.app.tree.view.NodeIcon;
import oracle.olap.db.view.ColumnNode;
import oracle.olap.db.view.SynonymNode;
import oracle.olap.db.view.TableNode;
import oracle.olap.db.view.ViewNode;
import oracle.olap.util.TableDisplay;

public class SourceObjectTree
extends JTree2 {
    private CheckTreeManager checkTreeManager;
    private List<TableDisplay> tableDisplay = new ArrayList<TableDisplay>();

    public SourceObjectTree() {
        this.tableDisplay.add(TableDisplay.COLUMNS);
        this.initUI();
    }

    public SourceObjectTree(TreeNode treeNode) {
        super(treeNode);
        this.tableDisplay.add(TableDisplay.COLUMNS);
        this.initUI();
    }

    public void remove(TableDisplay tableDisplay) {
        this.tableDisplay.remove((Object)tableDisplay);
    }

    public void setSelectedAll(boolean bl) {
        this.checkTreeManager.setSelectedAll(bl);
    }

    public void setSelected(Object object, boolean bl) {
        TreeNode treeNode = this.findNodeForObject(object);
        if (treeNode != null) {
            TreePath treePath = SourceObjectTree.getPath(treeNode);
            this.checkTreeManager.setSelected(treePath, bl);
        }
    }

    private TreeNode findNodeForObject(Object object) {
        Object object2 = this.getModel().getRoot();
        if (object2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
            return this.findNodeForObject(defaultMutableTreeNode, object);
        }
        return null;
    }

    private DefaultMutableTreeNode findNodeForObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 != null && object2.equals(object)) {
            return defaultMutableTreeNode;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            DefaultMutableTreeNode defaultMutableTreeNode3;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode) || (defaultMutableTreeNode3 = this.findNodeForObject(defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode, object)) == null) continue;
            return defaultMutableTreeNode3;
        }
        return null;
    }

    public boolean isSelected(Object object) {
        Object object2 = this.getModel().getRoot();
        if (object2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
            boolean bl = this.isNodeSelected(defaultMutableTreeNode, object);
            return bl;
        }
        return false;
    }

    private boolean isNodeSelected(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 != null && object2.equals(object)) {
            TreePath treePath = SourceObjectTree.getPath(defaultMutableTreeNode);
            boolean bl = true;
            boolean bl2 = this.checkTreeManager.getSelectionModel().isPathSelected(treePath, bl);
            return bl2;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode) || !this.isNodeSelected(defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode, object)) continue;
            return true;
        }
        return false;
    }

    public boolean isFullySelected() {
        Object object = this.getModel().getRoot();
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            boolean bl = this.isNodeFullySelected(defaultMutableTreeNode);
            return bl;
        }
        return true;
    }

    private boolean isNodeFullySelected(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreePath treePath = SourceObjectTree.getPath(defaultMutableTreeNode);
        boolean bl = true;
        boolean bl2 = this.checkTreeManager.getSelectionModel().isPathSelected(treePath, bl);
        if (!bl2) {
            return false;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
            if (!(treeNode instanceof DefaultMutableTreeNode) || this.isNodeFullySelected(defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode)) continue;
            return false;
        }
        return true;
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode, List<Column> list) {
        defaultMutableTreeNode.setAllowsChildren(true);
        DatabaseObject databaseObject = (DatabaseObject)defaultMutableTreeNode.getUserObject();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Column object : databaseObject.getColumns()) {
            for (Column column : list) {
                if (!object.getName().equalsIgnoreCase(column.getName())) continue;
                arrayList.add(column.toString());
            }
        }
        databaseObject.setColumns(list);
        this.addNode(defaultMutableTreeNode, false);
        if (arrayList.size() > 0) {
            this.checkTreeManager.setSelected(SourceObjectTree.getPath(defaultMutableTreeNode), false);
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                String string = defaultMutableTreeNode2.getUserObject().toString();
                for (String string2 : arrayList) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    this.checkTreeManager.setSelected(SourceObjectTree.getPath(defaultMutableTreeNode2), true);
                }
            }
        }
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.addNode(defaultMutableTreeNode, true);
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        defaultMutableTreeNode.setAllowsChildren(true);
        if (!this.isNodeChild(defaultMutableTreeNode)) {
            Object object;
            Object object2;
            Object object3;
            DatabaseObject databaseObject = (DatabaseObject)defaultMutableTreeNode.getUserObject();
            if (this.tableDisplay.contains((Object)TableDisplay.COLUMNS) && (object3 = databaseObject.getColumns()) != null && defaultMutableTreeNode.getChildCount() < 1) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Column)object2.next();
                    ColumnNode columnNode = new ColumnNode((Column)object);
                    defaultMutableTreeNode.add(columnNode);
                }
            }
            if ((object3 = this.getModel()) instanceof DefaultTreeModel) {
                object2 = (DefaultTreeModel)object3;
                object = ((DefaultTreeModel)object2).getRoot() == null ? new DefaultMutableTreeNode("root") : (DefaultMutableTreeNode)((DefaultTreeModel)object2).getRoot();
                ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode);
                ((DefaultTreeModel)object2).setRoot((TreeNode)object);
                if (bl) {
                    this.checkTreeManager.setSelected(SourceObjectTree.getPath(defaultMutableTreeNode), true);
                }
            }
        }
    }

    private boolean isNodeChild(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.treeModel instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.treeModel;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
            if (defaultMutableTreeNode2 != null) {
                for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
                    if (!defaultMutableTreeNode2.getChildAt(i).equals(defaultMutableTreeNode)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public List<DatabaseObject> getList() {
        ArrayList<DatabaseObject> arrayList = new ArrayList<DatabaseObject>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        this.visitAllNodes(defaultMutableTreeNode, arrayList);
        return arrayList;
    }

    private void visitAllNodes(DefaultMutableTreeNode defaultMutableTreeNode, List<DatabaseObject> list) {
        if (defaultMutableTreeNode.getChildCount() > 0) {
            Serializable serializable;
            Enumeration<TreeNode> enumeration;
            if (defaultMutableTreeNode.getParent() != null && (enumeration = defaultMutableTreeNode.getUserObject()) != null) {
                serializable = SourceObjectTree.getPath(defaultMutableTreeNode);
                boolean bl = true;
                boolean bl2 = this.checkTreeManager.getSelectionModel().isPathSelected((TreePath)serializable, bl);
                if (bl2) {
                    DatabaseObject databaseObject = (DatabaseObject)((Object)enumeration);
                    list.add(databaseObject);
                } else {
                    boolean bl3 = this.checkTreeManager.getSelectionModel().isPartiallySelected((TreePath)serializable);
                    if (bl3) {
                        ArrayList<Column> arrayList = new ArrayList<Column>();
                        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                            DefaultMutableTreeNode defaultMutableTreeNode2;
                            Object object;
                            TreeNode treeNode = defaultMutableTreeNode.getChildAt(i);
                            if (!(treeNode instanceof DefaultMutableTreeNode) || (object = (defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNode).getUserObject()) == null) continue;
                            TreePath treePath = SourceObjectTree.getPath(treeNode);
                            boolean bl4 = true;
                            boolean bl5 = this.checkTreeManager.getSelectionModel().isPathSelected(treePath, bl4);
                            if (!bl5) continue;
                            arrayList.add((Column)object);
                        }
                        DatabaseObject databaseObject = (DatabaseObject)((Object)enumeration);
                        databaseObject.setColumns(arrayList);
                        list.add(databaseObject);
                    }
                }
            }
            enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                serializable = (DefaultMutableTreeNode)enumeration.nextElement();
                this.visitAllNodes((DefaultMutableTreeNode)serializable, list);
            }
        }
    }

    private void initUI() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        NodeIcon nodeIcon = new NodeIcon(){

            @Override
            public Icon getIcon(Object object) {
                if (object instanceof TableNode) {
                    return OLAPImagesArb.getIcon("TABLE_ICON");
                }
                if (object instanceof ViewNode) {
                    return OLAPImagesArb.getIcon("VIEW_ICON");
                }
                if (object instanceof SynonymNode) {
                    return OLAPImagesArb.getIcon("SYNONYM_ICON");
                }
                if (object instanceof ColumnNode) {
                    return OLAPImagesArb.getIcon("COLUMN_ICON");
                }
                return null;
            }

            @Override
            public Icon getDisabledIcon(Object object) {
                if (object instanceof TableNode) {
                    return OLAPImagesArb.getIcon("TABLE_ICON");
                }
                if (object instanceof ViewNode) {
                    return OLAPImagesArb.getIcon("VIEW_ICON");
                }
                if (object instanceof SynonymNode) {
                    return OLAPImagesArb.getIcon("SYNONYM_ICON");
                }
                if (object instanceof ColumnNode) {
                    return OLAPImagesArb.getIcon("COLUMN_ICON");
                }
                return null;
            }
        };
        this.checkTreeManager = new CheckTreeManager(this, nodeIcon);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.checkTreeManager != null) {
            this.checkTreeManager.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.checkTreeManager != null) {
            this.checkTreeManager.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

