/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.timegen.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;
import oracle.olap.OLAPArb;
import oracle.olap.timegen.ui.wizard.TimeGenLevelModel;
import oracle.olap.timegen.ui.wizard.TimeGenTableCheckBoxCellRenderer;
import oracle.olap.timegen.ui.wizard.TimeGenWizardPanel;

public class TimeGenLevelsPanel
extends TimeGenWizardPanel {
    private TimeGenLevelModel timeGenLevelModel = new TimeGenLevelModel();
    private GenericTable levelsTable;
    private boolean isCreateTimeDimAndHierarchy;
    private MyCellEditor myCellEditor;
    private DBObjectProvider prov;

    public TimeGenLevelsPanel() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText(OLAPArb.get("TIME_GEN_WIZARD_LEVELS_STEP_INSTRUCTION"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)multiLineLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 9;
        JPanel jPanel = this.getLevelsPanel();
        this.add(jPanel, gridBagConstraints);
    }

    private JPanel getLevelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setName("levelsPanel");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ++gridBagConstraints.gridy;
        this.levelsTable = new GenericTable((TableModel)((Object)this.timeGenLevelModel));
        this.levelsTable.setName("levelsTable");
        this.myCellEditor = new MyCellEditor();
        TableColumnModel tableColumnModel = this.levelsTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(this.timeGenLevelModel.LEVEL_NAME_COLUMN);
        tableColumn.setCellEditor(this.myCellEditor);
        TableColumn tableColumn2 = tableColumnModel.getColumn(this.timeGenLevelModel.SHARED_COLUMN);
        tableColumn2.setCellRenderer(new TimeGenTableCheckBoxCellRenderer());
        this.timeGenLevelModel.setTable((JTable)this.levelsTable);
        this.timeGenLevelModel.setEditable(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.levelsTable);
        jScrollPane.setName("tablePane");
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    @Override
    public void initializeData(TraversableContext traversableContext) {
        this.prov = (DBObjectProvider)traversableContext.get("DBOBJECTPROVIDER");
        List list = (List)traversableContext.get("LEVELS");
        this.isCreateTimeDimAndHierarchy = (Boolean)traversableContext.get("SHOW_CREATE_DIMENSION_UI");
        Boolean bl = (Boolean)traversableContext.get("CREATE_DIMENSION");
        this.timeGenLevelModel.setIsCreateHierarchy(bl);
        this.timeGenLevelModel.setRowList(list);
        TableColumn tableColumn = this.levelsTable.getColumnModel().getColumn(this.timeGenLevelModel.SHARED_COLUMN);
        if (!this.isCreateTimeDimAndHierarchy) {
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
        }
    }

    @Override
    public void setContext(TraversableContext traversableContext) {
        List list = this.timeGenLevelModel.getRowList();
        traversableContext.put("LEVELS", (Object)list);
    }

    public void onEntry(TraversableContext traversableContext) {
        this.initializeData(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.validateFields(traversableContext);
        this.setContext(traversableContext);
    }

    public Object getExitTransition() {
        return "ATTRIBUTES";
    }

    @Override
    public void validateFields(TraversableContext traversableContext) {
    }

    class MyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JTextField cellTextField = new JTextField();
        protected int row;
        protected int column;
        protected KeyAdapter ka = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (MyCellEditor.this.column == TimeGenLevelsPanel.this.timeGenLevelModel.LEVEL_NAME_COLUMN && (keyEvent.getKeyChar() == ' ' || keyEvent.getKeyChar() == '.' || keyEvent.getKeyChar() == '\"')) {
                    Toolkit.getDefaultToolkit().beep();
                    keyEvent.consume();
                    return;
                }
                if (keyEvent.getKeyChar() == '\u001b') {
                    return;
                }
            }
        };
        protected DocumentListener dl = new DocumentListener(){

            public void common() {
                if (MyCellEditor.this.column != TimeGenLevelsPanel.this.timeGenLevelModel.LEVEL_NAME_COLUMN) {
                    return;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.common();
            }
        };

        public MyCellEditor() {
            this.cellTextField.addKeyListener(this.ka);
            this.cellTextField.getDocument().addDocumentListener(this.dl);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            String string = (String)object;
            this.cellTextField.setText(string.toUpperCase());
            return this.cellTextField;
        }

        @Override
        public Object getCellEditorValue() {
            String string = this.cellTextField.getText();
            return string;
        }

        @Override
        public boolean stopCellEditing() {
            int n = TimeGenLevelsPanel.this.timeGenLevelModel.LEVEL_NAME_COLUMN;
            if (this.column == n) {
                boolean bl = true;
                String string = null;
                String string2 = (String)TimeGenLevelsPanel.this.timeGenLevelModel.getValueAt(this.row, this.column);
                String string3 = this.cellTextField.getText().toUpperCase();
                if (string3 == null || string3.length() == 0) {
                    bl = false;
                    string = OLAPArb.getString("TIME_GEN_WIZARD_LEVELS_STEP_LVL_ERROR_NAME_MISSING");
                } else {
                    try {
                        TimeGenLevelsPanel.this.prov.validateName("LEVEL", string3);
                    }
                    catch (InvalidNameException invalidNameException) {
                        string = invalidNameException.getMessage();
                        bl = false;
                    }
                }
                if (bl) {
                    String string4 = TimeGenLevelsPanel.this.prov.getInternalName(string3);
                    boolean bl2 = false;
                    int n2 = TimeGenLevelsPanel.this.timeGenLevelModel.getRowCount();
                    for (int i = 0; i < n2; ++i) {
                        String string5 = (String)TimeGenLevelsPanel.this.timeGenLevelModel.getValueAt(i, this.column);
                        if (!string5.equalsIgnoreCase(string4) || i == this.row) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        string = OLAPArb.format("TIME_GEN_WIZARD_LEVELS_STEP_LVL_ERROR_DUPLICATE_NAME", string4);
                        bl = false;
                    }
                }
                if (!bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)OLAPArb.get("TIME_GEN_ERROR_DLG_TITLE"), null);
                    this.cellTextField.setText(string2);
                    return bl;
                }
                this.cellTextField.setText(string3);
            }
            return super.stopCellEditing();
        }
    }
}

