/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.spec;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.syntaxbuilder.spec.Category;
import oracle.olap.syntaxbuilder.spec.Doc;
import oracle.olap.syntaxbuilder.spec.File;
import oracle.olap.syntaxbuilder.spec.Insertable;
import oracle.olap.syntaxbuilder.spec.NodeWithContext;
import oracle.olap.syntaxbuilder.spec.Sql;
import oracle.olap.syntaxbuilder.spec.Unseen;
import oracle.olap.syntaxbuilder.spec.XmlProperty;

public abstract class BaseSpecNode
extends NodeWithContext {
    protected List<Unseen> unseen;
    protected List<File> files;
    protected List<XmlProperty> xmlProperties;
    protected List<Doc> docs;
    protected List<Category> categories;
    protected List<Sql> sqls;
    protected List<Insertable> insertables;
    private String fileName;

    public void addFile(File file) {
        if (this.files == null) {
            this.files = new ArrayList<File>();
        }
        this.files.add(file);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void addCategory(Category category) {
        if (this.categories == null) {
            this.categories = new ArrayList<Category>();
        }
        this.categories.add(category);
    }

    public void addDoc(Doc doc) {
        if (this.docs == null) {
            this.docs = new ArrayList<Doc>();
        }
        this.docs.add(doc);
    }

    public void addSql(Sql sql) {
        if (this.sqls == null) {
            this.sqls = new ArrayList<Sql>();
        }
        this.sqls.add(sql);
    }

    public List<File> getFiles() {
        return this.files;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public List<Doc> getDocs() {
        return this.docs;
    }

    public List<Sql> getSqls() {
        return this.sqls;
    }

    public void addXmlProperty(XmlProperty xmlProperty) {
        if (this.xmlProperties == null) {
            this.xmlProperties = new ArrayList<XmlProperty>();
        }
        this.xmlProperties.add(xmlProperty);
    }

    public List<XmlProperty> getXmlProperties() {
        return this.xmlProperties;
    }

    public void addUnseen(Unseen unseen) {
        if (this.unseen == null) {
            this.unseen = new ArrayList<Unseen>();
        }
        this.unseen.add(unseen);
    }

    public List<Unseen> getUnseen() {
        return this.unseen;
    }

    public void addInsertable(Insertable insertable) {
        if (this.insertables == null) {
            this.insertables = new ArrayList<Insertable>();
        }
        this.insertables.add(insertable);
    }

    public List<Insertable> getInsertables() {
        return this.insertables;
    }

    @Override
    protected void addChildren(StringBuilder stringBuilder) {
        this.addChildren(stringBuilder, this.unseen);
        this.addChildren(stringBuilder, this.files);
        this.addChildren(stringBuilder, this.xmlProperties);
        this.addChildren(stringBuilder, this.docs);
        this.addChildren(stringBuilder, this.categories);
        this.addChildren(stringBuilder, this.sqls);
        this.addChildren(stringBuilder, this.insertables);
    }

    protected final void addChildren(StringBuilder stringBuilder, List<? extends NodeWithContext> list) {
        if (list != null) {
            for (NodeWithContext nodeWithContext : list) {
                nodeWithContext.toXml(stringBuilder);
            }
        }
    }
}

