/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.details;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.icons.OracleIcons;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.Database;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;
import oracle.olap.syntaxbuilder.details.CalculatedMeasureTablePanel;
import oracle.olap.syntaxbuilder.details.CalculatedMeasureTableRefreshAction;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxBuilderLauncher;

public abstract class AbstractCalculatedMeasureTable
extends Editor {
    private Node node;
    private URL url;
    private Database database;
    private OLAPISyntaxParser parser;
    private String cubeName;
    private String measureName;
    private String connectionName;
    private String schemaName;
    private CalculatedMeasureTablePanel calculatedMeasureTable = null;
    private Toolbar toolbar;

    public void open() {
        this.init();
        this.calculatedMeasureTable = this.getCalculatedMeasureTable();
        IdeAction ideAction = IdeAction.findOrCreate((int)CalculatedMeasureTableRefreshAction.REFRESH_CALCULATED_MEASURE_TABLE, null, (String)OLAPArb.getString("EXPRESSION_EDITOR_REFRESH_METADATA"), null, null, null, null, (boolean)true).newLocalAction((View)this);
        ideAction.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"refresh.png"));
        ideAction.addController((Controller)new CalculatedMeasureTableRefreshAction(this));
        Toolbar toolbar = this.getFixedTopMargin();
        if (toolbar.getComponentCount() == 0) {
            toolbar.add((ToggleAction)ideAction);
        }
    }

    public Toolbar getFixedTopMargin() {
        if (this.toolbar == null) {
            this.toolbar = new Toolbar();
        }
        return this.toolbar;
    }

    public Component getGUI() {
        return this.calculatedMeasureTable;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    protected void init() {
        this.node = this.getContext().getNode();
        this.url = this.node.getURL();
        this.connectionName = DBURLFormatHelper.getConnectionName((URL)this.url);
        this.schemaName = DBURLFormatHelper.getSchema((URL)this.url);
        this.loadCubeAndMeasureName();
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (DBException dBException) {
            dBException.printStackTrace();
        }
        this.database = new DatabaseImpl();
        this.database.setConnection(connection);
        this.initializeOLAPISyntaxParser();
    }

    private void loadCubeAndMeasureName() {
        if (this.node instanceof CalculatedMeasureNode) {
            CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)this.node;
            this.cubeName = calculatedMeasureNode.getCubeName();
            this.measureName = calculatedMeasureNode.getMeasureName();
        }
    }

    private Connection getConnection() throws DBException {
        return Connections.getInstance().getConnection(DBURLFormatHelper.getConnectionName((URL)this.url));
    }

    private void initializeOLAPISyntaxParser() {
        Schema schema = OLAPMetadataCache.getSchema(this.connectionName, this.schemaName);
        this.parser = new OLAPISyntaxParser(schema, new Properties());
    }

    private String getSchemaName() {
        return DBURLFormatHelper.getSchema((URL)this.url);
    }

    protected AnalyticWorkspace loadAW() throws Exception {
        String string = this.findAWName();
        Schema schema = OLAPMetadataCache.getSchema(this.connectionName, this.schemaName);
        AnalyticWorkspace analyticWorkspace = new AnalyticWorkspace(schema.getName(), string);
        for (Cube cube : schema.getCubes()) {
            if (!cube.getAWName().equals(string)) continue;
            analyticWorkspace.addCube(cube);
        }
        return analyticWorkspace;
    }

    private String findAWName() throws Exception {
        String string = "";
        Connection connection = this.getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", this.getSchemaName());
        hashMap.put("name", this.cubeName);
        String string2 = "select aw_name from all_cubes where owner = :owner and cube_name = :name";
        string = dBUtil.executeReturnOneCol(string2, hashMap);
        return string;
    }

    protected abstract CalculatedMeasureTablePanel getCalculatedMeasureTable();

    public void refresh() throws Exception {
        Properties properties = new Properties();
        Schema schema = OLAPMetadataCache.getSchema(this.connectionName, this.schemaName);
        schema.clear();
        SyntaxBuilderLauncher.populateSchema(schema, properties, null, this.database);
        List<Measure> list = this.getMeasuresList();
        this.calculatedMeasureTable.refresh(list);
    }

    protected abstract List<Measure> getMeasuresList() throws Exception;

    protected String getCubeName() {
        return this.cubeName;
    }

    protected String getMeasureName() {
        return this.measureName;
    }

    protected OLAPISyntaxParser getParser() {
        return this.parser;
    }
}

