/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.stringexpr;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.olap.stringexpr.ExprNode;
import oracle.olap.stringexpr.ParamValue;
import oracle.olap.stringexpr.StringExprParser;

public class ASTIdentifier
extends ExprNode {
    private static final Logger LOG = Logger.getLogger(ASTIdentifier.class.getName());
    private String name;

    public ASTIdentifier(int n) {
        super(n);
    }

    public ASTIdentifier(StringExprParser stringExprParser, int n) {
        super(stringExprParser, n);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Object getValue() {
        ParamValue paramValue = StringExprParser.getParamValue();
        String string = this.name;
        if (string.startsWith("{")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string != null) {
            try {
                Object object = paramValue.getValue(string);
                return object;
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
            }
        }
        return string;
    }

    @Override
    public String toString() {
        return "identifier: " + this.name;
    }
}

