/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.navigator.calculatedmeasure;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasureNode;
import oracle.olap.navigator.calculatedmeasure.CalculatedMeasurePinningTracker;

public class CalculatedMeasureBufferPinning
extends NodeListener {
    private Map<Node, ReadTextBuffer> pinnedBuffers = new TreeMap<Node, ReadTextBuffer>();

    public void nodeOpened(NodeEvent nodeEvent) {
        Node node = nodeEvent.getNode();
        TextBuffer textBuffer = ((CalculatedMeasureNode)node).acquireTextBuffer();
        this.pinnedBuffers.put(node, (ReadTextBuffer)textBuffer);
        DBConfig dBConfig = DBConfig.getInstance();
        if (dBConfig.getBoolean("AUTOPINPLSQLEDITORS").booleanValue() && !node.getURL().getFile().contains("anon_block")) {
            CalculatedMeasurePinningTracker.pinNode(node);
        }
    }

    public void nodeClosed(NodeEvent nodeEvent) {
        Node node = nodeEvent.getNode();
        ((CalculatedMeasureNode)node).releaseTextBuffer();
        this.pinnedBuffers.remove(node);
        CalculatedMeasurePinningTracker.unpinNode(node);
    }
}

