/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.measure;

import java.sql.Connection;
import oracle.olap.OLAPResources;
import oracle.olap.app.Resources;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.OLAPMetadataReader;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.tree.model.AbstractTreeTableModel;
import oracle.olap.app.tree.model.TreeTableModel;
import oracle.olap.measure.MeasureSelectorNode;

public class MeasureTreeTableModel
extends AbstractTreeTableModel {
    private Connection m_connection;
    private String m_schema;
    private MeasureSelectorNode rootNode;
    private static Resources resources = new OLAPResources();
    protected static String[] m_columnNames = new String[]{resources.getString("MEASURE_MEASURE_NAME_COLUMN"), resources.getString("MEASURE_DESCRIPTION_COLUMN"), resources.getString("MEASURE_EXPRESSION_COLUMN")};
    protected static final Class[] cTypes = new Class[]{TreeTableModel.class, String.class, String.class};

    public MeasureTreeTableModel(Connection connection, String string) {
        super(new MeasureSelectorNode("ROOT", MeasureSelectorNode.CUBE_FOLDER));
        this.rootNode = (MeasureSelectorNode)this.root;
        this.m_connection = connection;
        this.m_schema = string;
    }

    public void populateTableDataModelAW(String string) throws Exception {
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(this.m_connection);
        Schema schema = new Schema(this.m_schema);
        OLAPMetadataReader oLAPMetadataReader = new OLAPMetadataReader(databaseImpl, schema);
        oLAPMetadataReader.loadAW(string, false);
        AnalyticWorkspace analyticWorkspace = schema.findAW(string);
        for (Cube cube : analyticWorkspace.getCubes()) {
            MeasureSelectorNode measureSelectorNode = this.rootNode.addMeasureNode(cube.getName(), MeasureSelectorNode.CUBE);
            MeasureSelectorNode measureSelectorNode2 = measureSelectorNode.addMeasureNode(resources.getString("MEASURE_PICKER_MEASURES"), MeasureSelectorNode.MEASURE_FOLDER);
            MeasureSelectorNode measureSelectorNode3 = measureSelectorNode.addMeasureNode(resources.getString("MEASURE_PICKER_CALC_MEASURES"), MeasureSelectorNode.DERIVED_FOLDER);
            for (Measure measure : cube.getMeasures()) {
                if (measure.isDerived()) {
                    measureSelectorNode3.addMeasureNode(measure);
                    measureSelectorNode3.addMeasure(measure);
                    continue;
                }
                measureSelectorNode2.addMeasureNode(measure);
                measureSelectorNode2.addMeasure(measure);
            }
        }
    }

    public void populateTableDataModelCube(String string) throws Exception {
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(this.m_connection);
        Schema schema = new Schema(this.m_schema);
        OLAPMetadataReader oLAPMetadataReader = new OLAPMetadataReader(databaseImpl, schema);
        oLAPMetadataReader.loadCube(string);
        Cube cube = schema.findCube(string);
        MeasureSelectorNode measureSelectorNode = this.rootNode;
        MeasureSelectorNode measureSelectorNode2 = measureSelectorNode.addMeasureNode(resources.getString("MEASURE_PICKER_MEASURES"), MeasureSelectorNode.MEASURE_FOLDER);
        MeasureSelectorNode measureSelectorNode3 = measureSelectorNode.addMeasureNode(resources.getString("MEASURE_PICKER_CALC_MEASURES"), MeasureSelectorNode.DERIVED_FOLDER);
        for (Measure measure : cube.getMeasures()) {
            if (measure.isDerived()) {
                measureSelectorNode3.addMeasureNode(measure);
                measureSelectorNode3.addMeasure(measure);
                continue;
            }
            measureSelectorNode2.addMeasureNode(measure);
            measureSelectorNode2.addMeasure(measure);
        }
    }

    @Override
    public int getColumnCount() {
        return m_columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return m_columnNames[n];
    }

    @Override
    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    @Override
    public Object getValueAt(Object object, int n) {
        MeasureSelectorNode measureSelectorNode = (MeasureSelectorNode)object;
        switch (n) {
            case 0: {
                return measureSelectorNode.getName();
            }
            case 1: {
                return measureSelectorNode.getDescription();
            }
            case 2: {
                return measureSelectorNode.getExpression();
            }
        }
        return null;
    }

    protected Object[] getChildren(Object object) {
        MeasureSelectorNode measureSelectorNode = (MeasureSelectorNode)object;
        return measureSelectorNode.getChildren();
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getChildren(object)[n];
    }

    @Override
    public int getChildCount(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray == null ? 0 : objectArray.length;
    }
}

