/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.hierarchyviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.olap.OLAPArb;
import oracle.olap.app.Resources;
import oracle.olap.app.actions.ActionCallback;
import oracle.olap.app.searchbar.SearchOptions;
import oracle.olap.app.templates.templatelist.QDRData;
import oracle.olap.app.tree.loader.TreeLoader;
import oracle.olap.app.tree.model.Node;
import oracle.olap.app.tree.model.VirtualTreeModel;
import oracle.olap.app.tree.view.JTreeV;
import oracle.olap.db.LanguageDBSettings;
import oracle.olap.hierarchyviewer.HierarchyET;
import oracle.olap.hierarchyviewer.HierarchyLoader;
import oracle.olap.util.LanguageSelector;
import oracle.olap.util.LanguageSelectorPanel;
import oracle.olap.util.OLAPFetchIcon;

public class HierarchyViewerDialog
extends JDialog {
    private JTreeV tree;
    private VirtualTreeModel treeModel;
    private JScrollPane sp;
    private TreeLoader treeLoader;
    private boolean nodeMultiSelect;
    private ActionCallback actionCallback;
    private SearchField searchField;
    private JComboBox hierarchySelector;
    private JLabel hierarchyLabel;
    private SearchOptions searchOptions;
    private DialogButtonBar bb;
    private Resources resources;
    private List<Node> searchResults;
    private String previousSearch;
    private int searchIndex;
    private boolean flat;
    private boolean isOKSelected;
    private JButton okButton;
    private JButton closeButton;
    private JButton helpButton;
    private String mode;
    private LanguageSelectorPanel languagePanel;
    private List<HierarchyET> hierarchyETs;
    private String defaultLanguage;
    public static final String VIEW_DIMENSION_MEMBERS_MODE = "VIEW_DIMENSION_MEMBERS_MODE";
    public static final String SELECT_DIMENSION_MEMBERS_MODE = "SELECT_DIMENSION_MEMBERS_MODE";

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, Resources resources, String string3, List<String> list2, QDRData[] qDRDataArray) throws Exception {
        super(window);
        if (list != null && list.size() > 0) {
            this.init(string, list, string2, resources, string3, list2, qDRDataArray);
        }
    }

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, Resources resources) throws Exception {
        this(window, string, list, string2, resources, null, null, null);
    }

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, Resources resources, String string3) throws Exception {
        this(window, string, list, string2, resources, string3, null, null);
    }

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, Resources resources, String string3, QDRData[] qDRDataArray) throws Exception {
        this(window, string, list, string2, resources, string3, null, qDRDataArray);
    }

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, Resources resources, List<String> list2) throws Exception {
        this(window, string, list, string2, resources, null, list2, null);
    }

    private void init(String string, List<HierarchyET> list, String string2, Resources resources, String string3, List<String> list2, QDRData[] qDRDataArray) throws Exception {
        Cloneable cloneable;
        Object object2;
        Object object3;
        if (string3 == null) {
            string3 = VIEW_DIMENSION_MEMBERS_MODE;
        }
        this.hierarchyETs = list;
        this.mode = string3;
        this.setTitle(string);
        this.resources = resources;
        Object object4 = null;
        if (string2 != null) {
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (HierarchyET)object3.next();
                if (!((HierarchyET)object2).getHierarchyName().equalsIgnoreCase(string2)) continue;
                object4 = object2;
            }
        }
        if (object4 == null) {
            object4 = list.get(0);
        }
        if ((object3 = ((HierarchyET)object4).getTreeLoader()) instanceof HierarchyLoader) {
            object2 = (HierarchyLoader)object3;
            ((HierarchyLoader)object2).loadData(qDRDataArray);
        } else {
            ((TreeLoader)object3).loadData();
        }
        this.okButton = new JButton(StringUtils.stripMnemonic((String)resources.getString("DIALOG_OK_BUTTON_TEXT")));
        this.closeButton = new JButton(StringUtils.stripMnemonic((String)resources.getString("DIALOG_CLOSE_BUTTON_TEXT")));
        this.helpButton = new JButton(StringUtils.stripMnemonic((String)resources.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.treeModel = new VirtualTreeModel(((TreeLoader)object3).getTree());
        if (((HierarchyET)object4).getLevelNames() != null) {
            this.treeModel.setNumberOfLevels(((HierarchyET)object4).getLevelNames().size());
        }
        this.tree = new JTreeV(this.treeModel);
        this.tree.setContextProperty("DIALOG", this);
        this.tree.setShowsRootHandles(true);
        if (string3.equalsIgnoreCase(VIEW_DIMENSION_MEMBERS_MODE)) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.tree, "olap_dimension_data_viewer");
        } else {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.tree, "olap_select_dimension_member");
            this.okButton.setEnabled(false);
            this.closeButton = new JButton(StringUtils.stripMnemonic((String)resources.getString("DIALOG_CANCEL_BUTTON_TEXT")));
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    if (treeSelectionEvent.getNewLeadSelectionPath() != null) {
                        HierarchyViewerDialog.this.okButton.setEnabled(true);
                    } else {
                        HierarchyViewerDialog.this.okButton.setEnabled(false);
                    }
                }
            });
            int n = 1;
            cloneable = new DefaultTreeSelectionModel();
            cloneable.setSelectionMode(n);
            this.tree.setSelectionModel((TreeSelectionModel)((Object)cloneable));
        }
        this.searchOptions = new SearchOptions(null);
        OLAPFetchIcon oLAPFetchIcon = new OLAPFetchIcon();
        this.searchField = new SearchField();
        this.searchField.setStyle(SearchField.Style.FIND);
        this.searchResults = new ArrayList<Node>();
        cloneable = new Dimension(300, this.searchField.getMinimumSize().height);
        this.searchField.setMinimumSize((Dimension)cloneable);
        this.searchField.setMaximumSize((Dimension)cloneable);
        this.previousSearch = "";
        this.searchIndex = 0;
        this.hierarchyLabel = new JLabel(OLAPArb.getString("HIERARCHY_VIEWER_DIALOG_HIER"));
        this.hierarchySelector = new JComboBox();
        if (((HierarchyET)object4).getHierarchyName() != null) {
            for (HierarchyET object5 : list) {
                this.hierarchySelector.addItem(object5.getHierarchyName());
            }
            this.hierarchySelector.setSelectedItem(((HierarchyET)object4).getHierarchyName());
            this.hierarchySelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HierarchyViewerDialog.this.loadHierarchyData();
                }
            });
        } else {
            this.flat = true;
            this.treeModel = new VirtualTreeModel(((HierarchyET)object4).getTreeLoader().getTree());
            this.treeModel.setNumberOfLevels(1);
            this.tree.setModel(this.treeModel);
        }
        this.defaultLanguage = LanguageDBSettings.getDefaultLanguage();
        this.languagePanel = new LanguageSelectorPanel(new LanguageSelector(){

            @Override
            public void languageSelectionChanged(String string) {
                try {
                    LanguageDBSettings.setLanguage(string);
                    HierarchyViewerDialog.this.reloadHierarchyData();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.languagePanel.setVisible(false);
        if (list2 != null && !list2.isEmpty()) {
            this.languagePanel.addLanguage(LanguageDBSettings.getDefaultLanguage());
            for (String string4 : list2) {
                this.languagePanel.addLanguage(string4);
            }
            this.languagePanel.setVisible(true);
        }
        this.setSelection(qDRDataArray);
        Iterator<String> iterator = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.findNode(HierarchyViewerDialog.this.searchField.getText(), SearchEvent.Direction.FORWARD);
            }
        };
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.searchField.requestFocus();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.setVisible(false);
                HierarchyViewerDialog.this.dispose();
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.showHelp();
            }
        };
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke("control F"), abstractAction);
        ActionMap actionMap = this.getRootPane().getActionMap();
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("control F"), "findFocus");
        actionMap.put("findFocus", abstractAction);
        inputMap.put(KeyStroke.getKeyStroke("F3"), "find");
        actionMap.put("find", (Action)((Object)iterator));
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        actionMap.put("close", abstractAction2);
        inputMap.put(KeyStroke.getKeyStroke("F1"), "help");
        actionMap.put("help", abstractAction3);
        Icon icon = oLAPFetchIcon.getIcon("MEMBER");
        Icon icon2 = oLAPFetchIcon.getIcon("MEMBER_FOLDER");
        if (icon != null && icon2 != null) {
            this.tree.setFolderIcon(icon2);
            this.tree.setLeafIcon(icon);
        }
        this.layoutComponents();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.isOKSelected = true;
                HierarchyViewerDialog.this.dispose();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.dispose();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.showHelp();
            }
        });
        this.searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                HierarchyViewerDialog.this.findNode(searchEvent.getSearchText(), searchEvent.getDirection());
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this.addWindowListener(new CleanUpTreeOnWindowClosed());
    }

    private void setSelection(QDRData[] qDRDataArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        SearchOptions searchOptions = new SearchOptions(null);
        searchOptions.setOption("MATCH_WHOLE_WORD", true);
        int n = 4;
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(n);
        this.tree.setSelectionModel(defaultTreeSelectionModel);
        if (qDRDataArray != null) {
            for (QDRData qDRData : qDRDataArray) {
                String string = qDRData.getMemberKey();
                this.tree.findNodes("KEY", string, searchOptions, arrayList);
            }
            this.tree.selectNodes(arrayList);
        }
    }

    private void loadHierarchyData() {
        String string = (String)this.hierarchySelector.getSelectedItem();
        HierarchyET hierarchyET = this.findHierarchyByName(string);
        if (hierarchyET != null) {
            if (hierarchyET.getTreeLoader().getFinishedLoadingAtDepth() < 0) {
                try {
                    hierarchyET.getTreeLoader().loadData();
                }
                catch (Exception exception) {
                    return;
                }
            }
            this.treeModel = new VirtualTreeModel(hierarchyET.getTreeLoader().getTree());
            if (hierarchyET.getLevelNames() != null) {
                this.treeModel.setNumberOfLevels(hierarchyET.getLevelNames().size());
            }
            this.tree.setModel(this.treeModel);
        }
    }

    private HierarchyET findHierarchyByName(String string) {
        HierarchyET hierarchyET = null;
        for (HierarchyET hierarchyET2 : this.hierarchyETs) {
            if (!hierarchyET2.getHierarchyName().equalsIgnoreCase(string)) continue;
            hierarchyET = hierarchyET2;
            break;
        }
        return hierarchyET;
    }

    private void reloadHierarchyData() {
        String string = (String)this.hierarchySelector.getSelectedItem();
        HierarchyET hierarchyET = this.findHierarchyByName(string);
        if (hierarchyET != null) {
            try {
                hierarchyET.reload();
                hierarchyET.getTreeLoader().loadData();
            }
            catch (Exception exception) {
                return;
            }
            this.treeModel = new VirtualTreeModel(hierarchyET.getTreeLoader().getTree());
            if (hierarchyET.getLevelNames() != null) {
                this.treeModel.setNumberOfLevels(hierarchyET.getLevelNames().size());
            }
            this.tree.setModel(this.treeModel);
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.searchField, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.languagePanel, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.setBorder(BorderFactory.createCompoundBorder());
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (!this.flat) {
            this.add((Component)this.hierarchyLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
            this.add((Component)this.hierarchySelector, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        }
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree, 30, 20);
        this.add((Component)this.sp, new GridBagConstraints(0, ++n, 2, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.bb = new DialogButtonBar();
        this.bb.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        if (this.mode.equalsIgnoreCase(SELECT_DIMENSION_MEMBERS_MODE)) {
            this.getRootPane().setDefaultButton(this.okButton);
            this.bb.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        }
        this.bb.add((Component)this.closeButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this.add((Component)this.bb, new GridBagConstraints(0, ++n, 2, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setNodeMultiSelect(boolean bl) {
        this.nodeMultiSelect = bl;
        int n = bl ? 4 : 1;
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(n);
        this.tree.setSelectionModel(defaultTreeSelectionModel);
    }

    public void addDialogSaveButton(JButton jButton) {
        this.bb.add((Component)jButton, DialogButtonBar.CONSTRAINT_APPLY);
    }

    public void setActionCallback(ActionCallback actionCallback) {
        this.actionCallback = actionCallback;
    }

    public void showHelp() {
        if (this.actionCallback != null) {
            this.actionCallback.action(this, "HELP");
        } else {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.tree);
        }
    }

    public void cleanup() {
        if (this.treeLoader != null) {
            this.treeLoader.setStopLoadingData(true);
        }
        this.treeLoader = null;
        this.tree = null;
        this.treeModel = null;
        try {
            LanguageDBSettings.setLanguage(this.defaultLanguage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void findNode(String string, SearchEvent.Direction direction) {
        if (string.length() > 0) {
            if (this.searchResults.isEmpty()) {
                this.tree.findNodes("DESC", string, this.searchOptions, this.searchResults);
                if (!this.searchResults.isEmpty()) {
                    this.tree.selectNode(this.searchResults.get(0));
                }
                this.previousSearch = string;
            } else if (this.previousSearch.equals(string)) {
                this.searchIndex = direction.equals((Object)SearchEvent.Direction.FORWARD) ? (this.searchIndex + 1 < this.searchResults.size() ? ++this.searchIndex : 0) : (this.searchIndex - 1 >= 0 ? --this.searchIndex : this.searchResults.size() - 1);
                if (!this.searchResults.isEmpty()) {
                    this.tree.selectNode(this.searchResults.get(this.searchIndex));
                }
            } else {
                this.searchResults.clear();
                this.searchIndex = 0;
                this.tree.findNodes("DESC", string, this.searchOptions, this.searchResults);
                if (!this.searchResults.isEmpty()) {
                    this.tree.selectNode(this.searchResults.get(0));
                }
                this.previousSearch = string;
            }
        }
    }

    public JTreeV getTree() {
        return this.tree;
    }

    public boolean isOKSelected() {
        return this.isOKSelected;
    }

    private class CleanUpTreeOnWindowClosed
    extends WindowAdapter {
        private CleanUpTreeOnWindowClosed() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            HierarchyViewerDialog.this.cleanup();
        }
    }
}

