/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.hierarchyviewer;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import oracle.olap.app.Resources;
import oracle.olap.app.tree.model.HierarchyNodeData;
import oracle.olap.app.tree.model.Node;
import oracle.olap.app.tree.model.Tree;
import oracle.olap.app.tree.model.TreeChange;
import oracle.olap.app.tree.view.JTreeV;
import oracle.olap.hierarchyviewer.HierarchyET;
import oracle.olap.hierarchyviewer.HierarchyPersist;
import oracle.olap.hierarchyviewer.HierarchyViewerDialog;

public class HierarchyEditorDialog
extends HierarchyViewerDialog {
    private HierarchyPersist hierarchyPersist;

    public HierarchyEditorDialog(Window window, String string, List<HierarchyET> list, String string2, HierarchyPersist hierarchyPersist, Resources resources) throws Exception {
        super(window, string, list, string2, resources);
        this.init(hierarchyPersist);
    }

    private void init(HierarchyPersist hierarchyPersist) {
        this.hierarchyPersist = hierarchyPersist;
        JTreeV jTreeV = this.getTree();
        jTreeV.setEditable(true);
        try {
            jTreeV.setActions(this.getClass(), "hierarchyMenu.xml");
            JButton jButton = new JButton("Save");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (HierarchyEditorDialog.this.save()) {
                        HierarchyEditorDialog.this.dispose();
                    }
                }
            });
            this.addDialogSaveButton(jButton);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean save() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.hierarchyPersist.init();
        Tree tree = this.getTree().getDataTree();
        List<TreeChange> list = tree.getChanges();
        for (TreeChange object52 : list) {
            Object exception;
            Node n;
            if (object52.getType() == TreeChange.Type.REMOVE && object52.getNode().getUserObject() instanceof HierarchyNodeData) {
                object4 = (HierarchyNodeData)object52.getNode().getUserObject();
                object3 = ((HierarchyNodeData)object4).getName();
                object2 = object52.getNode().getChildren();
                object = object2.iterator();
                while (object.hasNext()) {
                    n = (Node)object.next();
                    if (!(n.getUserObject() instanceof HierarchyNodeData)) continue;
                    exception = (HierarchyNodeData)n.getUserObject();
                    this.hierarchyPersist.updateMemberParent(((HierarchyNodeData)exception).getName(), null);
                }
                this.hierarchyPersist.removeMember((String)object3);
            }
            if (object52.getType() == TreeChange.Type.REMOVEALL && object52.getNode().getUserObject() instanceof HierarchyNodeData) {
                this.removeAll(object52.getNode());
            }
            if (object52.getType() == TreeChange.Type.NEW && object52.getNode().getUserObject() instanceof HierarchyNodeData) {
                object4 = object52.getNode();
                object3 = (HierarchyNodeData)object4.getUserObject();
                object2 = ((HierarchyNodeData)object3).getName();
                object = tree.getLevelName(object4.getDepth());
                n = object52.getNode().getParent();
                exception = null;
                if (n != null) {
                    HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)n.getUserObject();
                    exception = hierarchyNodeData.getName();
                }
                this.hierarchyPersist.newMember((String)object2, (String)exception, (String)object);
            }
            if (object52.getType() == TreeChange.Type.MOVE && object52.getNode().getUserObject() instanceof HierarchyNodeData) {
                object4 = (HierarchyNodeData)object52.getNode().getUserObject();
                object3 = ((HierarchyNodeData)object4).getName();
                object2 = (HierarchyNodeData)object52.getNode2().getUserObject();
                object = ((HierarchyNodeData)object2).getName();
                this.hierarchyPersist.updateMemberParent((String)object3, (String)object);
            }
            if (object52.getType() == TreeChange.Type.RENAME && object52.getNode().getUserObject() instanceof HierarchyNodeData) {
                object4 = object52.getNode();
                object3 = (HierarchyNodeData)object4.getUserObject();
                object2 = ((HierarchyNodeData)object3).getName();
                object = (String)((HierarchyNodeData)object3).getData(1);
                this.hierarchyPersist.setAttribute((String)object2, "LONG_DESCRIPTION", (String)object);
            }
            if (object52.getType() != TreeChange.Type.SET_PROPERTY || !(object52.getNode().getUserObject() instanceof HierarchyNodeData)) continue;
            object4 = object52.getNode();
            object3 = (HierarchyNodeData)object4.getUserObject();
            object2 = object52.getPropertyName();
        }
        List<String> list2 = this.hierarchyPersist.getCommands();
        StringBuffer stringBuffer = new StringBuffer();
        object4 = list2.iterator();
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            stringBuffer.append((String)object3 + "\n");
        }
        object4 = stringBuffer.toString();
        object3 = "Hierarchy Commands";
        object2 = new JTextArea();
        ((JTextComponent)object2).setEditable(false);
        ((JTextComponent)object2).setText((String)object4);
        object = new JLabel();
        ((JComponent)object2).setBackground(((Component)object).getBackground());
        int n = JOptionPane.showConfirmDialog(this, object2, (String)object3, 0);
        if (n != 0) {
            return false;
        }
        try {
            this.hierarchyPersist.commit();
            return true;
        }
        catch (Exception exception) {
            object3 = "Hierarchy Commit Error";
            object4 = exception.getClass().toString();
            if (exception.getMessage() != null) {
                object4 = exception.getMessage();
            }
            JOptionPane.showMessageDialog(this, object4, (String)object3, 0);
            System.out.println(exception);
            return false;
        }
    }

    private void removeAll(Node node) {
        List<Node> list = node.getChildren();
        for (Node object : list) {
            this.removeAll(object);
        }
        if (node.getUserObject() instanceof HierarchyNodeData) {
            HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)node.getUserObject();
            String string = hierarchyNodeData.getName();
            this.hierarchyPersist.removeMember(string);
        }
    }
}

