/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.eif;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;

public class ExportToEIFDialog
extends JDialog
implements ActionListener {
    private final String OK_COMMAND = "OK_ID";
    private final String CANCEL_COMMAND = "CANCEL_ID";
    private final String HELP_COMMAND = "HELP_ID";
    private String owner;
    private Connection conn;
    private String awName;
    private boolean m_clickedOK = false;
    private JPanel mainPanel;
    private JButton m_btnOK;
    private JButton m_btnCancel;
    private JButton m_btnHelp;
    private JComboBox cboDirs;
    private JTextField fileName;
    private ExportToEIFDialog currentInstance = null;

    public ExportToEIFDialog(Frame frame, Connection connection, String string, String string2) {
        super(frame, OLAPArb.get("EIF_EXPORT_DIALOG_TITLE"), true);
        this.setName("ExportToEIFDialog");
        this.currentInstance = this;
        this.owner = string;
        this.conn = connection;
        this.awName = string2;
        this.initDialog();
        this.initializeFields();
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n;
        int n2;
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() != 101) {
            return;
        }
        int n3 = n2 = this.getWidth();
        int n4 = n = this.getHeight();
        Dimension dimension = this.getMinimumSize();
        n3 = Math.max(dimension.width, n3);
        n4 = Math.max(dimension.height, n4);
        if (n2 != n3 || n != n4) {
            this.setSize(n3, n4);
        }
    }

    private void initDialog() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setName("mainPanel");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "olap_export_to_eif_file");
        this.setLayout(new GridBagLayout());
        this.m_btnOK = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
        this.m_btnOK.setName("m_btnOK");
        this.getRootPane().setDefaultButton(this.m_btnOK);
        this.m_btnOK.setActionCommand("OK_ID");
        this.m_btnOK.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
        this.m_btnOK.addActionListener(this);
        this.m_btnCancel = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.setName("m_btnCancel");
        this.m_btnCancel.setActionCommand("CANCEL_ID");
        this.m_btnCancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.addActionListener(this);
        this.m_btnHelp = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.setName("m_btnHelp");
        this.m_btnHelp.setActionCommand("HELP_ID");
        this.m_btnHelp.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.addActionListener(this);
        JLabel jLabel = new JLabel(OLAPArb.format("EIF_EXPORT_DIALOG_LABEL", this.awName));
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)OLAPArb.get("EIF_EXPORT_DIALOG_LABEL_FILENAME")));
        JLabel jLabel3 = new JLabel(StringUtils.stripMnemonic((String)OLAPArb.get("EIF_EXPORT_DIALOG_LABEL_DIRECTORY")));
        this.cboDirs = new JComboBox();
        this.cboDirs.setName("cboDirs");
        this.cboDirs.setEditable(false);
        this.mainPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        this.mainPanel.add((Component)this.cboDirs, gridBagConstraints);
        this.fileName = new JTextField(1024);
        this.fileName.setName("fileName");
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 4);
        this.fileName.setMinimumSize(new Dimension(250, 20));
        this.mainPanel.add((Component)this.fileName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(10, 4, 0, 4);
        this.mainPanel.add((Component)this.getButtonBar(), gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.registerKeyboardActions();
    }

    private DialogButtonBar getButtonBar() {
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.m_btnHelp, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.m_btnOK, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.m_btnCancel, DialogButtonBar.CONSTRAINT_CANCEL);
        return dialogButtonBar;
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void initializeFields() {
        this.populateDirNames();
    }

    private void populateDirNames() {
        String string = "SELECT d.directory_name directory_name FROM all_directories d ORDER BY directory_name";
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
        List list = dBUtil.executeReturnList(string, null);
        for (Map map : list) {
            this.cboDirs.addItem(map.get("DIRECTORY_NAME"));
        }
    }

    public String getDirectoryName() {
        String string = null;
        string = (String)this.cboDirs.getSelectedItem();
        return string;
    }

    public String getEIFFileName() {
        String string = null;
        string = this.fileName.getText();
        return string;
    }

    public boolean isOKSelected() {
        return this.m_clickedOK;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("OK_ID")) {
            if (this.validateFields()) {
                this.m_clickedOK = true;
                this.currentInstance.setVisible(false);
            }
        } else if (string.equalsIgnoreCase("CANCEL_ID")) {
            this.m_clickedOK = false;
            this.currentInstance.setVisible(false);
        } else if (string.equalsIgnoreCase("HELP_ID")) {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.mainPanel);
        }
    }

    private boolean validateFields() {
        boolean bl = true;
        String string = this.getEIFFileName();
        String string2 = this.getDirectoryName();
        String string3 = null;
        String string4 = OLAPArb.get("EIF_EXPORT_ERROR_TITLE");
        String string5 = null;
        if (string.length() == 0) {
            string3 = OLAPArb.get("EIF_EXPORT_ERROR_MSG_NO_FILENAME");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)string4, string5);
            bl = false;
            return bl;
        }
        if (string2.length() == 0) {
            string3 = OLAPArb.get("EIF_EXPORT_ERROR_NO_DIRECTORY_SUPPLIED");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)string4, string5);
            bl = false;
            return bl;
        }
        return bl;
    }
}

