/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.parser;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.EBNF;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.util.Service;
import oracle.olap.dml.parser.OlapEarley;

public class OlapRules {
    private static final String fname = "serializedRules.xml";
    private static final String path = "/oracle/olap/parser/";
    private static final String GRAMMAR_FILE_NAME = "OLAPDML.grammar";

    public static void main(String[] stringArray) throws Exception {
        OlapRules.memorizeRules();
    }

    private static Set<RuleTuple> extractRules() throws Exception {
        String string = Service.readFile(OlapEarley.class, (String)"xssyntax.syn");
        string = OlapRules.translateGrammar(string);
        System.out.println(string.substring(0, 200));
        System.out.println(".....");
        System.out.println(string.substring(string.length() - 200));
        System.out.println("^^^^^^^^^^^^^^^^");
        List list = LexerToken.parse((String)string);
        ParseNode parseNode = EBNF.parseGrammarFile((List)list, (String)string);
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        EBNF.grammar((ParseNode)parseNode, (List)list, treeSet);
        treeSet.add(new RuleTuple("name", new String[]{"identifier"}));
        treeSet.add(new RuleTuple("name", new String[]{"identifier", "'.'", "identifier"}));
        treeSet.add(new RuleTuple("ident", new String[]{"identifier"}));
        treeSet.add(new RuleTuple("token", new String[]{"identifier"}));
        treeSet.add(new RuleTuple("token", new String[]{"digits"}));
        treeSet.add(new RuleTuple("token", new String[]{"string_literal"}));
        treeSet.add(new RuleTuple("token", new String[]{"'*'"}));
        treeSet.add(new RuleTuple("token", new String[]{"'='"}));
        treeSet.add(new RuleTuple("token", new String[]{"'<'"}));
        treeSet.add(new RuleTuple("token", new String[]{"'>'"}));
        treeSet.add(new RuleTuple("exp", new String[]{"identifier"}));
        treeSet.add(new RuleTuple("exp", new String[]{"digits"}));
        treeSet.add(new RuleTuple("xc", new String[]{"'LISTNAMES'"}));
        treeSet.add(new RuleTuple("xc", new String[]{"'LISTNAMES'", "qonlist"}));
        treeSet.remove(new RuleTuple("xc", new String[]{"modcline"}));
        treeSet.remove(new RuleTuple("xc", new String[]{"qonlistc"}));
        treeSet.remove(new RuleTuple("xc", new String[]{"viewtok"}));
        treeSet.remove(new RuleTuple("xc", new String[]{"ampersub"}));
        treeSet.remove(new RuleTuple("xc", new String[]{"bindvar"}));
        RuleTransforms.eliminateEmptyProductions(treeSet);
        RuleTransforms.substituteSingleUnaryProductions(treeSet);
        RuleTransforms.substituteSingleUnaryProductions(treeSet);
        return treeSet;
    }

    private static void memorizeRules() throws Exception {
        Set<RuleTuple> set = OlapRules.extractRules();
        FileOutputStream fileOutputStream = new FileOutputStream("olap/src/oracle/olap/parser/serializedRules.xml");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(set);
        objectOutputStream.close();
    }

    static Set<RuleTuple> getRules() throws Exception {
        URL uRL = OlapEarley.class.getResource(fname);
        InputStream inputStream = uRL.openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Set set = (Set)objectInputStream.readObject();
        objectInputStream.close();
        OlapRules.removeOLAPDMLRules(set);
        OlapRules.addOLAPDMLRules(set);
        return set;
    }

    private static void addOLAPDMLRules(Set<RuleTuple> set) throws Exception {
        set.add(new RuleTuple("xc", new String[]{"'CMP'", "qon"}));
        set.add(new RuleTuple("xc", new String[]{"'CMP'", "qon", "compileargs"}));
        set.add(new RuleTuple("xc", new String[]{"'CMM'"}));
        set.add(new RuleTuple("xc", new String[]{"'CNS'", "qon"}));
        set.add(new RuleTuple("xc", new String[]{"'DLT'", "qonlist"}));
        set.add(new RuleTuple("xc", new String[]{"'DSC'", "qonlist"}));
        set.add(new RuleTuple("xc", new String[]{"'MNT'", "dimitem", "msargs"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "limop", "exp"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "limop", "exp", "limargs"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "limop", "exp", "'KEEP'", "limargs"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "dimlist", "limop", "exp"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "dimlist", "limop", "exp", "limargs"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "dimlist", "limop", "exp", "'KEEP'", "limargs"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "limop", "exp", "'IFNONE'", "ident"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "limop", "exp", "limargs", "'IFNONE'", "ident"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "limop", "exp", "'KEEP'", "limargs", "'IFNONE'", "ident"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "dimlist", "limop", "exp", "'IFNONE'", "ident"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "dimlist", "limop", "exp", "limargs", "'IFNONE'", "ident"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "'BASEDIMS'", "dimlist", "limop", "exp", "'KEEP'", "limargs", "'IFNONE'", "ident"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "exp", "limop", "limargs"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "exp", "limop", "limargs", "'IFNONE'", "ident"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "exp", "limop", "'COMPLEMENT'"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "exp", "limop", "'COMPLEMENT'", "'IFNONE'", "ident"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "exp", "limop", "'COMPLEMENT'", "limargs"}));
        set.add(new RuleTuple("xc", new String[]{"'LMT'", "exp", "limop", "'COMPLEMENT'", "limargs", "'IFNONE'", "ident"}));
        set.add(new RuleTuple("xc", new String[]{"'RPR'", "qonlist"}));
        set.add(new RuleTuple("xc", new String[]{"'SHW'", "qonlist"}));
        set.add(new RuleTuple("xc", new String[]{"'UPD'"}));
        set.add(new RuleTuple("xc", new String[]{"'UPD'", "updargs"}));
        set.add(new RuleTuple("xc", new String[]{"'ALLSTAT'"}));
        set.add(new RuleTuple("xc", new String[]{"'ALLCOMPILE'"}));
        set.add(new RuleTuple("xc", new String[]{"'ALLCOMPILE'", "exp"}));
        set.add(new RuleTuple("xc", new String[]{"'AWDESCRIBE'"}));
        set.add(new RuleTuple("xc", new String[]{"'COPYDFN'", "qon", "qon"}));
        set.add(new RuleTuple("xc", new String[]{"'FULLDSC'", "qonlist"}));
        set.add(new RuleTuple("xc", new String[]{"'LISTBY'", "qonlist"}));
        set.add(new RuleTuple("xc", new String[]{"'STATUS'", "qonlist"}));
        set.add(new RuleTuple("xc", new String[]{"'STATUS'", "'AW'", "filename"}));
    }

    private static void removeOLAPDMLRules(Set<RuleTuple> set) {
        boolean bl = false;
        bl = set.remove(new RuleTuple("xc", new String[]{"dfn"}));
        bl = set.remove(new RuleTuple("xc", new String[]{"describe"}));
        bl = set.remove(new RuleTuple("xc", new String[]{"mdlset"}));
        bl = set.remove(new RuleTuple("xc", new String[]{"set"}));
        bl = set.remove(new RuleTuple("xc", new String[]{"show"}));
        bl = set.remove(new RuleTuple("xc", new String[]{"commit"}));
        bl = set.remove(new RuleTuple("xc", new String[]{"delete"}));
        bl = set.remove(new RuleTuple("xc", new String[]{"update"}));
    }

    private static void saveOLAPDMLBNFGrammarFile(String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream("src/oracle/olap/parser/OLAPDML.grammar");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        bufferedWriter.write(string);
        bufferedWriter.close();
        outputStreamWriter.close();
        fileOutputStream.close();
    }

    private static String translateGrammar(String string) {
        int n;
        String string2;
        string = string.substring(string.indexOf("<mdlset>:21000"), string.indexOf("} \"End of phrase"));
        while ((string2 = OlapRules.removeComment(string)).length() != string.length()) {
            string = string2;
        }
        string = string.replace("?-1", "");
        string = string.replace("? -1", "");
        string = string.replace("*-1", "");
        for (n = 40; 0 <= n; --n) {
            string = string.replace("*" + n, "");
            string = string.replace("?" + n, "");
        }
        for (n = 30000; 0 <= n; --n) {
            string = string.replace(":" + n, "");
        }
        string = string.replace(": 20051", "");
        string = string.replace(">=", "> :");
        string = string.replace("> =", "> :");
        string = string.replace(">  =", "> :");
        string = string.replace(">   =", "> :");
        string = string.replace(">    =", "> :");
        string = string.replace(">     =", "> :");
        string = string.replace("token>***]", "token>]***");
        string = string.replace("***", "*");
        string = string.replace("-\n", "\n");
        string = string.replace("- \n", "\n");
        string = string.replace("< exp>", "<exp>");
        List list = LexerToken.parse((String)string, (boolean)true);
        StringBuilder stringBuilder = new StringBuilder();
        LexerToken lexerToken = null;
        LexerToken lexerToken2 = null;
        LexerToken lexerToken3 = null;
        for (LexerToken lexerToken4 : list) {
            if (lexerToken != null) {
                if (lexerToken2.type == Token.IDENTIFIER) {
                    if ("<".equals(lexerToken.content) && ">".equals(lexerToken3.content)) {
                        stringBuilder.append(lexerToken2.content);
                        lexerToken3 = new LexerToken((CharSequence)"#!?", -1, -2, Token.AUXILIARY);
                        lexerToken2 = new LexerToken((CharSequence)"#!?", -1, -2, Token.AUXILIARY);
                        lexerToken = new LexerToken((CharSequence)"#!?", -1, -2, Token.AUXILIARY);
                    } else {
                        stringBuilder.append("'" + lexerToken2.content.toUpperCase() + "'");
                    }
                } else if (!(lexerToken2.type == Token.AUXILIARY || "<".equals(lexerToken2.content) && lexerToken3.type == Token.IDENTIFIER && ">".equals(lexerToken4.content))) {
                    stringBuilder.append(lexerToken2.content);
                }
            }
            lexerToken = lexerToken2;
            lexerToken2 = lexerToken3;
            lexerToken3 = lexerToken4;
        }
        string = stringBuilder.toString();
        return string;
    }

    private static String removeComment(String string) {
        int n = string.indexOf(34);
        if (n < 0) {
            return string;
        }
        int n2 = string.indexOf(10, n);
        return string.substring(0, n) + string.substring(n2 + 1);
    }
}

