/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor.folding;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.AbstractCodeFoldingPlugin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.olap.dml.editor.folding.OLAPDMLFoldingModel;
import oracle.olap.dml.editor.folding.TypedFoldingBlock;
import oracle.olap.dml.parser.OLAPDMLBackgroundParser;
import oracle.olap.dml.parser.OLAPDMLLazyNode;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public class OLAPDMLFoldingPlugin
extends AbstractCodeFoldingPlugin
implements CodeFoldingProvider {
    OLAPDMLBackgroundParser parser;

    public OLAPDMLFoldingPlugin(OLAPDMLNode oLAPDMLNode) {
        this.parser = oLAPDMLNode.getParser();
    }

    protected CodeFoldingProvider createProvider() {
        return this;
    }

    public CodeFoldingModel createModel(BasicEditorPane basicEditorPane) {
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        return new OLAPDMLFoldingModel(basicDocument, this.parser);
    }

    public JPopupMenu getPopupMenu() {
        return OLAPDMLFoldingPlugin.generateMenu((OLAPDMLFoldingModel)this.getModel(), this.parser.output);
    }

    public static JPopupMenu generateMenu(final OLAPDMLFoldingModel oLAPDMLFoldingModel, final OLAPDMLLazyNode oLAPDMLLazyNode) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Messages.getString((String)"PlSqlFoldingPlugin.3"), OracleIcons.getIcon((String)"expandall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)oLAPDMLFoldingModel.getRoot();
                for (TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode = typedFoldingBlock2.src;
                    if (parseNode == null || !(parseNode instanceof OLAPDMLLazyNode) || !((OLAPDMLLazyNode)parseNode).isStmt(oLAPDMLLazyNode)) continue;
                    typedFoldingBlock2.setExpanded(true);
                }
                oLAPDMLFoldingModel.reload();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString((String)"PlSqlFoldingPlugin.4"), OracleIcons.getIcon((String)"collapseall.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)oLAPDMLFoldingModel.getRoot();
                for (TypedFoldingBlock typedFoldingBlock2 : typedFoldingBlock.descendants()) {
                    ParseNode parseNode = typedFoldingBlock2.src;
                    if (parseNode == null || !(parseNode instanceof OLAPDMLLazyNode) || !((OLAPDMLLazyNode)parseNode).isStmt(oLAPDMLLazyNode)) continue;
                    typedFoldingBlock2.setExpanded(false);
                }
                oLAPDMLFoldingModel.reload();
            }
        });
        return jPopupMenu;
    }

    public void insertUpdate(CodeFoldingModel codeFoldingModel, int n, int n2) {
    }

    public void removeUpdate(CodeFoldingModel codeFoldingModel, int n, int n2) {
    }
}

