/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor;

import java.util.LinkedList;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.plsql.InfoPanel;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public final class OLAPDMLPinningTracker
implements EditorListener {
    private static LinkedList<Node> pinned = new LinkedList();

    public void editorActivated(Editor editor) {
        Node node;
        Context context = editor.getContext();
        Node node2 = node = context != null ? context.getNode() : null;
        if (node instanceof OLAPDMLNode) {
            // empty if block
        }
    }

    public void editorClosed(Editor editor) {
        Node node;
        Context context = editor.getContext();
        Node node2 = node = context != null ? context.getNode() : null;
        if (node instanceof OLAPDMLNode) {
            pinned.remove(editor);
        }
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorOpened(Editor editor) {
        Node node;
        Context context = editor.getContext();
        Node node2 = node = context != null ? context.getNode() : null;
        if (node instanceof OLAPDMLNode && (editor instanceof InfoPanel || editor instanceof CodeEditor)) {
            OLAPDMLPinningTracker.closeUnpinnedEditors(editor);
        }
    }

    private static void closeUnpinnedEditors(Editor editor) {
        DBConfig dBConfig = DBConfig.getInstance();
        int n = dBConfig.getInt("MAXOPENPLSQLEDITORS");
        OLAPDMLPinningTracker.truncate(pinned, n);
        EditorManager editorManager = EditorManager.getEditorManager();
        LinkedList<Editor> linkedList = new LinkedList<Editor>();
        Context context = editor.getContext();
        Node node = context != null ? context.getNode() : null;
        for (Object e : editorManager.getAllEditors()) {
            Context context2 = ((Editor)e).getContext();
            Node node2 = context2 != null ? context2.getNode() : null;
            if (!(node2 instanceof OLAPDMLNode) || node == node2 || pinned.contains(node2) || node2.getURL() == null) continue;
            linkedList.add((Editor)e);
        }
        editorManager.closeEditors(linkedList);
    }

    private static void truncate(LinkedList<Node> linkedList, int n) {
        if (linkedList.size() <= n) {
            return;
        }
        linkedList.removeFirst();
        OLAPDMLPinningTracker.truncate(linkedList, n);
    }

    public static boolean isPinned(Node node) {
        return pinned.contains(node);
    }

    public static void pinNode(Node node) {
        pinned.add(node);
    }

    public static void unpinNode(Node node) {
        pinned.remove(node);
    }
}

