/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.phighlight.TooltipMessage;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.status.editor.StatusEditorPlugin;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewStatus;
import oracle.olap.dml.editor.OLAPDMLErrorInfo;
import oracle.olap.dml.editor.OLAPDMLHighlightAddin;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public class OLAPDMLHighlightEditorPlugin
implements EditorPlugin,
TooltipMessage {
    private Logger logger = Logger.getLogger(OLAPDMLHighlightEditorPlugin.class.getName());
    private BasicEditorPane _editorPane;
    private NodeListener _nodeListener;
    private HighlightLayer _highlightLayer;
    private List<OLAPDMLErrorInfo> _errors;

    public String getToolTipText(int n) {
        int n2 = this._editorPane.getLineCount();
        if (n2 == 0) {
            return null;
        }
        if (this._errors != null && 0 < this._errors.size()) {
            for (OLAPDMLErrorInfo oLAPDMLErrorInfo : this._errors) {
                int n3 = oLAPDMLErrorInfo.getLineNumber();
                if (--n3 < 0) {
                    n3 = 0;
                } else if (n3 >= n2) {
                    n3 = n2 - 1;
                }
                int n4 = this._editorPane.getLineStartOffset(n3);
                int n5 = n4 + oLAPDMLErrorInfo.getColumn() - 1;
                int n6 = this.getErrorEndOffset(oLAPDMLErrorInfo.getLineNumber(), n5);
                if (n < n5 || n > n6) continue;
                String[] stringArray = oLAPDMLErrorInfo.getErrorMessage().split("\n");
                Object object = stringArray[0];
                if (stringArray.length > 1) {
                    object = (String)object + "...";
                }
                return object;
            }
        }
        return null;
    }

    public void install(BasicEditorPane basicEditorPane) {
        this._editorPane = basicEditorPane;
        final OLAPDMLNode oLAPDMLNode = this.getNode();
        if (oLAPDMLNode != null) {
            this._nodeListener = new NodeListener(){

                public void nodeSaved(NodeEvent nodeEvent) {
                    if (oLAPDMLNode.getParser().text == null) {
                        return;
                    }
                    if (DBURLFormatHelper.isDBURL((URL)oLAPDMLNode.getURL())) {
                        OLAPDMLHighlightEditorPlugin.this.updateHighlight();
                    }
                }
            };
            oLAPDMLNode.addNodeListener(this._nodeListener);
            this.updateHighlight();
        }
        this.deinstallStatusEditorPlugin();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        OLAPDMLNode oLAPDMLNode = this.getNode();
        oLAPDMLNode.removeNodeListener(this._nodeListener);
        this._highlightLayer = null;
        this._editorPane = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected OLAPDMLNode getNode() {
        Context context = null;
        OLAPDMLNode oLAPDMLNode = null;
        if (this._editorPane != null) {
            context = (Context)this._editorPane.getProperty("editor-ide-context");
        }
        if (context != null) {
            oLAPDMLNode = (OLAPDMLNode)context.getNode();
        }
        return oLAPDMLNode;
    }

    public HighlightLayer getHighlightLayer() {
        if (this._highlightLayer == null && this._editorPane != null) {
            this._highlightLayer = this._editorPane.createHighlightLayer();
        }
        return this._highlightLayer;
    }

    private void deinstallStatusEditorPlugin() {
        try {
            Field field = BasicEditorPane.class.getDeclaredField("pluginList");
            field.setAccessible(true);
            ArrayList arrayList = (ArrayList)field.get(this._editorPane);
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                if (!(e instanceof StatusEditorPlugin)) continue;
                this._editorPane.deinstallPlugin((EditorPlugin)e);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    private void updateHighlight() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OLAPDMLHighlightEditorPlugin.this._errors = OLAPDMLHighlightEditorPlugin.this.getErrors();
                HighlightLayer highlightLayer = OLAPDMLHighlightEditorPlugin.this.getHighlightLayer();
                if (highlightLayer == null) {
                    return;
                }
                highlightLayer.removeAllHighlights();
                HighlightStyle highlightStyle = OLAPDMLHighlightAddin.getErrorHighlightStyle();
                HighlightStyle highlightStyle2 = OLAPDMLHighlightAddin.getWarningHighlightStyle();
                HighlightStyle highlightStyle3 = OLAPDMLHighlightAddin.getFatalHighlightStyle();
                CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)OLAPDMLHighlightEditorPlugin.this._editorPane);
                BasicEditorOverview basicEditorOverview = codeEditor.getOverview();
                String string = "audit-errors";
                String string2 = "audit-warnings";
                basicEditorOverview.removeMarks((Object)string);
                basicEditorOverview.removeMarks((Object)string2);
                int n = OLAPDMLHighlightEditorPlugin.this._editorPane.getLineCount();
                if (n == 0) {
                    return;
                }
                for (OLAPDMLErrorInfo oLAPDMLErrorInfo : OLAPDMLHighlightEditorPlugin.this._errors) {
                    Color color;
                    HighlightStyle highlightStyle4;
                    String string3;
                    int n2 = oLAPDMLErrorInfo.getLineNumber();
                    if (--n2 < 0) {
                        n2 = 0;
                    } else if (n2 >= n) {
                        n2 = n - 1;
                    }
                    if (!oLAPDMLErrorInfo.isWarning() && !oLAPDMLErrorInfo.isFatal()) {
                        string3 = string;
                        highlightStyle4 = highlightStyle;
                        color = OverviewStatus.ERROR;
                    } else if (!oLAPDMLErrorInfo.isWarning() && oLAPDMLErrorInfo.isFatal()) {
                        string3 = string;
                        highlightStyle4 = highlightStyle3;
                        color = OverviewStatus.ERROR;
                    } else {
                        string3 = string2;
                        highlightStyle4 = highlightStyle2;
                        color = OverviewStatus.WARNING;
                    }
                    try {
                        int n3 = OLAPDMLHighlightEditorPlugin.this._editorPane.getLineCount();
                        if (n3 < n2) {
                            OLAPDMLHighlightEditorPlugin.this.logger.log(Level.SEVERE, "Could not highlight: #lines = " + n3 + ", line=" + n2);
                            return;
                        }
                        int n4 = OLAPDMLHighlightEditorPlugin.this._editorPane.getLineStartOffset(n2);
                        int n5 = OLAPDMLHighlightEditorPlugin.this._editorPane.getLineEndOffset(n2);
                        int n6 = oLAPDMLErrorInfo.getColumn();
                        int n7 = n4 + n6 - 1;
                        int n8 = !oLAPDMLErrorInfo.isFatal() ? OLAPDMLHighlightEditorPlugin.this.getErrorEndOffset(n2, n7) : n5;
                        highlightLayer.addHighlight(highlightStyle4, n7, n8);
                        basicEditorOverview.addMark((OverviewMark)new BasicEditorOverviewMark(OLAPDMLHighlightEditorPlugin.this._editorPane, Integer.valueOf(n7), Integer.valueOf(n7), 2.0f, color), (Object)string3);
                    }
                    catch (Exception exception) {}
                }
                OverviewStatus overviewStatus = basicEditorOverview.getStatus();
                if (0 < OLAPDMLHighlightEditorPlugin.this._errors.size()) {
                    overviewStatus.setColor(OverviewStatus.ERROR);
                } else {
                    overviewStatus.setColor(OverviewStatus.OK);
                }
            }
        });
    }

    private List<OLAPDMLErrorInfo> getErrors() {
        List<OLAPDMLErrorInfo> list = new ArrayList<OLAPDMLErrorInfo>();
        OLAPDMLNode oLAPDMLNode = this.getNode();
        if (oLAPDMLNode != null) {
            list = oLAPDMLNode.getCompileErrors();
        }
        return list;
    }

    private int getErrorEndOffset(int n, int n2) {
        int n3 = n2 + 1;
        int n4 = this._editorPane.getLineEndOffset(n);
        String string = null;
        try {
            string = this._editorPane.getText(n2, n4 - n2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (string != null) {
            int n5 = string.indexOf(" ");
            int n6 = string.indexOf("\n");
            n3 = n5 > 0 ? n2 + n5 : (n6 > 0 ? n2 + n6 : n4);
        }
        return n3;
    }
}

