/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml.editor;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.SQLException;
import java.util.Collections;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.RunProcess;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.RunningProcess;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.run.JRunner;
import oracle.olap.OLAPArb;
import oracle.olap.dml.editor.OLAPDMLRunnerPanel;
import oracle.olap.dml.editor.OLAPStarterFactory;
import oracle.olap.navigator.olapdml.OLAPDMLNode;

public class OLAPDMLController
implements Controller {
    static Logger LOGGER = Logger.getLogger(OLAPDMLController.class.getName());
    private static final Object LOCK = new Object();
    private static OLAPDMLController _controller;
    public static final int COMPILE_COMMAND;
    public static final int MAKE_COMMAND;
    public static final int RUN_COMMAND;
    public static final int DEBUG_COMMAND;
    int tmpDebug = 0;
    private String selection = null;

    private OLAPDMLController() {
        this.createActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OLAPDMLController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_controller == null) {
                _controller = new OLAPDMLController();
            }
        }
        return _controller;
    }

    private void createActions() {
        this.createAction(MAKE_COMMAND, Messages.getString((String)"Make"));
        this.createAction(COMPILE_COMMAND, Messages.getString((String)"Compile"));
        this.createAction(RUN_COMMAND, Messages.getString((String)"Run"));
    }

    private void createAction(int n, String string) {
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n2 = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        IdeAction ideAction = IdeAction.findOrCreate((int)n, (MetaClass)null, (String)string2);
        if (n2 != null) {
            ideAction.putValue("MnemonicKey", (Object)n2);
        }
        ideAction.addController((Controller)this);
    }

    public boolean update(IdeAction ideAction, Context context) {
        Node node = context.getNode();
        if (node instanceof OLAPDMLNode) {
            OLAPDMLController.updateAction(ideAction, (OLAPDMLNode)node);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(IdeAction ideAction, final Context context) {
        boolean bl = false;
        final int n = ideAction.getCommandId();
        if (n == MAKE_COMMAND || n == COMPILE_COMMAND) {
            Node node = context.getNode();
            if (node instanceof OLAPDMLNode) {
                OLAPDMLNode oLAPDMLNode = (OLAPDMLNode)node;
                WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                waitCursor.show();
                try {
                    oLAPDMLNode.ensureOpen();
                    oLAPDMLNode.markDirty(true);
                    oLAPDMLNode.invokedFromToolbar = true;
                    String string = oLAPDMLNode.getConnectionName();
                    if (string == null) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString((String)"PLSQLController.noConnectionMsg"), (String)Messages.getString((String)"PLSQLController.noConnectionTitle"), null);
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (n == COMPILE_COMMAND) {
                        this.setDebug(false, string);
                    } else {
                        this.setDebug(null, string);
                    }
                    oLAPDMLNode.save();
                    this.restoreDebug(string);
                    Ide.getStatusBar().setText(OLAPArb.format("OLAPDML_COMPILE_AND_SAVE_MESSAGE", oLAPDMLNode.getFullyQualifiedName()));
                }
                catch (IOException iOException) {
                    Ide.getStatusBar().setText(OLAPArb.format("OLAPDML_COMPILE_AND_SAVE_ERROR_MESSAGE", iOException.getMessage()));
                }
                finally {
                    waitCursor.hide();
                }
                bl = true;
            }
        } else if (n == RUN_COMMAND || n == DEBUG_COMMAND) {
            final Node node = context.getNode();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Object object;
                    TextBuffer textBuffer = null;
                    boolean bl = node instanceof OLAPDMLNode;
                    if (bl) {
                        object = n == DEBUG_COMMAND ? new OLAPDMLRunnerPanel.OLAPDMLDebuggerPanel((OLAPDMLNode)node) : new OLAPDMLRunnerPanel((OLAPDMLNode)node);
                        textBuffer = ((OLAPDMLRunnerPanel)object).runDialog();
                        ((OLAPDMLRunnerPanel)object).cleanup();
                    }
                    if (textBuffer != null || !bl) {
                        RunConfiguration runConfiguration;
                        object = context.getProject();
                        if (object != null && (runConfiguration = RunConfigurations.getRunConfigurationByName((Project)object, (String)RunConfiguration.getDefaultName())) != null) {
                            context.setProperty("RunContext.RUN_CONFIGURATION", (Object)runConfiguration);
                        }
                        runConfiguration = JRunner.prepareProcessContext((Context)context, (boolean)false);
                        if (textBuffer != null) {
                            runConfiguration.setProperty("PlSqlStarter.SQL", (Object)textBuffer.getString(0, textBuffer.getLength()));
                        }
                        RunningProcess runningProcess = n == RUN_COMMAND ? new RunningProcess((Context)runConfiguration) : new DebuggingProcess((Context)runConfiguration);
                        RunConfiguration runConfiguration2 = runningProcess.getRunConfiguration();
                        boolean bl2 = DBURLFormatHelper.isDBURL((URL)node.getURL());
                        if (!bl2) {
                            runConfiguration2.setCompileBeforeRun(false);
                            if (node instanceof OLAPDMLNode) {
                                runConfiguration2.setTargetURL(((OLAPDMLNode)node).matchingDbUrl());
                            } else {
                                try {
                                    runConfiguration2.setTargetURL(new URL("http://potato.com"));
                                    Class<RunProcess> clazz = RunProcess.class;
                                    Field field = clazz.getDeclaredField("starter");
                                    field.setAccessible(true);
                                    View view = context.getView();
                                    String string = ((DbEditor)view).getConnectionName();
                                    field.set(runningProcess, (Object)new OLAPStarterFactory.OLAPStarter((JRunProcess)runningProcess, OLAPDMLController.this.selection, string, context));
                                }
                                catch (Exception exception) {
                                    System.err.println(exception);
                                }
                            }
                        } else {
                            runConfiguration2.setTargetURL(node.getURL());
                        }
                        runningProcess.start();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
            bl = true;
        }
        return bl;
    }

    private void restoreDebug(String string) {
        DBConfig.getInstance().putInt("PLSQLOPTIMLEVEL", this.tmpDebug);
        Connections connections = Connections.getInstance();
        DBConfig dBConfig = DBConfig.getInstance();
        try {
            int n = Connections.getInstance().getConnection(string).getMetaData().getDatabaseMajorVersion();
            if (n >= 10) {
                DBUtil.getInstance((String)string).execute("alter session set PLSQL_OPTIMIZE_LEVEL=" + dBConfig.getString("PLSQLOPTIMLEVEL"), Collections.emptyList());
            }
        }
        catch (SQLException sQLException) {
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (!connections.isTimesTen(string)) {
            DBUtil.getInstance((String)string).execute("alter session set PLSQL_DEBUG=" + (2 != dBConfig.getInt("PLSQLOPTIMLEVEL") ? "true" : "false"), Collections.emptyList());
        }
    }

    private void setDebug(Boolean bl, String string) {
        this.tmpDebug = DBConfig.getInstance().getInt("PLSQLOPTIMLEVEL");
        int n = bl == null ? this.tmpDebug : (bl != false ? 1 : 2);
        DBConfig.getInstance().putInt("PLSQLOPTIMLEVEL", n);
        Connections connections = Connections.getInstance();
        try {
            int n2 = Connections.getInstance().getConnection(string).getMetaData().getDatabaseMajorVersion();
            if (n2 >= 10) {
                DBUtil.getInstance((String)string).execute("alter session set PLSQL_OPTIMIZE_LEVEL=" + n, Collections.emptyList());
            }
        }
        catch (SQLException sQLException) {
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (!connections.isTimesTen(string) && bl != null) {
            DBUtil.getInstance((String)string).execute("alter session set PLSQL_DEBUG=" + bl, Collections.emptyList());
        }
    }

    public static boolean updateAction(IdeAction ideAction, OLAPDMLNode oLAPDMLNode) {
        ideAction.setEnabled(true);
        boolean bl = oLAPDMLNode.getConnectionName() != null;
        Debugger debugger = Debugger.getDebugger();
        if (debugger.isDebugging() || !bl) {
            ideAction.setEnabled(false);
        }
        if (DBURLFormatHelper.isDBURL((URL)oLAPDMLNode.getURL()) && Boolean.valueOf((String)oLAPDMLNode.getProperty("INVALID")).booleanValue() && (ideAction.getCommandId() == RUN_COMMAND || ideAction.getCommandId() == DEBUG_COMMAND)) {
            ideAction.setEnabled(false);
        }
        return true;
    }

    static {
        COMPILE_COMMAND = Ide.findOrCreateCmdID((String)"OLAPDMLController.Compile");
        MAKE_COMMAND = Ide.findOrCreateCmdID((String)"OLAPDMLController.Make");
        RUN_COMMAND = Ide.findOrCreateCmdID((String)"OLAPDMLController.Run");
        DEBUG_COMMAND = Ide.findOrCreateCmdID((String)"OLAPDMLController.Debug");
    }
}

