/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.db.DatabaseUtils;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.table.Queries;

public class DMLObject
extends NamedObject {
    private static Queries queries;
    private static final String XMLFILE = "olapdml.xml";
    private static final String SHOW_OBJLIST = "SHOW_OBJLIST";
    private static final String SHOW_OBJR = "SHOW_OBJR";
    private static final String SHOW_OBJ = "SHOW_OBJ";
    private static final String LOCK_DFN = "LOCK_DFN";
    private static final String IS_INACCESSIBLE = "IS_INACCESSIBLE";
    private static final String DML_EXISTS = "DML_EXISTS";
    private static final String OBJ_TYPE = "OBJ_TYPE";
    private static final String FULLDSC = "FULLDSC";
    private static final String COMPILE = "COMPILE";
    private static final String DELETE = "DELETE";
    private static final String DML_OBJ_LIST = "DML_OBJECT_LIST";
    private static final String YES = "YES";
    public static final String ATTACH_AW = "ATTACH_AW";
    public static final String ATTACH_AW_RO_FIRST = "ATTACH_AW_RO_FIRST";
    public static final String DETACH_AW = "DETACH_AW";
    public static final String IS_AW_ATTACHED_IN_SESSION = "IS_AW_ATTACHED_IN_SESSION";
    public static final String IS_AW_ATTACHED_IN_SESSION_RW = "IS_AW_ATTACHED_IN_SESSION_RW";
    public static final String IS_AW_ATTACHED_IN_SESSION_RO = "IS_AW_ATTACHED_IN_SESSION_RO";
    public static final String IS_AW_ATTACHED_IN_SESSION_MULTI = "IS_AW_ATTACHED_IN_SESSION_MULTI";
    public static final String AW_ATTACH_MODE_RW = "RW";
    public static final String AW_ATTACH_MODE_RO = "RO";
    public static final String AW_ATTACH_MODE_MULTI = "MULTI";
    public static final String UPDATE_AW = "UPDATE_AW";
    public static final String DELETE_AW = "DELETE_AW";
    public static final String IMPORT_AW_FROM_EIF_FILE = "IMPORT_AW_FROM_EIF_FILE";
    public static final String EXPORT_AW_TO_EIF_FILE = "EXPORT_AW_TO_EIF_FILE";
    public static final String CREATE_AW = "CREATE_AW";
    public static final String CREATE_AW_IN_TABLESPACE = "CREATE_AW_IN_TABLESPACE";
    public static final String OLAP_DML_TYPE_PROGRAM = "PROGRAM";
    public static final String OLAP_DML_TYPE_AGGMAP = "AGGMAP";
    public static final String OLAP_DML_TYPE_MODEL = "MODEL";
    public static final String OLAP_DML_TYPE_DIMENSION = "DIMENSION";
    public static final String OLAP_DML_TYPE_FORMULA = "FORMULA";
    public static final String OLAP_DML_TYPE_COMPOSITE = "COMPOSITE";
    public static final String OLAP_DML_TYPE_PARTITION = "PARTITION";
    private final Connection conn;
    private final String workspace;
    private final String name;
    private String definition;
    private DBUtil dbUtil;

    public DMLObject(Connection connection, String string, String string2) {
        this(connection, string, string2, null);
    }

    public DMLObject(Connection connection, String string, String string2, String string3) {
        super(string2);
        this.conn = connection;
        if (connection != null) {
            this.dbUtil = DBUtil.getInstance((Connection)connection);
        }
        this.workspace = string;
        this.name = string2;
        this.definition = string3;
        if (queries == null) {
            try {
                String string4 = "oracle.olap.app.table";
                String string5 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string5, string4, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isCompilable() throws SQLException, IOException {
        boolean bl = true;
        String string = "";
        string = this.getType();
        bl = string.equalsIgnoreCase(OLAP_DML_TYPE_PROGRAM) || string.equalsIgnoreCase(OLAP_DML_TYPE_MODEL) || string.equalsIgnoreCase(OLAP_DML_TYPE_AGGMAP) || string.equalsIgnoreCase(OLAP_DML_TYPE_FORMULA);
        return bl;
    }

    public String getType() throws SQLException, IOException {
        String string = "";
        String string2 = String.format(DMLObject.getQuery(OBJ_TYPE), this.workspace, this.name);
        string = this.dbUtil.executeReturnOneCol(string2);
        return string;
    }

    public boolean isLockDfn() throws SQLException, IOException {
        boolean bl = false;
        String string = String.format(DMLObject.getQuery(LOCK_DFN), this.workspace, this.name);
        String string2 = this.dbUtil.executeReturnOneCol(string);
        bl = string2.equalsIgnoreCase("1");
        return bl;
    }

    public boolean isInaccessible() throws SQLException, IOException {
        boolean bl = false;
        String string = String.format(DMLObject.getQuery(IS_INACCESSIBLE), this.workspace, this.name);
        String string2 = this.dbUtil.executeReturnOneCol(string);
        bl = string2.equalsIgnoreCase("1");
        return bl;
    }

    public boolean isExists() throws SQLException, IOException {
        boolean bl = true;
        String string = String.format(DMLObject.getQuery(DML_EXISTS), this.workspace, this.name);
        String string2 = this.dbUtil.executeReturnOneCol(string);
        bl = string2.equalsIgnoreCase("1");
        return bl;
    }

    public List<DMLObject> getDependencies(boolean bl) throws SQLException, IOException {
        ArrayList<DMLObject> arrayList = new ArrayList<DMLObject>();
        try {
            String string = "";
            string = bl ? String.format(DMLObject.getQuery(SHOW_OBJR), this.workspace, this.name) : String.format(DMLObject.getQuery(SHOW_OBJ), this.workspace, this.name);
            String string2 = DatabaseUtils.ExecuteSPL(this.conn, string);
            String[] stringArray = string2.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("NA")) continue;
                arrayList.add(new DMLObject(this.conn, this.workspace, stringArray[i]));
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 34492) {
                throw sQLException;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        return arrayList;
    }

    public String create() throws SQLException, IOException {
        return DatabaseUtils.ExecuteSPL(this.conn, this.definition);
    }

    public String drop() throws SQLException, IOException {
        return DMLObject.runDML(this.conn, DELETE, this.workspace, this.name);
    }

    public String compile() throws SQLException, IOException {
        return DMLObject.runDML(this.conn, COMPILE, this.workspace, this.name);
    }

    public String fetchDefinition() throws SQLException, IOException {
        return DMLObject.runDML(this.conn, FULLDSC, this.workspace, this.name);
    }

    public String getWorkspace() {
        return this.workspace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public String getDefinition() {
        return this.definition;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DMLObject) {
            DMLObject dMLObject = (DMLObject)object;
            return (this.name == dMLObject.name || this.name != null && this.name.equalsIgnoreCase(dMLObject.name)) && (this.workspace == dMLObject.workspace || this.workspace != null && this.workspace.equalsIgnoreCase(dMLObject.workspace)) && (this.definition == null || dMLObject.definition == null || this.definition == dMLObject.definition || this.definition != null && this.definition.equals(dMLObject.definition));
        }
        if (object instanceof String) {
            return this.name == object || this.name != null && this.name.equalsIgnoreCase((String)object);
        }
        return false;
    }

    public static String runDML(Connection connection, String string, Object ... objectArray) throws SQLException, IOException {
        return DatabaseUtils.ExecuteSPL(connection, String.format(DMLObject.getQuery(string), objectArray));
    }

    public String getWorkspaceObjects() throws SQLException, IOException {
        return DMLObject.runDML(this.conn, DML_OBJ_LIST, this.workspace);
    }

    public static String getAWAttachModeInSession(Connection connection, String string) throws SQLException, IOException {
        String string2 = null;
        String string3 = DMLObject.runDML(connection, IS_AW_ATTACHED_IN_SESSION, string);
        if (string3.equalsIgnoreCase(YES)) {
            string2 = AW_ATTACH_MODE_RO;
            String string4 = DMLObject.runDML(connection, IS_AW_ATTACHED_IN_SESSION_RW, string);
            if (string4.equalsIgnoreCase(YES)) {
                string2 = AW_ATTACH_MODE_RW;
            } else {
                string4 = DMLObject.runDML(connection, IS_AW_ATTACHED_IN_SESSION_MULTI, string);
                if (string4.equalsIgnoreCase(YES)) {
                    string2 = AW_ATTACH_MODE_MULTI;
                }
            }
        }
        return string2;
    }

    private static String getQuery(String string) {
        if (queries == null) {
            new DMLObject(null, null, null, null);
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        DMLObject.queries = queries;
    }
}

