/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubeviewer;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.ExportGrid;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.dialogs.actions.TableExportAction;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.MnemonicSolver;
import oracle.javatools.ui.table.GenericTable;

public class CubeTable
extends GenericTable {
    private static boolean _initedStatics;
    private static ContextMenu _gridCM;

    public CubeTable() {
        this.initStatics();
        this.init();
    }

    private void initStatics() {
        if (!_initedStatics) {
            CubeTable.addGridContextMenu((GridContextMenuItem)ExportGrid.getInstance());
            _initedStatics = true;
        }
    }

    public static void addGridContextMenu(GridContextMenuItem gridContextMenuItem) {
        _gridCM.addContextMenuListener((ContextMenuListener)gridContextMenuItem);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)gridContextMenuItem);
    }

    private void init() {
        final JPopupMenu jPopupMenu = new JPopupMenu();
        TableExportAction tableExportAction = new TableExportAction();
        tableExportAction.setTable((JTable)((Object)this));
        jPopupMenu.add(tableExportAction.getMenu());
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private Context _context = new Context();

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showPopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showPopup(mouseEvent);
                }
            }

            private void showPopup(MouseEvent mouseEvent) {
                jPopupMenu.show((Component)((Object)CubeTable.this), mouseEvent.getX(), mouseEvent.getY());
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    static {
        _gridCM = new ContextMenu(new MnemonicSolver());
    }
}

