/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.olap.app.Resources;
import oracle.olap.app.ui.HelpProvider;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.cubetemplate.ConflictRenameMap;
import oracle.olap.cubetemplate.ConflictTableModel;
import oracle.olap.cubetemplate.NamespaceValidator;
import oracle.olap.cubetemplate.ObjectType;

public class ImportConflictDialog
extends JDialog
implements ActionListener {
    private final Resources resources;
    private static Icon okIcon;
    private static Icon errorIcon;
    private final ConflictTableModel model;
    private static final String OK = "OK";
    private static final String CANCEL = "CANCEL";
    private static final String HELP = "HELP";
    private static final String HELPID = "olap_correct_duplicate_names";
    private int NAME = 2;
    private boolean canceled;
    private final JButton ok = new JButton();
    private final HelpProvider helpProvider;
    private JPanel mainPanel;

    public ImportConflictDialog(Frame frame, String string, Resources resources, HelpProvider helpProvider, ConflictRenameMap conflictRenameMap, NamespaceValidator namespaceValidator, boolean bl, boolean bl2) throws SQLException {
        super(frame, string, true);
        this.ok.setName("ok");
        this.helpProvider = helpProvider;
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setMinimumSize(new Dimension(600, 600));
        this.setSize(800, 600);
        this.setLocationRelativeTo(frame);
        this.resources = resources;
        this.mainPanel = new JPanel(new BorderLayout(0, 15));
        this.mainPanel.setName("mainPanel");
        JLabel jLabel = new JLabel("<html>" + resources.getString("PANEL_NAMESPACE_CONFLICT_DIALOG_TOP_LABEL") + "</hmtl>");
        jLabel.setName("message");
        final JTable jTable = new JTable();
        jTable.setName("grid");
        jTable.setSelectionMode(0);
        jTable.setRowHeight(jTable.getRowHeight() + 3);
        jTable.setAutoCreateColumnsFromModel(false);
        this.model = new ConflictTableModel(conflictRenameMap, namespaceValidator, resources);
        jTable.setModel(this.model);
        TableColumn tableColumn = new TableColumn(0, 60);
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JLabel && object instanceof Boolean) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setText("");
                    if (((Boolean)object).booleanValue()) {
                        jLabel.setIcon(okIcon);
                    } else {
                        jLabel.setIcon(errorIcon);
                    }
                }
                return component;
            }
        });
        TableColumn tableColumn2 = new TableColumn(1, 80);
        tableColumn2.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                ObjectType objectType = ImportConflictDialog.this.getObjectType((Integer)object);
                Component component = super.getTableCellRendererComponent(jTable, (Object)objectType, bl, bl2, n, n2);
                if (component instanceof JLabel && object instanceof Integer) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setIcon(objectType.getIcon(false));
                }
                return component;
            }
        });
        jTable.addColumn(tableColumn);
        jTable.addColumn(tableColumn2);
        if (bl) {
            jTable.addColumn(new TableColumn(2, 70));
            this.NAME = 3;
        }
        TableColumn tableColumn3 = new TableColumn(3, 120);
        JTextField jTextField = new JTextField();
        jTextField.setName("editor");
        jTextField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (jTable.isEditing()) {
                    int n2 = 0;
                    int n3 = (Integer)ImportConflictDialog.this.model.getValueAt(jTable.getEditingRow(), 1);
                    n2 = n3 == 3 ? 26 : 30;
                    int n4 = this.getLength() + string.length() - n2;
                    if (n4 > 0) {
                        string = string.substring(0, string.length() - n4);
                    }
                    if (string.length() > 0) {
                        super.insertString(n, string.toUpperCase(), attributeSet);
                    }
                } else {
                    super.insertString(n, string.toUpperCase(), attributeSet);
                }
            }
        });
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
        defaultCellEditor.setClickCountToStart(1);
        tableColumn3.setCellEditor(defaultCellEditor);
        jTable.addColumn(tableColumn3);
        jTable.addColumn(new TableColumn(4, 500));
        jTable.setSurrendersFocusOnKeystroke(true);
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && !jTable.isEditing()) {
                    for (int i = listSelectionEvent.getLastIndex() - 1; i <= listSelectionEvent.getLastIndex(); ++i) {
                        if (!jTable.isRowSelected(i)) continue;
                        jTable.editCellAt(i, ImportConflictDialog.this.NAME);
                        break;
                    }
                }
            }
        });
        if (!bl2) {
            this.model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() == 0) {
                        ImportConflictDialog.this.ok.setEnabled(ImportConflictDialog.this.model.isFixed());
                    }
                }
            });
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setName("gridScroll");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName("buttons");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setName("buttonsLeft");
        JButton jButton = new JButton();
        jButton.setName("help");
        this.setMnemonic(jButton, "APP.MENU.HELP.NAME");
        jButton.setActionCommand(HELP);
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.setName("buttonsRight");
        this.setMnemonic(this.ok, "EXPORT_TO_TABLE.DIALOG.FORM.OK");
        this.ok.setEnabled(bl2);
        this.ok.setActionCommand(OK);
        this.ok.addActionListener(this);
        JButton jButton2 = new JButton();
        jButton2.setName("cancel");
        this.setMnemonic(jButton2, "EXPORT_TO_TABLE.DIALOG.FORM.CANCEL");
        jButton2.setActionCommand(CANCEL);
        jButton2.addActionListener(this);
        jPanel3.add(this.ok);
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        this.mainPanel.add((Component)jLabel, "North");
        this.mainPanel.add((Component)jPanel, "South");
        this.mainPanel.add((Component)jScrollPane, "Center");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.add(this.mainPanel);
    }

    private void setMnemonic(AbstractButton abstractButton, String string) {
        String string2 = this.resources.getString(string);
        abstractButton.setText(string2.replaceFirst("&", ""));
        int n = string2.indexOf("&");
        if (n != -1) {
            abstractButton.setMnemonic(abstractButton.getText().charAt(n));
        }
    }

    private ObjectType getObjectType(int n) {
        switch (n) {
            case 3: {
                return ObjectType.WORKSPACE;
            }
            case 2: {
                return ObjectType.CUBE;
            }
            case 1: {
                return ObjectType.DIMENSION;
            }
            case 4: {
                return ObjectType.MEASURE_FOLDER;
            }
            case 5: {
                return ObjectType.MEASURE;
            }
            case 6: {
                return ObjectType.DERIVED_MEASURE;
            }
        }
        return ObjectType.ALL;
    }

    public boolean isSuccesful() {
        return !this.canceled && this.model.isFixed();
    }

    public static void setUpIcons(FetchIcon fetchIcon) {
        okIcon = fetchIcon.getIcon("OLAPNAMECONFLICTOK");
        errorIcon = fetchIcon.getIcon("OLAPNAMECONFLICTERROR");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(OK)) {
            this.setVisible(false);
        } else if (actionEvent.getActionCommand().equals(CANCEL)) {
            this.canceled = true;
            this.setVisible(false);
        } else if (actionEvent.getActionCommand().equals(HELP)) {
            this.helpProvider.showHelp(this.mainPanel, HELPID);
        }
    }
}

