/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.partition.model;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.olap.cube.partition.query.CubePartitionQuery;

public class PartitionQueryCancelExecuteContext {
    private static PartitionQueryCancelExecuteContext instance;
    private List<CubePartitionQuery> cubePartitionQueryList = new ArrayList<CubePartitionQuery>();
    private boolean cancelLastTime = false;
    private RaptorTask raptorTask;

    private PartitionQueryCancelExecuteContext() {
    }

    public static PartitionQueryCancelExecuteContext getInstance() {
        if (instance == null) {
            instance = new PartitionQueryCancelExecuteContext();
        }
        return instance;
    }

    public void setRaptorTask(RaptorTask raptorTask) {
        this.raptorTask = raptorTask;
    }

    public RaptorTask getRaptorTask() {
        return this.raptorTask;
    }

    public void init() {
        this.cubePartitionQueryList.clear();
    }

    public void addCubePartitionQuery(CubePartitionQuery cubePartitionQuery) {
        this.cubePartitionQueryList.add(cubePartitionQuery);
    }

    public boolean arePartitionQueriesRunning() {
        boolean bl = false;
        if (this.cubePartitionQueryList.size() > 0) {
            for (CubePartitionQuery cubePartitionQuery : this.cubePartitionQueryList) {
                if (!cubePartitionQuery.isBusy()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void cancel() {
        if (this.cubePartitionQueryList.size() > 0) {
            for (CubePartitionQuery cubePartitionQuery : this.cubePartitionQueryList) {
                if (!cubePartitionQuery.isBusy()) continue;
                cubePartitionQuery.update();
            }
        }
        this.cancelLastTime = true;
    }

    public boolean didCancelLastTime() {
        return this.cancelLastTime;
    }

    public void resetCancel() {
        this.cancelLastTime = false;
    }

    public void close() {
        this.cubePartitionQueryList.clear();
    }
}

