/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.partition;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import oracle.olap.app.Resources;
import oracle.olap.app.ui.GroupCheckBoxObserver;
import oracle.olap.app.ui.GroupCheckBoxSelection;
import oracle.olap.cube.partition.MainPartitionPanel;
import oracle.olap.cube.partition.OrderedHierarchy;
import oracle.olap.cube.partition.PartitionCheckBoxModel;
import oracle.olap.cube.partition.PartitionCheckBoxTable;
import oracle.olap.cube.partition.model.HierarchyLevelWrapper;
import oracle.olap.cube.partition.model.PartitionHierarchyLevelHelper;
import oracle.olap.cube.partition.model.PartitionHierarchyLevelMetadataHelper;

public class ManagePartitionSelectionPanel
extends JPanel
implements OrderedHierarchy,
GroupCheckBoxObserver {
    private MainPartitionPanel mainPartitionPanel;
    private PartitionCheckBoxTable partitionCheckBoxTable;
    private PartitionCheckBoxModel partitionCheckBoxModel;
    private Resources resources;
    private String currentDimensionName;
    private List<GroupCheckBoxSelection> partitionSelections = new ArrayList<GroupCheckBoxSelection>();
    private List<String> orderedHierarchies = new ArrayList<String>();
    private PartitionHierarchyLevelMetadataHelper partitionHierarchyLevelMetadataHelper;
    private PartitionHierarchyLevelHelper partitionHierarchyLevelHelper;
    private Map<String, List<GroupCheckBoxSelection>> cachePartitionSelections = new HashMap<String, List<GroupCheckBoxSelection>>();
    private Map<String, List<String>> cacheHierarchyOrder = new HashMap<String, List<String>>();
    private Map<String, Boolean> cacheAutoCheckBox = new HashMap<String, Boolean>();
    private Map<String, Integer[]> queryCounts = new HashMap<String, Integer[]>();
    private Map<String, Map<String, Integer[]>> cacheQueryCounts = new HashMap<String, Map<String, Integer[]>>();
    private GridBagConstraints c;
    private JPanel bottomPanel;

    public ManagePartitionSelectionPanel(MainPartitionPanel mainPartitionPanel, PartitionHierarchyLevelMetadataHelper partitionHierarchyLevelMetadataHelper, PartitionHierarchyLevelHelper partitionHierarchyLevelHelper, Resources resources) {
        this.mainPartitionPanel = mainPartitionPanel;
        this.partitionHierarchyLevelMetadataHelper = partitionHierarchyLevelMetadataHelper;
        this.partitionHierarchyLevelHelper = partitionHierarchyLevelHelper;
        this.resources = resources;
        this.jbInit();
    }

    public void setPartitionHierarchyLevelMetadataHelper(PartitionHierarchyLevelMetadataHelper partitionHierarchyLevelMetadataHelper) {
        this.partitionHierarchyLevelMetadataHelper = partitionHierarchyLevelMetadataHelper;
    }

    public void setPartitionHierarchyLevelHelper(PartitionHierarchyLevelHelper partitionHierarchyLevelHelper) {
        this.partitionHierarchyLevelHelper = partitionHierarchyLevelHelper;
    }

    public List<HierarchyLevelWrapper> getPartitionSelections() {
        ArrayList<HierarchyLevelWrapper> arrayList = new ArrayList<HierarchyLevelWrapper>();
        List<GroupCheckBoxSelection> list = this.partitionCheckBoxTable.getCheckBoxSelections();
        for (GroupCheckBoxSelection groupCheckBoxSelection : list) {
            HierarchyLevelWrapper hierarchyLevelWrapper = new HierarchyLevelWrapper(this.partitionHierarchyLevelMetadataHelper.getPartitionHierarchyLevelFromNames(this.currentDimensionName, groupCheckBoxSelection.getColumnName(), groupCheckBoxSelection.getCheckBoxName()));
            arrayList.add(hierarchyLevelWrapper);
        }
        return arrayList;
    }

    @Override
    public void fieldValueChanged() {
        this.mainPartitionPanel.fieldValueChanged();
    }

    public void enableUI(boolean bl) {
        this.partitionCheckBoxTable.enableUI(bl);
    }

    public boolean clearSelections() {
        boolean bl = this.partitionSelections.size() > 0;
        this.partitionSelections = new ArrayList<GroupCheckBoxSelection>();
        this.initializePartitionSelectionPanel(false);
        this.mainPartitionPanel.populatePartitionTable(this.getPartitionSelections());
        return bl;
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.anchor = 18;
        this.c.fill = 2;
        this.c.insets = new Insets(0, 0, 5, 0);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setBackground(Color.WHITE);
        this.partitionCheckBoxTable = new PartitionCheckBoxTable(null, this.resources);
    }

    public void initializePartitionSelections(String string, List<HierarchyLevelWrapper> list) {
        this.partitionSelections.clear();
        this.cachePartitionSelections.clear();
        this.cacheAutoCheckBox.clear();
        this.cacheHierarchyOrder.clear();
        this.cacheQueryCounts.clear();
        this.orderedHierarchies.clear();
        this.queryCounts.clear();
        this.currentDimensionName = string;
        for (HierarchyLevelWrapper hierarchyLevelWrapper : list) {
            GroupCheckBoxSelection groupCheckBoxSelection = new GroupCheckBoxSelection(hierarchyLevelWrapper.getHierarchyName(), hierarchyLevelWrapper.getLevelName());
            this.partitionSelections.add(groupCheckBoxSelection);
        }
        Object object = null;
        if (list.size() > 0) {
            object = list.get(0).getHierarchyName();
        }
        this.orderedHierarchies = this.partitionHierarchyLevelHelper.determineHierarchyOrderFromPartitionSelections(string, (String)object, this.partitionSelections, this.orderedHierarchies);
    }

    @Override
    public void setHierarchyOrder(List<String> list) {
        this.orderedHierarchies.clear();
        for (String string : list) {
            this.orderedHierarchies.add(string);
        }
        this.partitionSelections = this.cloneSelectionsFromPartitionSelectionPanel(this.partitionCheckBoxTable.getCheckBoxSelections());
        this.reorderPartitionSelectionsForNewHierarchyOrder();
        this.initializePartitionSelectionPanel(false);
        this.mainPartitionPanel.populatePartitionTable(this.getPartitionSelections());
        this.refreshPartitionLevelNames();
        this.revalidate();
        this.repaint();
    }

    public List<String> getOrderedHierarchies() {
        return this.orderedHierarchies;
    }

    public boolean arePartitionSelectionsCustom() {
        boolean bl = false;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        if (this.partitionSelections.size() > 0) {
            for (GroupCheckBoxSelection object : this.partitionSelections) {
                HierarchyLevelWrapper hierarchyLevelWrapper;
                if (hashMap.get(object.getColumnName()) != null) {
                    int groupCheckBoxSelection = (Integer)hashMap.get(object.getColumnName());
                    hierarchyLevelWrapper = new HierarchyLevelWrapper(this.partitionHierarchyLevelMetadataHelper.getPartitionHierarchyLevelFromNames(this.currentDimensionName, object.getColumnName(), object.getCheckBoxName()));
                    int string = hierarchyLevelWrapper.getLevelDepth();
                    if (string > groupCheckBoxSelection) {
                        bl = true;
                        break;
                    }
                    hierarchyLevelWrapper = new HierarchyLevelWrapper(this.partitionHierarchyLevelMetadataHelper.getPartitionHierarchyLevelFromNames(this.currentDimensionName, object.getColumnName(), object.getCheckBoxName()));
                    hashMap.put(object.getColumnName(), hierarchyLevelWrapper.getLevelDepth());
                    continue;
                }
                hierarchyLevelWrapper = new HierarchyLevelWrapper(this.partitionHierarchyLevelMetadataHelper.getPartitionHierarchyLevelFromNames(this.currentDimensionName, object.getColumnName(), object.getCheckBoxName()));
                hashMap.put(object.getColumnName(), hierarchyLevelWrapper.getLevelDepth());
            }
            if (!bl) {
                hashMap.clear();
                Object object = null;
                for (GroupCheckBoxSelection groupCheckBoxSelection : this.partitionSelections) {
                    if (object != null) {
                        String string = groupCheckBoxSelection.getColumnName();
                        if (string.equals(object)) continue;
                        if (hashMap.get(string) != null) {
                            bl = true;
                            break;
                        }
                        hashMap.put(object, 1);
                        object = string;
                        continue;
                    }
                    object = groupCheckBoxSelection.getColumnName();
                }
            }
        }
        return bl;
    }

    public void showSelectedDimension(String string, boolean bl) {
        if (string == null) {
            this.partitionCheckBoxTable.clearGroupCheckBoxTable();
            this.partitionSelections = new ArrayList<GroupCheckBoxSelection>();
            return;
        }
        boolean bl2 = false;
        if (this.currentDimensionName != null) {
            if (!this.currentDimensionName.equals(string)) {
                bl2 = true;
            }
        } else {
            this.currentDimensionName = string;
        }
        if (bl2) {
            this.partitionSelections = this.cloneSelectionsFromPartitionSelectionPanel(this.partitionCheckBoxTable.getCheckBoxSelections());
        }
        if (bl || bl2) {
            this.cachePartitionSelections.put(this.currentDimensionName, this.partitionSelections);
            this.cacheAutoCheckBox.put(this.currentDimensionName, this.mainPartitionPanel.autoManagePartitionOrder());
            this.cacheHierarchyOrder.put(this.currentDimensionName, this.orderedHierarchies);
            this.cacheQueryCounts.put(this.currentDimensionName, this.queryCounts);
        }
        this.currentDimensionName = string;
        this.orderedHierarchies = this.cacheHierarchyOrder.get(string);
        if (this.orderedHierarchies == null || this.orderedHierarchies.size() == 0) {
            this.orderedHierarchies = this.currentDimensionName != null && this.currentDimensionName.length() > 0 ? this.partitionHierarchyLevelMetadataHelper.getHierarchyNames(this.currentDimensionName) : new ArrayList<String>();
        }
        if (bl || bl2) {
            Boolean bl3;
            this.partitionSelections = this.cachePartitionSelections.get(string);
            if (this.partitionSelections == null) {
                this.partitionSelections = new ArrayList<GroupCheckBoxSelection>();
            }
            if ((bl3 = this.cacheAutoCheckBox.get(string)) == null) {
                this.mainPartitionPanel.setAutoCheckBoxSelected(true);
            } else {
                this.mainPartitionPanel.setAutoCheckBoxSelected(bl3);
            }
            this.queryCounts = this.cacheQueryCounts.get(string);
            if (this.queryCounts == null) {
                this.queryCounts = new HashMap<String, Integer[]>();
            }
        }
        this.initializePartitionSelectionPanel(true);
    }

    private void initializePartitionSelectionPanel(boolean bl) {
        this.remove(this.partitionCheckBoxTable);
        this.remove(this.bottomPanel);
        List<String> list = this.mainPartitionPanel.getAggregatedHierarchies(this.currentDimensionName);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : this.orderedHierarchies) {
            if (!list.contains(object)) continue;
            arrayList.add(object);
        }
        HashMap hashMap = new HashMap();
        for (String string : this.orderedHierarchies) {
            List<String> list2 = this.partitionHierarchyLevelMetadataHelper.getHierarchyLevelNames(this.currentDimensionName, string);
            hashMap.put(string, list2);
        }
        this.partitionCheckBoxModel = new PartitionCheckBoxModel(arrayList, hashMap);
        this.partitionCheckBoxModel.setMaxGroupSelections(this.mainPartitionPanel.getMaxNumberOfPartitions());
        this.partitionCheckBoxTable.setModel(this.partitionCheckBoxModel);
        this.partitionCheckBoxTable.setAutoManageSelectionOrder(this.mainPartitionPanel.autoManagePartitionOrder());
        if (bl) {
            this.partitionCheckBoxTable.fullInitialize(this.cloneSelectionsForPartitionSelectionPanel(this.partitionSelections));
        } else {
            this.partitionCheckBoxTable.initialize(this.cloneSelectionsForPartitionSelectionPanel(this.partitionSelections));
        }
        this.partitionCheckBoxTable.registerObserver(this);
        this.c.gridy = 0;
        this.c.weighty = 0.0;
        this.c.fill = 1;
        this.add((Component)this.partitionCheckBoxTable, this.c);
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridy = 1;
        this.c.fill = 1;
        this.add((Component)this.bottomPanel, this.c);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void update(List<GroupCheckBoxSelection> list) {
        this.partitionSelections = this.cloneSelectionsFromPartitionSelectionPanel(list);
        this.mainPartitionPanel.populatePartitionTable(this.getPartitionSelections());
        this.refreshPartitionLevelNames();
        this.fieldValueChanged();
    }

    public void showAutomaticPartitionOrder() {
        if (this.mainPartitionPanel.autoManagePartitionOrder()) {
            this.partitionSelections = this.cloneSelectionsFromPartitionSelectionPanel(this.partitionCheckBoxTable.getSuperCheckBoxSelections());
            this.partitionCheckBoxTable.setAutoManageSelectionOrder(true);
            this.initializePartitionSelectionPanel(false);
            this.mainPartitionPanel.populatePartitionTable(this.getPartitionSelections());
            this.refreshPartitionLevelNames();
        } else {
            this.partitionCheckBoxTable.setAutoManageSelectionOrder(false);
        }
        this.revalidate();
        this.repaint();
    }

    public void refreshPartitionLevelNames() {
        ArrayList<HierarchyLevelWrapper> arrayList = new ArrayList<HierarchyLevelWrapper>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (GroupCheckBoxSelection groupCheckBoxSelection : this.partitionSelections) {
            arrayList.add(new HierarchyLevelWrapper(this.partitionHierarchyLevelMetadataHelper.getPartitionHierarchyLevelFromNames(this.currentDimensionName, groupCheckBoxSelection.getColumnName(), groupCheckBoxSelection.getCheckBoxName())));
            arrayList2.add(this.partitionCheckBoxTable.getLevelNamesForPartition(groupCheckBoxSelection.getColumnName(), groupCheckBoxSelection.getCheckBoxName()));
        }
        if (arrayList.size() > 0) {
            this.mainPartitionPanel.refreshPartitionLevelNames(arrayList, arrayList2);
        }
    }

    public void reorderPartitionSelections(List<String> list) {
        ArrayList<GroupCheckBoxSelection> arrayList = new ArrayList<GroupCheckBoxSelection>();
        for (String string : list) {
            int n = string.indexOf(".");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            arrayList.add(this.findPartitionSelection(string2, string3));
        }
        this.partitionSelections = arrayList;
        this.initializePartitionSelectionPanel(false);
    }

    private GroupCheckBoxSelection findPartitionSelection(String string, String string2) {
        GroupCheckBoxSelection groupCheckBoxSelection = null;
        for (GroupCheckBoxSelection groupCheckBoxSelection2 : this.partitionSelections) {
            if (!groupCheckBoxSelection2.getColumnName().equalsIgnoreCase(string) || !groupCheckBoxSelection2.getCheckBoxName().equalsIgnoreCase(string2)) continue;
            groupCheckBoxSelection = groupCheckBoxSelection2;
            break;
        }
        return groupCheckBoxSelection;
    }

    public void reorderPartitionSelectionsForNewHierarchyOrder() {
        ArrayList<GroupCheckBoxSelection> arrayList = new ArrayList<GroupCheckBoxSelection>();
        for (String string : this.orderedHierarchies) {
            List<GroupCheckBoxSelection> list = this.getPartitionSelectionsForHierarchy(string);
            for (GroupCheckBoxSelection groupCheckBoxSelection : list) {
                arrayList.add(groupCheckBoxSelection);
            }
        }
        this.partitionSelections = arrayList;
    }

    private List<GroupCheckBoxSelection> getPartitionSelectionsForHierarchy(String string) {
        ArrayList<GroupCheckBoxSelection> arrayList = new ArrayList<GroupCheckBoxSelection>();
        for (GroupCheckBoxSelection groupCheckBoxSelection : this.partitionSelections) {
            if (!groupCheckBoxSelection.getColumnName().equalsIgnoreCase(string)) continue;
            arrayList.add(groupCheckBoxSelection);
        }
        return arrayList;
    }

    public Integer[] getQueryCounts(String string) {
        Integer[] integerArray = null;
        if (this.queryCounts.get(string) != null) {
            integerArray = this.queryCounts.get(string);
        }
        return integerArray;
    }

    public void showQueryCounts(String string, Integer[] integerArray) {
        this.queryCounts.put(string, integerArray);
        this.partitionCheckBoxTable.showQueryCounts(string, integerArray);
    }

    private List<GroupCheckBoxSelection> cloneSelectionsForPartitionSelectionPanel(List<GroupCheckBoxSelection> list) {
        ArrayList<GroupCheckBoxSelection> arrayList = new ArrayList<GroupCheckBoxSelection>();
        for (GroupCheckBoxSelection groupCheckBoxSelection : list) {
            arrayList.add(new GroupCheckBoxSelection(groupCheckBoxSelection.getColumnName(), groupCheckBoxSelection.getCheckBoxName()));
        }
        return arrayList;
    }

    private List<GroupCheckBoxSelection> cloneSelectionsFromPartitionSelectionPanel(List<GroupCheckBoxSelection> list) {
        ArrayList<GroupCheckBoxSelection> arrayList = new ArrayList<GroupCheckBoxSelection>();
        for (GroupCheckBoxSelection groupCheckBoxSelection : list) {
            GroupCheckBoxSelection groupCheckBoxSelection2 = new GroupCheckBoxSelection(groupCheckBoxSelection.getColumnName(), groupCheckBoxSelection.getCheckBoxName());
            arrayList.add(groupCheckBoxSelection2);
        }
        return arrayList;
    }
}

