/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.olap.OLAPArb;
import oracle.olap.app.ui.RestrictedTextField;
import oracle.olap.cube.model.Cube;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.db.view.DimensionDisplay;
import oracle.olap.db.view.DimensionTree;
import oracle.olap.syntax.CubePrecomputeDimension;
import oracle.olap.syntax.PrecomputeConditionSyntax;
import oracle.olapi.syntax.SyntaxObject;

public class CubeAggregationPreComputePanel
extends BaseEditorPanel<Cube> {
    private JLabel infoTextLabel;
    private JLabel pctBottomLabel;
    private JLabel levelLabel;
    private JLabel pctLabel;
    private JLabel levelPrecomputeLabel;
    private RestrictedTextField pctBottomTextField;
    private DimensionTree levelTree;
    private boolean isCompressed;
    private boolean isPartitioned;

    public CubeAggregationPreComputePanel() {
        this.layoutComponents();
    }

    protected void initialisePanel() {
        Cube cube = (Cube)this.getUpdatedObject();
        this.isCompressed = cube.isCompress();
        this.isPartitioned = cube.isPartitioned();
        Integer n = cube.getPrecomputePercent();
        if (n != null) {
            this.pctBottomTextField.setText(String.valueOf(n));
        }
        this.setAggModeUI();
        this.initialiseTree(cube);
    }

    public void initialiseTree(Cube cube) {
        String string;
        Object object = this.getDataContext().get("dimensions");
        CubeDimension[] cubeDimensionArray = cube.getDimensions(object);
        this.levelTree.init(cubeDimensionArray);
        this.levelTree.setSelectedAll(false);
        if (!this.isCompressed && (string = cube.getPrecomputeCondition()) != null && string.length() > 0) {
            Map<String, Object> map = PrecomputeConditionSyntax.getInstance().fromSyntax(cube, cube.getDimensionMap(object), string);
            PrecomputeConditionSyntax.getInstance();
            List list = (List)map.get("CUBE_PRECOMPUTE_DIMENSIONS_KEY");
            for (CubePrecomputeDimension cubePrecomputeDimension : list) {
                List<CubeDimensionLevel> list2 = cubePrecomputeDimension.getPrecomputeLevels();
                for (CubeDimensionLevel cubeDimensionLevel : list2) {
                    this.levelTree.setSelected(cubeDimensionLevel, true);
                }
            }
        }
        this.levelTree.setExpandAll();
    }

    protected void commitPanel() {
        Object object;
        Cube cube = (Cube)this.getUpdatedObject();
        Cube cube2 = (Cube)this.getOriginalObject();
        String string = null;
        if (!this.isCompressed) {
            object = new ArrayList();
            Object object2 = this.getDataContext().get("dimensions");
            for (CubeDimension cubeDimension : cube.getDimensions(object2)) {
                CubeDimensionLevel cubeDimensionLevel;
                boolean bl = this.levelTree.isSelected(cubeDimension);
                Object object3 = cubeDimension.getLevels();
                int n = ((CubeDimensionLevel[])object3).length;
                for (int i = 0; i < n && !(bl = this.levelTree.isSelected(cubeDimensionLevel = object3[i])); ++i) {
                }
                if (!bl) continue;
                object3 = new ArrayList();
                CubePrecomputeDimension cubePrecomputeDimension = new CubePrecomputeDimension(cube, cubeDimension.getName());
                for (CubeDimensionLevel cubeDimensionLevel2 : cubeDimension.getLevels()) {
                    bl = this.levelTree.isSelected(cubeDimensionLevel2);
                    if (!bl) continue;
                    object3.add(cubeDimensionLevel2);
                }
                cubePrecomputeDimension.setPrecomputeLevels((List<CubeDimensionLevel>)object3);
                object.add(cubePrecomputeDimension);
            }
            if (object.size() > 0) {
                HashMap hashMap = new HashMap();
                PrecomputeConditionSyntax.getInstance();
                hashMap.put("CUBE_PRECOMPUTE_DIMENSIONS_KEY", object);
                Object object4 = this.getDataContext().get("dimensions");
                String string2 = PrecomputeConditionSyntax.getInstance().toSyntax(cube, cube.getDimensionMap(object4), hashMap);
                if (cube2 != null) {
                    string = cube2.getPrecomputeCondition();
                    if (string != null) {
                        CubeDimension cubeDimension;
                        cubeDimension = SyntaxObject.fromSyntax((String)string, null);
                        SyntaxObject syntaxObject = SyntaxObject.fromSyntax((String)string2, null);
                        if (!cubeDimension.toSyntax().equals(syntaxObject.toSyntax())) {
                            cube.setPrecomputeCondition(string2);
                        } else {
                            cube.setPrecomputeCondition(string);
                        }
                    } else {
                        cube.setPrecomputeCondition(string2);
                    }
                } else {
                    cube.setPrecomputeCondition(string2);
                }
            } else {
                cube.setPrecomputeCondition(null);
            }
        }
        if (this.isCompressed && !this.isPartitioned) {
            object = this.pctBottomTextField.getText();
            int n = Integer.valueOf((String)object);
            cube.setPrecomputePercent(n);
        }
        if (this.isCompressed) {
            cube.setPrecomputeCondition(null);
        }
    }

    private void setAggModeUI() {
        boolean bl = !this.isCompressed;
        boolean bl2 = this.isCompressed && !this.isPartitioned;
        this.infoTextLabel.setVisible(this.isCompressed && this.isPartitioned);
        this.pctLabel.setEnabled(bl2);
        this.pctBottomLabel.setEnabled(bl2);
        this.pctBottomTextField.setEnabled(bl2);
        this.levelLabel.setEnabled(bl);
        this.levelPrecomputeLabel.setEnabled(bl);
        this.levelTree.setEnabled(bl);
    }

    private void layoutComponents() {
        this.infoTextLabel = new JLabel(OLAPArb.get("CUBE_AGGREGATION_PRECOMPUTE_VALUES_INSTRUCTIONS_TEXT"));
        this.infoTextLabel.setName("infoTextLabel");
        String string = OLAPArb.get("CUBE_AGGREGATION_PRECOMPUTE_LEVEL");
        this.levelLabel = new JLabel(string);
        this.levelLabel.setName("levelLabel");
        String string2 = OLAPArb.get("CUBE_AGGREGATION_PRECOMPUTE_COST");
        this.pctLabel = new JLabel(string2);
        this.pctLabel.setName("pctLabel");
        this.levelPrecomputeLabel = new JLabel(OLAPArb.get("CUBE_AGGREGATION_PRECOMPUTE_DESC"));
        this.levelPrecomputeLabel.setName("levelPrecomputeLabel");
        String string3 = OLAPArb.get("CUBE_AGGREGATION_PRECOMPUTE_BOTTOM_PCT");
        this.pctBottomLabel = new JLabel(string3);
        this.pctBottomLabel.setName("pctBottomLabel");
        this.pctBottomTextField = new RestrictedTextField(3);
        this.pctBottomTextField.setName("pctBottomTextField");
        this.pctBottomTextField.setFilterMode(2);
        this.pctBottomTextField.setMaximumLength(3);
        this.pctBottomTextField.setEditable(true);
        this.pctBottomTextField.setMaximumSize(new Dimension(300, 300));
        this.pctBottomLabel.setLabelFor(this.pctBottomTextField);
        this.levelTree = new DimensionTree();
        this.levelTree.remove(DimensionDisplay.HIERARCHIES);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add(this.infoTextLabel, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.pctLabel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.pctBottomLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.pctBottomTextField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.levelLabel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.levelPrecomputeLabel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.levelTree);
        jScrollPane.setName("levelTreePane");
        this.add(jScrollPane, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
    }
}

