/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.buildreports;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class BuildTimerComboBox
extends JComboBox {
    private transient Runnable buildRunnable;
    private Timer timer;
    private int refreshInterval = 0;

    public BuildTimerComboBox(Runnable runnable) {
        this.buildRunnable = runnable;
        this.init();
    }

    private void init() {
        this.timer = new Timer(this.refreshInterval * 1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTimerComboBox.this.buildRunnable.run();
            }
        });
        this.timer.setCoalesce(true);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("0");
        defaultComboBoxModel.addElement("5");
        defaultComboBoxModel.addElement("10");
        defaultComboBoxModel.addElement("15");
        defaultComboBoxModel.addElement("20");
        defaultComboBoxModel.addElement("25");
        defaultComboBoxModel.addElement("30");
        defaultComboBoxModel.addElement("60");
        defaultComboBoxModel.addElement("120");
        this.setModel(defaultComboBoxModel);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)BuildTimerComboBox.this.getSelectedItem();
                int n = Integer.parseInt(string);
                if (n > 0 && n != BuildTimerComboBox.this.refreshInterval) {
                    BuildTimerComboBox.this.refreshInterval = n;
                    BuildTimerComboBox.this.timer.stop();
                    BuildTimerComboBox.this.timer.setDelay(BuildTimerComboBox.this.refreshInterval * 1000);
                    BuildTimerComboBox.this.timer.start();
                } else if (n == 0) {
                    BuildTimerComboBox.this.timer.stop();
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            while (this.timer.isRunning()) {
                this.timer.stop();
            }
        } else if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public void setTimerDelay(int n) {
        String string = Integer.toString(n);
        try {
            SwingUtilities.invokeLater(this.buildRunnable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSelectedItem(string);
    }
}

